using System;
using System.Collections.Generic;
using System.Text;
using OFW.FieldProperties;
using OFW.Models;
namespace OFW.Database.Expressions
{
    /// <summary>
    /// ֘A\鎮
    /// </summary>
    public class RelationCondition : Expression
    {
        FieldProperty leftColumnSpec;
        FieldProperty rightColumnSpec;
        string relationCondition;

        /// <summary>
        /// \z
        /// </summary>
        /// <param name="leftColumn"></param>
        /// <param name="rightColumn"></param>
        public RelationCondition(string leftColumn, string rightColumn)
        {
            builtExpression = leftColumn + " = " + rightColumn;
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="leftColumn"></param>
        /// <param name="rightColumn"></param>
        /// <param name="relationalOperator"></param>
        public RelationCondition(string leftColumn, string rightColumn, string relationalOperator)
        {
            builtExpression = leftColumn + " " + relationalOperator + " " + rightColumn;
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="leftColumn"></param>
        /// <param name="rightColumn"></param>
        public RelationCondition(FieldProperty leftColumn, FieldProperty rightColumn)
        {
            builtExpression = leftColumn.FullName() + " = " + rightColumn.FullName();
            leftColumnSpec = leftColumn;
            rightColumnSpec = rightColumn;
            relationCondition = "=";
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="leftColumn"></param>
        /// <param name="rightColumn"></param>
        /// <param name="relationalOperator"></param>
        public RelationCondition(FieldProperty leftColumn, FieldProperty rightColumn, string relationalOperator)
        {
            builtExpression = leftColumn.FullName() + " " + relationalOperator + " " + rightColumn.FullName();
            leftColumnSpec = leftColumn;
            rightColumnSpec = rightColumn;
            this.relationCondition = relationalOperator;

        }
        public bool areEqual(Entity leftEntity, Entity rightEntity)
        {
            if (leftColumnSpec == null) return false;
            if (rightColumnSpec == null) return false;
            object leftValue = leftEntity.GetValue(leftColumnSpec.FieldName);
            object rightValue = rightEntity.GetValue(rightColumnSpec.FieldName);
            if (leftValue == null) return false;
            if (rightValue == null) return false;
            return leftValue.Equals(rightValue);

        }
        /// <summary>
        /// gݗ
        /// </summary>
        public override void buildExpression()
        {
            //鎖Ȃ
        }
    }
}
