using System;
using System.Collections.Generic;
using System.Text;

namespace OFW.Database.TableCommand
{
    /// <summary>
    /// 
    /// </summary>
    public class ComplexCondition : TableCommandCondition
    {
        List<TableCommandCondition> Conditions;

        #region constructors
        /// <summary>
        /// IuWFNg
        /// </summary>
        public ComplexCondition()
        {
            Conditions = new List<TableCommandCondition>();
        }

        #endregion
        /// <summary>
        /// Ԓǉ
        /// </summary>
        /// <param name="cond"></param>
        public void AddCondition(TableCommandCondition cond)
        {
            Conditions.Add(cond);
        }
        /// <summary>
        /// Ԓǉ
        /// </summary>
        /// <param name="op">Zq AND,OR,NOTȂ</param>
        /// <param name="cond"></param>
        public void AddCondition(string op, TableCommandCondition cond)
        {
            cond.ConditionOperator = op;
            Conditions.Add(cond);
        }
        /// <summary>
        /// ̏킷̕
        /// </summary>
        /// <returns>̏킷̕</returns>
        public override string BuildExpression()
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < Conditions.Count; i++)
            {
                TableCommandCondition cond = Conditions[i];
                b.Append(cond.ConditionOperator + " ( " + cond.BuildCondition() + " ) ");
            }
            return b.ToString();
        }
        /// <summary>
        /// ̏ɐݒ肳ꂽp[^
        /// </summary>
        /// <returns>̏ɐݒ肳ꂽp[^</returns>
        public override List<Parameter> GetParameters()
        {
            List<Parameter> list = new List<Parameter>();
            foreach (TableCommandCondition cond in Conditions)
            {
                list.AddRange(cond.GetParameters());
            }
            return list; ;
        }
    }
}
