using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using OFW.Util;
using OFW.FieldProperties;

namespace OFW.Database.TableCommand
{
    /// <summary>
    /// e[uփf[^ǉR}h
    /// </summary>
    public class TableInsertCommand : TableCommand
    {
        /// <summary>
        /// e[u
        /// </summary>
        public string TableName;
        /// <summary>
        /// J
        /// </summary>
        public List<TableCommandColumn> InsertColumns;
        /// <summary>
        /// 
        /// </summary>
        public List<TableCommandCondition> Where;

        #region constructors
        /// <summary>
        /// e[uփf[^ǉR}h
        /// </summary>
        /// <param name="tableName"></param>
        public TableInsertCommand(string tableName)
        {
            this.TableName = tableName;
            InsertColumns = new List<TableCommandColumn>();
            Where = new List<TableCommandCondition>();
            this.Command = new Command();

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="property"></param>
        /// <param name="value"></param>
        public void AddInsert(FieldProperties.FieldProperty property, object value)
        {
            TableCommandColumn c = new TableCommandColumn();
            c.TableName = property.TableName;
            c.ColumnName = "\"" +  property.FieldName + "\"";
            c.Expression = "@" + property.FieldName;
            Parameter param = new Parameter(c.Expression,property.SqlType(),value);
            param.Length = property.Length;
            param.Precision = property.Precision;
            param.Scale = property.Scale;
            c.AddParameter(param);
            this.InsertColumns.Add(c);


        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="c"></param>
        public void AddInsert(TableCommandColumn c)
        {
            this.InsertColumns.Add(c);


        }
        /// <summary>
        /// WHEREǉ
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhere(TableCommandCondition condition)
        {

            if (this.Where.Count > 0) condition.ConditionOperator = "AND";
            this.Where.Add(condition);
        }
        /// <summary>
        /// WHEREǉ
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhereAnd(TableCommandCondition condition)
        {

            if (this.Where.Count > 0) condition.ConditionOperator = "AND";
            this.Where.Add(condition);
        }
        /// <summary>
        /// WHEREǉ
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhereOr(TableCommandCondition condition)
        {


            if (this.Where.Count > 0) condition.ConditionOperator = "OR";
            this.Where.Add(condition);
        }

        #endregion
        /// <summary>
        /// SQL
        /// </summary>
        /// <returns></returns>
        public override void BuildQuery()
        {
            StringBuilder b = new StringBuilder();
            b.Append("INSERT INTO " + TableName  + " ( " + Environment.NewLine) ;
            int c = 0;
            for (int i = 0; i < InsertColumns.Count; i++)
            {
                TableCommandColumn col = InsertColumns[i];


                if (c > 0) b.Append(",");
                b.Append(" " + col.ColumnName + Environment.NewLine);
                c++;

            }
            b.Append(" ) VALUES ( " + Environment.NewLine);
            c = 0;
            for (int i = 0; i < InsertColumns.Count; i++)
            {
                TableCommandColumn col = InsertColumns[i];
                if (c > 0) b.Append(",");
                if (col.Expression != "")
                {
                    b.Append(" " + col.Expression + Environment.NewLine);
                }
                else
                {
                    b.Append(" @" + col.ColumnName + Environment.NewLine);
                }
                c++;

            }

            b.Append(" ) " + Environment.NewLine);
            //TODO: WHERE

            this.Command.Text = b.ToString();
        }

        /// <summary>
        /// p[^gݗ
        /// </summary>
        public override void BuildParameters()
        {
            if (Command == null) BuildCommand();
            //XṼp[^ݒ
            int c = 0;
            for (int i = 0; i < this.InsertColumns.Count; i++)
            {
                TableCommandColumn col = this.InsertColumns[i];

                List<Parameter> paramList = col.Parameters;
                for (int j = 0; j < paramList.Count; j++)
                {
                    Parameter p = paramList[j];

                    Parameter param = new Parameter(p);
                    Command.SetParameter(param);
                }
                c++;
            }
            //XṼp[^ݒ
            for (int i = 0; i < this.Where.Count; i++)
            {
                TableCommandCondition cond = this.Where[i];
                List<Parameter> paramList = cond.GetParameters();
                for (int j = 0; j < paramList.Count; j++)
                {
                    Parameter p = paramList[j];

                    Parameter param = new Parameter(p);
                    Command.SetParameter(param);
                }

            }
            return;
        }
    }
}
