using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using OFW.Util;
using OFW.FieldProperties;

namespace OFW.Database.TableCommand
{
    /// <summary>
    /// e[uI
    /// </summary>
    public class TableSelectCommand : TableCommand
    {
        /// <summary>
        /// e[u
        /// </summary>
        public string TableName;
        /// <summary>
        /// ݒ
        /// </summary>
        public string Modifier;
        /// <summary>
        /// J
        /// </summary>
        public List<TableCommandColumn> SelectColumns;
        /// <summary>
        /// 
        /// </summary>
        public List<TableCommandCondition> Where;

        /// <summary>
        /// 
        /// </summary>
        public List<TableCommandColumn> OrderBy;
        /// <summary>
        /// O[v
        /// </summary>
        public List<TableCommandColumn> GroupBy;
        /// <summary>
        /// O[v̐
        /// </summary>
        public List<TableCommandCondition> Having;

        /// <summary>
        /// f[^SELECTR}h
        /// </summary>
        public TableSelectCommand() : base()
        {
            this.TableName = "";
            this.SelectColumns = new List<TableCommandColumn>();
            this.Where = new List<TableCommandCondition>();
            this.GroupBy = new List<TableCommandColumn>();
            this.OrderBy = new List<TableCommandColumn>();
            this.Having = new List<TableCommandCondition>();

            this.Command = new Command();
        }
        /// <summary>
        /// f[^SELECTR}h
        /// </summary>
        /// <param name="tableName"></param>
        /// 
        public TableSelectCommand(string tableName) 
        {
            this.TableName = tableName;
            this.SelectColumns = new List<TableCommandColumn>();
            this.Where = new List<TableCommandCondition>();
            this.GroupBy = new List<TableCommandColumn>();
            this.OrderBy = new List<TableCommandColumn>();
            this.Having = new List<TableCommandCondition>();

            this.Command = new Command();
        }
        /// <summary>
        /// f[^SELECTR}h
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="alias"></param>
        public TableSelectCommand(string tableName,string alias)
        {
            this.TableName = tableName;
            this.SelectColumns = new List<TableCommandColumn>();
            this.Where = new List<TableCommandCondition>();
            this.GroupBy = new List<TableCommandColumn>();
            this.OrderBy = new List<TableCommandColumn>();
            this.Having = new List<TableCommandCondition>();

            this.Command = new Command();
        }
        /// <summary>
        /// Iǉ
        /// </summary>
        /// <param name="column"></param>
        public void AddSelect(TableCommandColumn column)
        {
            this.SelectColumns.Add(column);

        }
        /// <summary>
        /// Iǉ
        /// </summary>
        /// <param name="property"></param>
        public void AddSelect(FieldProperties.FieldProperty property)
        {
            TableCommandColumn c = new TableCommandColumn();
            c.TableName = property.TableName;
            c.ColumnName = property.FieldName;

            this.SelectColumns.Add(c);

        }
        /// <summary>
        /// Iǉ
        /// </summary>
        /// <param name="property"></param>
        /// <param name="expr"></param>
        public void AddSelect(FieldProperties.FieldProperty property,string expr)
        {
            TableCommandColumn c = new TableCommandColumn();
            c.TableName = property.TableName;
            c.ColumnName = property.FieldName;
            c.Expression = expr;
            this.SelectColumns.Add(c);

        }
        /// <summary>
        /// WHEREǉ ftHg AND
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhere(TableCommandCondition condition)
        {

            if (this.Where.Count > 0) condition.ConditionOperator = "AND";
            this.Where.Add(condition);
        }
        /// <summary>
        /// WHEREǉ AND
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhereAnd(TableCommandCondition condition)
        {

            if (this.Where.Count > 0) condition.ConditionOperator = "AND";
            this.Where.Add(condition);
        }
        /// <summary>
        /// WHEREǉ OR
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhereOr(TableCommandCondition condition)
        {


            if (this.Where.Count > 0) condition.ConditionOperator = "OR";
            this.Where.Add(condition);
        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="property"></param>
        public void AddOrderBy(FieldProperties.FieldProperty property)
        {
            TableCommandColumn c = new TableCommandColumn();
            c.TableName = property.TableName;
            c.ColumnName = property.FieldName;
            c.Expression = c.FullName() + " " + " ASC";
            this.OrderBy.Add(c);

        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="property"></param>
        /// <param name="direction"></param>
        public void AddOrderBy(FieldProperties.FieldProperty property,string direction)
        {
            TableCommandColumn c = new TableCommandColumn();
            c.TableName = property.TableName;
            c.ColumnName = property.FieldName;
            c.Expression = c.FullName() + " " + direction;
            this.OrderBy.Add(c);

        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="property"></param>
        public void AddGroupBy(FieldProperties.FieldProperty property)
        {
            TableCommandColumn c = new TableCommandColumn();
            c.TableName = property.TableName;
            c.ColumnName = property.FieldName;
            this.GroupBy.Add(c);

        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="condition"></param>
        public void AddHaving(TableCommandCondition condition)
        {

            if (this.Having.Count > 0) condition.ConditionOperator = "AND";
            this.Having.Add(condition);
        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="condition"></param>
        public void AddHavingAnd(TableCommandCondition condition)
        {

            if (this.Having.Count > 0) condition.ConditionOperator = "AND";
            this.Having.Add(condition);
        }
        /// <summary>
        /// O[vǉ
        /// </summary>
        /// <param name="condition"></param>
        public void AddHavingOr(TableCommandCondition condition)
        {


            if (this.Having.Count > 0) condition.ConditionOperator = "OR";
            this.Having.Add(condition);
        }
        /// <summary>
        /// p[^
        /// </summary>
        public override void BuildParameters()
        {
            //IɃp[^nƂ͕s\
            //̃p[^ݒ
            for (int i = 0; i < this.Where.Count; i++)
            {
                TableCommandCondition cond = this.Where[i];
                List<Parameter> plist = cond.GetParameters();
                for (int j = 0; j < plist.Count; j++)
                {
                    Parameter p = plist[j];

                    Parameter param = new Parameter(p);
                    Command.Parameters.Add(param);
                }

            }
            return;
        }
        /// <summary>
        /// SQL
        /// </summary>
        /// <returns></returns>
        public override void BuildQuery()
        {
            StringBuilder b = new StringBuilder();
            b.Append("SELECT ");
            if (this.Modifier != "")
            {
                b.Append(this.Modifier);
            }
            b.Append(Environment.NewLine);
            if (this.SelectColumns.Count == 0)
            {
                b.Append("*");
            }
            else
            {
                b.Append(BuildSelectList());
            }
            b.Append(string.Format(" FROM {0} ", this.TableName));
            if (this.Where.Count > 0)
            {
                b.Append(" WHERE ");
                b.Append(BuildWhere());

            }
            if (this.OrderBy.Count > 0)
            {
                b.Append(" ORDER BY ");
                b.Append(BuildOrderBy());
            }
            if (this.GroupBy.Count > 0)
            {
                b.Append(" GROUP BY");
                b.Append(BuildGroupBy());
            }
            if (this.Having.Count > 0)
            {
                b.Append(" HAVING ");
                b.Append(BuildHaving());
            }
            this.Command.Text = b.ToString();
        }
        /// <summary>
        /// I\z
        /// </summary>
        /// <returns></returns>
        public string BuildSelectList()
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.SelectColumns.Count; i++)
            {
                TableCommandColumn col = this.SelectColumns[i];
                if (i > 0) b.Append(",");
                b.Append(string.Format(" {0} AS {1} ", col.FullName(), col.Alias()));
                b.Append(Environment.NewLine);

            }
            return b.ToString();
        }
        /// <summary>
        /// where\z
        /// </summary>
        /// <returns></returns>
        public string BuildWhere()
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.Where.Count; i++)
            {
                TableCommandCondition cond = this.Where[i];
                if (!string.IsNullOrEmpty(cond.ConditionOperator)) b.Append(" " + cond.ConditionOperator + " ");
                b.Append(" " + cond.BuildCondition() + Environment.NewLine);
            }
            return b.ToString();
        }
        /// <summary>
        ///  \z
        /// </summary>
        /// <returns></returns>
        public string BuildOrderBy()
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.OrderBy.Count; i++)
            {
                if (i > 0) b.Append(",");
                TableCommandColumn col = this.OrderBy[i];
                b.Append(" " + col.FullName() + Environment.NewLine);

            }
            return b.ToString();
        }
        /// <summary>
        /// O[v\z
        /// </summary>
        /// <returns></returns>
        public string BuildGroupBy()
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.GroupBy.Count; i++)
            {
                if (i > 0) b.Append(",");
                TableCommandColumn col = this.GroupBy[i];
                b.Append(" " + col.FullName() + Environment.NewLine);

            }
            return b.ToString();
        }
        /// <summary>
        /// O[v \z
        /// </summary>
        /// <returns></returns>
        public string BuildHaving()
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.Having.Count; i++)
            {
                TableCommandCondition cond = this.Having[i];
                b.Append(" " + cond.BuildCondition() + Environment.NewLine);

            }
            return b.ToString();
        }
    }
}
