using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using OFW.Util;
using OFW.FieldProperties;
namespace OFW.Database.TableCommand
{
    /// <summary>
    /// e[uփf[^XVR}h
    /// </summary>
    public class TableUpdateCommand : TableCommand
    {
        /// <summary>
        /// e[u
        /// </summary>
        public string TableName;
        /// <summary>
        /// J
        /// </summary>
        public List<TableCommandColumn> UpdateColumns;
        /// <summary>
        /// 
        /// </summary>
        public List<TableCommandCondition> Where;


        /// <summary>
        /// e[uփf[^XVR}h
        /// </summary>
        /// <param name="tname"></param>
        public TableUpdateCommand(string tname)
        {
            this.TableName = tname;
            this.Where = new List<TableCommandCondition>();
            this.UpdateColumns = new List<TableCommandColumn>();

            this.Command = new Command();

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="property"></param>
        /// <param name="value"></param>
        public void AddUpdate(FieldProperties.FieldProperty property, object value)
        {
            TableCommandColumn c = new TableCommandColumn();
            c.TableName = property.TableName;
            c.ColumnName = property.FieldName;
            c.Expression = "@" + property.FieldName;
            Parameter param = new Parameter(c.Expression, property.SqlType(),value);
            param.Length = property.Length;
            param.Precision = property.Precision;
            param.Scale = property.Scale;
            c.AddParameter(param);
            this.UpdateColumns.Add(c);


        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="c"></param>
        public void AddUpdate(TableCommandColumn c)
        {
            this.UpdateColumns.Add(c);


        }
        /// <summary>
        /// whereǉ ftHg AND
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhere(TableCommandCondition condition)
        {

            if (this.Where.Count > 0) condition.ConditionOperator = "AND";
            this.Where.Add(condition);
        }
        /// <summary>
        /// whereǉ AND
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhereAnd(TableCommandCondition condition)
        {

            if (this.Where.Count > 0) condition.ConditionOperator = "AND";
            this.Where.Add(condition);
        }
        /// <summary>
        /// whereǉ OR
        /// </summary>
        /// <param name="condition"></param>
        public void AddWhereOr(TableCommandCondition condition)
        {


            if (this.Where.Count > 0) condition.ConditionOperator = "OR";
            this.Where.Add(condition);
        }
        /// <summary>
        /// SQL
        /// </summary>
        /// <returns></returns>
        public override void BuildQuery()
        {
            StringBuilder b = new StringBuilder();
            b.Append("UPDATE " + TableName + " SET " + Environment.NewLine);
            int c = 0;
            for (int i = 0; i < UpdateColumns.Count; i++)
            {
                TableCommandColumn col = UpdateColumns[i];

                if (c > 0) b.Append(",");
                b.Append(" " + col.ColumnName + " = " + col.Expression + Environment.NewLine);

                c++;

            }
            if (this.Where.Count > 0)
            {
                b.Append(" WHERE ");
                for (int i = 0; i < Where.Count; i++)
                {
                    TableCommandCondition cond = Where[i];
                    if (!string.IsNullOrEmpty(cond.ConditionOperator)) b.Append(" " + cond.ConditionOperator + " ");
                    b.Append(" " + cond.BuildCondition() + Environment.NewLine);

                }
            }

            this.Command.Text = b.ToString();
        }

        /// <summary>
        /// p[^gݗ
        /// </summary>
        public override void BuildParameters()
        {
            if (Command == null) BuildCommand();
            //XṼp[^ݒ
            int c = 0;
            for (int i = 0; i < this.UpdateColumns.Count; i++)
            {
                TableCommandColumn col = this.UpdateColumns[i];

                List<Parameter> paramList = col.Parameters;
                for (int j = 0; j < paramList.Count; j++)
                {
                    Parameter p = paramList[j];

                    Parameter param = new Parameter(p);
                    Command.SetParameter(param);
                }
                c++;
            }
            //XṼp[^ݒ
            for (int i = 0; i < this.Where.Count; i++)
            {
                TableCommandCondition cond = this.Where[i];
                List<Parameter> paramList = cond.GetParameters();
                for (int j = 0; j < paramList.Count; j++)
                {
                    Parameter p = paramList[j];

                    Parameter param = new Parameter(p);
                    Command.SetParameter(param);
                }

            }
            return;
        }
    }
}
