using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;
using OFW.Models;
using OFW.Web.Auth.Model;

namespace OFW.Web.Auth.Model
{
    /// <summary>
    /// table auth_auto_loginɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class AuthAutoLoginTableProperty : EntityProperty
    {
		///<summary>[login_id]</summary>
		public FieldProperty LoginId;
		///<summary>[random_key]</summary>
		public FieldProperty RandomKey;
		///<summary>[identity_data_type]</summary>
		public FieldProperty IdentityDataType;
		///<summary>[identity_data]</summary>
		public FieldProperty IdentityData;
		///<summary>[expire_date]</summary>
		public FieldProperty ExpireDate;
		

	    /// <summary>
	    /// default construct
	    /// </summary>
        public AuthAutoLoginTableProperty()
        {
        	this.EntityName = "auth_auto_login";
			LoginId = FieldProperty.NewInstance("varchar", "auth_auto_login", "login_id","[login_id]", 64, 0, 0, false, "",true);
			RandomKey = FieldProperty.NewInstance("varchar", "auth_auto_login", "random_key","[random_key]", 100, 0, 0, false, "",true);
			IdentityDataType = FieldProperty.NewInstance("varchar", "auth_auto_login", "identity_data_type","[identity_data_type]", 100, 0, 0, false, "",false);
			IdentityData = FieldProperty.NewInstance("varchar", "auth_auto_login", "identity_data","[identity_data]", 4000, 0, 0, false, "",false);
			ExpireDate = FieldProperty.NewInstance("datetime", "auth_auto_login", "expire_date","[expire_date]", 16, 23, 3, false, null,false);
			
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerator<FieldProperty> GetFields()
        {
			yield return this.LoginId;
			yield return this.RandomKey;
			yield return this.IdentityDataType;
			yield return this.IdentityData;
			yield return this.ExpireDate;
			
        }
        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerator<FieldProperty> GetPrimaryKeys()
        {
            yield return  this.LoginId;
            yield return  this.RandomKey;
            
        }
    }
}