using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using OFW.Util;

namespace OFW.Web.Util
{
    /// <summary>
    /// t@CAbv[hT|[g
    /// </summary>
    public class Upload
    {
        /// <summary>
        /// 傫ȃt@Cꍇ̃obt@TCY
        /// </summary>
        public const int READ_BUFFER_SIZE = 1024000;
        /// <summary>
        /// asp:FileUploadRg[gpAbv[h̎t
        /// </summary>
        /// <param name="destinationFileName">ۑ̃t@C</param>
        /// <param name="fileUpload">t@CAbv[hT[o[Rg[</param>
        /// <returns>ۑt@C̃TCY</returns>
        /// <example>
        /// <code>
        /// //HTML"uploadfile"ƂăAbv[hRg[zu
        /// //aspx
        /// &lt;ASP:FIleUpload ID="uploadfile" runat="server" /&gt;
        /// //T[o["c:\doc\document.txt"ɕۑ
        /// //aspx.cs
        /// Upload upload = new Upload();
        /// int rc = upload.SaveU("c:\doc\document.txt",this.Request);
        /// </code>
        /// </example>
        public int Save(string destinationFileName, FileUpload fileUpload)
        {
            //TODO:t@Cw肳ȂƂ̏
            if (fileUpload.PostedFile.FileName == "")
            {
                return 0;
            }
            //TODO:̃t@Cw肳ꂽƂ̌x
            //[U[݂Ȃt@Cw肵̂̃t@Cw肵͕̂sB
            if (fileUpload.PostedFile.ContentLength == 0)
            {
                return 0;
            }


            BinaryReader reader = new BinaryReader(fileUpload.PostedFile.InputStream);
            byte[] data = reader.ReadBytes(fileUpload.PostedFile.ContentLength);
            reader.Close();
            return WriteBinary(destinationFileName, data, FileMode.Create);
        }
        /// <summary>
        /// multipart/form-dataɂAbv[h̎t
        /// </summary>
        /// <param name="destinationFilename">ۑt@C</param>
        /// <param name="parameterName">wp[^(input name=""Ɏw肳閼)</param>
        /// <param name="request">y[WRequestIuWFNg</param>
        /// <returns>ۑt@C̃TCY</returns>
        /// <remarks>RequestIuWFNgaParamNameŎw肳ꂽAbv[ht@CǂݎۑfBNgɕۑ<br />
        /// ۑt@C̓Abv[ht@C̉E[
        /// </remarks>
        /// <example>
        /// <code>
        /// //HTML"uploadfile"ƂăAbv[hRg[zu
        /// //aspx
        /// <input type="file" name="uploadfile"></input>
        /// 
        /// //T[o["c:\doc\"ɕۑ
        /// //aspx.cs
        /// HttpFile httpFile = new HttpFile();
        /// int rc = httpFile.SaveUploadFile("c:\doc\","uploadfile",this.Request);
        /// </code>
        /// </example>
        public int Save(string destinationFilename, string parameterName, HttpRequest request)
        {
            HttpPostedFile postedFile = request.Files[parameterName];
            if (postedFile == null) return 0;
            if (postedFile.FileName == "") return 0;
            if (postedFile.ContentLength == 0) return 0;
            string baseName = "";
            int lastPos = postedFile.FileName.LastIndexOf('\\');
            baseName = postedFile.FileName.Substring(lastPos + 1);
            if (baseName == "") return 0;

            BinaryReader reader = new BinaryReader(postedFile.InputStream);
            byte[] data = reader.ReadBytes(postedFile.ContentLength);
            reader.Close();
            return WriteBinary(destinationFilename, data, FileMode.Create);
        }
        /// <summary>
        /// oCg̕ۑ
        /// </summary>
        /// <param name="path">ۑ</param>
        /// <param name="buffer">ۑoCg</param>
        /// <param name="mode">݃[h</param>
        /// <returns>񂾃oCg</returns>
        int WriteBinary(string path, byte[] buffer, FileMode mode)
        {
            int readLimit = buffer.Length;

            BinaryWriter writer = new BinaryWriter(new FileStream(path, mode, FileAccess.Write));
            writer.Write(buffer);
            writer.Close();

            return readLimit;
        }
        /// <summary>
        /// Abv[ht@C̃t@C擾
        /// </summary>
        /// <param name="fileUpload">FileUploadRg[̃CX^X</param>
        /// <returns>Abv[ht@C̃t@C</returns>
        public string GetUploadFileName(FileUpload fileUpload)
        {
            OFW.IO.FileSystem fs = OFW.IO.FileSystemFactory.GetInstance();
            return fs.GetFileName(fileUpload.FileName);
        }
        /// <summary>
        /// Abv[ht@C̃t@C擾
        /// </summary>
        /// <param name="request">NGXg{</param>
        /// <param name="parameterName">inputIuWFNgid</param>
        /// <returns>Abv[ht@C̃t@C</returns>
        public string GetUploadFileName(HttpRequest request, string parameterName)
        {
            HttpPostedFile postedFile = request.Files[parameterName];
            if (postedFile == null) return null;
            if (postedFile.FileName == "") return null;

            OFW.IO.FileSystem fs = OFW.IO.FileSystemFactory.GetInstance();
            return fs.GetFileName(postedFile.FileName);
        }
    }
}
