using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using OFW.Forms;
using OFW.Forms.Filters;
using OFW.FieldProperties;
using OFW.Validators;
using OFW.Util;

namespace OFW.Windows.Forms.Adapters
{
    /// <summary>
    /// eLXg{bNX
    /// </summary>
    public class TextBoxAdapterElement : OFW.Forms.FormAdapterElement
    {
        TextBox theControl;

        string outputFormat;
        /// <summary>
        /// ftHg
        /// </summary>
        public TextBoxAdapterElement()
        {

        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="control">eLXg{bNX</param>
        /// <param name="filter">KptB^[</param>
        /// <param name="validator">Kpof[^</param>
        public TextBoxAdapterElement(TextBox control,Filter filter,FieldValidator validator)
        {
            this.theControl = control;
            if (filter == null) this.filter = new DefaultFilter();
            else this.filter = filter;

            if (validator == null) this.validator = new DefaultValidator();
            else this.validator = validator;

            this.outputFormat = "";
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="control">eLXg{bNX</param>
        /// <param name="filter">KptB^[</param>
        /// <param name="validator">Kpof[^</param>
        /// <param name="format">o̓tH[}bg</param>
        public TextBoxAdapterElement(TextBox control, Filter filter, FieldValidator validator, string format)
        {
            this.theControl = control;
            if (filter == null) this.filter = new DefaultFilter();
            else this.filter = filter;

            if (validator == null) this.validator = new DefaultValidator();
            else this.validator = validator;

            this.outputFormat = format;

        }
        /// <summary>
        /// Rg[̒l荞
        /// </summary>
        public override void UpdateField()
        {
            this.theValue = this.filter.FilterValue(this.theControl.Text);

        }
        /// <summary>
        /// \
        /// </summary>
        public override void Render()
        {
            if (this.isValid)
            {
                
                 this.theControl.Text = formatValue(theValue);
            }
            else
            {
                this.theControl.Text = OFW.Util.StringUtil.StringValue(this.theValue);
            }
        }
        private string formatValue(object value)
        {
            string formatted = "";
            if (this.outputFormat == "") formatted = OFW.Util.StringUtil.StringValue(value);
            else
            {
                string sfFormatString = "{0:" + this.outputFormat + "}";
                formatted = string.Format(sfFormatString, value);
            }
            return formatted;
        }
        /// <summary>
        /// tH[JXAEgɃtB^[Kp邩
        /// </summary>
        public override bool FilterOnBlur
        {
            get
            {
                return base.FilterOnBlur;
            }
            set
            {
                base.FilterOnBlur = value;
                if(filterOnBlur) this.theControl.Leave += blurHandler;
            }
        }
        /// <summary>
        /// tH[JXAEg̃tB^[Kp
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void blurHandler(object sender, EventArgs e)
        {
            this.theControl.Text = formatValue( this.filter.FilterValue(this.theControl.Text) );
        }
    }
}
