using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace OFW.Acl
{

    /// <summary>
    /// ANZXs
    /// </summary>
    /// <remarks>ANZX̊{@\񋟂B
    /// <p>P̂łx͎gpł邪Aʏ̓ANZXe[u݂̍菈ȂǃJX^}CY邽߂ɃTuNX쐬Čf[^Ȃǂǂݍނ悤ɂBTuNXꂽꍇł̋@\̗p҂̃R[fBOύXȂ߂ɒڂ̃CX^X͂AclFactory#GetInstancegăCX^X𓾂B</p></remarks>
    /// <example>{IȎg
    /// <code>AccessControl acl = AclFactory.getInstance();
    /// //\[X:[U[o^A@\
    /// acl.AddResource("user",null);
    /// //\[X:[U[ҏW@\ [U[o^A@\̎q\[XƂēo^
    /// acl.AddrResource("useredit","users");
    /// //\[X:[U[@\ [U[o^A@\̎q\[XƂēo^
    /// acl.AddrResource("usersearch","users");
    /// 
    /// //[:Ǘ
    /// acl.AddRole("admin",null);
    /// //[:o^[U[
    /// acl.AddRole("users",null);
    /// //[:[U[
    /// acl.AddRole("anonymouse",null);
    /// 
    /// //Ǘ҂ɂ͑Sċ
    /// acl.AddRule("user","admin",AclPrivilege.All);
    /// //o^[U[ɂ̓[U[o^A@\̓ǎ悾
    /// acl.AddRule("useredit","users",AclPrivilege.Read);
    /// //̃[̂ƁAo^[U[ɂ̓[U[@\ׂċ
    /// acl.AddRule("usersearch","users",AclPrivilege.All);
    /// //[U[ɂ͉Ȃ
    /// acl.AddRule("user","anonymouse",AclPrivilege.None);
    /// 
    /// //F؏
    /// Identity id = authProvider.getIdentity();
    /// //o^@\̓ǎ挠邩`FbN
    /// bool allowed = acl.IsAllowed("useredit",AclPrivilege.Read,id.Roles);
    /// </code>
    /// ̃NX@\邽߂app.configaclݒ肪KvB
    /// <code>  &lt;acl
    /// providerClass="OFW.Acl.DbAcl,OFW.Acl" -- NX̌^B`ĂAZûKv
    /// connection="acl" -- f[^ڑgꍇ̐ڑ於
    /// />
    /// </code>
    /// </example>
    public class AccessControl
    {
        static OFW.Log.Logger logger = OFW.Log.LoggerFactory.GetLogger("OFW.debug", MethodBase.GetCurrentMethod().DeclaringType.Name);
        /// <summary>
        /// ݒ
        /// </summary>
        protected AclConfigSection config;
        /// <summary>
        /// \[X̃c[
        /// </summary>
        protected IAclResource resourceTree;
        /// <summary>
        /// [̃c[
        /// </summary>
        protected IAclRole roleTree;
        /// <summary>
        /// (nameł̌p)\[X̃CfbNX
        /// </summary>
        protected Dictionary<string, IAclResource> resourceIndex;
        /// <summary>
        /// (nameł̌p)[̃CfbNX
        /// </summary>
        protected Dictionary<string, IAclRole> roleIndex;

        /// <summary>
        /// [
        /// </summary>
        protected List<IAclRule> rules;
        /// <summary>
        /// \z
        /// </summary>
        public AccessControl()
        {
            //rootvf͒ǉĂB
            resourceTree = new AclResource();
            roleTree = new AclRole();

            resourceIndex = new Dictionary<string, IAclResource>();
            roleIndex = new Dictionary<string, IAclRole>();

            this.rules = new List<IAclRule>();

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="config">ɎgpaclݒB</param>
        public void Init(AclConfigSection config)
        {
            this.config = config;
        }
        /// <summary>
        /// \[XǉB
        /// </summary>
        /// <param name="name">ǉ郊\[X̖</param>
        /// <param name="parentName">ǉ郊\[X̐eBnull̎̓\[Xc[̃gbvxɍ쐬</param>
        /// <returns>ǉ\[XIuWFNg</returns>
        public IAclResource AddResource(string name, string parentName)
        {
            IAclResource resource = new AclResource();
            resource.name = name;

            IAclResource parent = FindResourceByName(parentName);
            if (parent != null)
            {
                parent.appendChild(resource);
                
            }
            resourceIndex.Add(name,resource);
            return resource;
        }
        /// <summary>
        /// roleǉB
        /// </summary>
        /// <param name="name">ǉ郍[̖</param>
        /// <param name="parentName">ǉ郍[̐eBnull̎̓[c[̃gbvxɍ쐬</param>
        /// <returns>ǉ[IuWFNg</returns>
        public IAclRole AddRole(string name, string parentName)
        {
            IAclRole role = new AclRole();
            role.name = name;

            IAclRole parent = FindRoleByName(parentName);
            if (parent != null)
            {
                parent.appendChild(role);

            }
            roleIndex.Add(name,role);
            return role;
        }
        /// <summary>
        /// [ǉ
        /// </summary>
        /// <param name="resourceName">[쐬郊\[X̖</param>
        /// <param name="roleName">[쐬郍[̖</param>
        /// <param name="privilege"></param>
        /// <returns>ǉ[IuWFNg</returns>
        public IAclRule AddRule(string resourceName, string roleName, AclPrivilege privilege)
        {
            IAclResource resource = FindResourceByName(resourceName);
            if (resource == null) return null;

            IAclRole role = FindRoleByName(roleName);
            if (role == null) return null;

            IAclRule rule = new AclRule();
            rule.resourceName = resource.name;
            rule.roleName = role.name;
            rule.privilege = privilege;
            rules.Add(rule);
            return rule;
        }
        /// <summary>
        /// w胍[Ɏw胊\[Xւ̑삪Ă邩
        /// </summary>
        /// <param name="resourceName">Ώۂ̃\[X</param>
        /// <param name="privilege">Ώۂ̌</param>
        /// <param name="roles">Ώۂ̃[</param>
        /// <returns>Ă鎞true,łȂfalse</returns>
        public virtual bool IsAllowed(string resourceName, AclPrivilege privilege, IEnumerable<IAclRole> roles)
        {

            IAclResource resource = this.FindResourceByName(resourceName);
            //\[Xo^ĂȂ΁uANZX䂳ĂȂv= łłłB
            if (resource == null) return true;
            bool allow = false;
            bool ruleExists = false;
            IEnumerator<IAclRole> e = roles.GetEnumerator();
            //w肳ꂽ[SĂɂă[ċĂ郋[
            while(e.MoveNext()){
                IAclRole role = FindRoleByName( e.Current.name ); //nꂽ[uACLɒǉĂ郍[擾ꂽ킯ł͂Ȃv̂ŒTȂ
                //w胊\[X獪Ƀ\[Xc[ǂAĂ郋[
                IAclResource resourceNode = resource;
                while (resourceNode != null)
                {
                    //w胍[獪Ƀ\[Xc[ǂAĂ郋[
                    IAclRole roleNode = role;
                    while (roleNode != null)
                    {
                        RuleEnumerator resourceRules = new RuleEnumerator(this.rules, resourceNode);
                        while (resourceRules.MoveNext())
                        {
                            //ڎw肳Ă郋[΍̗p
                            if (resourceRules.Current.roleName == roleNode.name)
                            {
                                ruleExists = true;
                                allow = resourceRules.Current.isAllowed(privilege);
                                break;
                            }
                        }

                        if (ruleExists) break;                        
                        roleNode = roleNode.parent as IAclRole;
                    }

                    if (ruleExists) break;
                    resourceNode = resourceNode.parent as IAclResource;
                }
                if (ruleExists)
                {
                    if (allow) break; //ǂŋĂ瑼ŋۂĂĂ
                }
            }
            return allow;
        }
        /// <summary>
        /// w胍[ɂw胊\[Xւ̑삪ۂĂ邩
        /// </summary>
        /// <param name="resourceName">Ώۂ̃\[X</param>
        /// <param name="privilege">Ώۂ̌</param>
        /// <param name="roles">Ώۂ</param>
        /// <returns>ۂĂ鎞true,łȂfalse</returns>
        public virtual bool IsDenied(string resourceName, AclPrivilege privilege, List<IAclRole> roles)
        {
            return !IsAllowed(resourceName, privilege, roles); 
        }
        /// <summary>
        /// \[X𖼑OŒT
        /// </summary>
        /// <param name="name">Ώۃ\[X</param>
        /// <returns>ʂ̃\[XIuWFNg</returns>
        public IAclResource FindResourceByName(string name)
        {
            if (name == null) return resourceTree;
            if (resourceIndex.ContainsKey(name))
            {
                return resourceIndex[name];
            }
            else
            {
                return resourceTree;
            }
        }
        /// <summary>
        /// [𖼑OŒT
        /// </summary>
        /// <param name="name">Ώۂ̃[</param>
        /// <returns>ʂ̃[IuWFNg</returns>
        public IAclRole FindRoleByName(string name)
        {
            if (name == null) return roleTree;
            if (roleIndex.ContainsKey(name))
            {
                return roleIndex[name];
            }
            else
            {
                return roleTree;
            }
        }
        /// <summary>
        /// [U[ɕRÂ[擾
        /// ł͋̃XgԂB
        /// </summary>
        /// <param name="loginId">[U[ʂ郍OCID</param>
        /// <returns>[U[ɕRÂ[</returns>
        public virtual List<OFW.Acl.IAclRole> GetRolesByUser(string loginId)
        {
            return new List<IAclRole>();
        }

        /// <summary>
        /// [񋓌^
        /// </summary>
        class RuleEnumerator : IEnumerator<IAclRule>
        {
            int position;
            List<IAclRule> rules;
            IAclResource target;

            public RuleEnumerator(List<IAclRule> rules,IAclResource target)
            {
                this.rules = rules;
                this.target = target;
                position = -1;
            }
            #region IEnumerator<AclRule> o

            public IAclRule Current
            {
                get { return this.rules[this.position]; }
            }

            #endregion

            #region IDisposable o

            public void Dispose()
            {
                this.rules = null;
                this.target = null;
            }

            #endregion

            #region IEnumerator o

            object System.Collections.IEnumerator.Current
            {
                get { throw new Exception("The method or operation is not implemented."); }
            }

            public bool MoveNext()
            {
                this.position++;
                if (this.position > this.rules.Count) return false;
                int nextPosition = this.rules.FindIndex(position, delegate(IAclRule rule) { return (rule.resourceName == this.target.name); });

                if (nextPosition >= position)
                {
                    this.position = nextPosition;
                    return true;
                }
                else
                {
                    this.position = this.rules.Count;
                    return false;
                }
            }

            public void Reset()
            {
                this.position = -1;
            }

            #endregion
        }
        /// <summary>
        /// 
        /// </summary>
        public void DumpRoles()
        {
        }
        /// <summary>
        /// 
        /// </summary>
        public void DumpResources()
        {
        }
    }
}
