using System;
using System.Collections.Generic;
using System.Text;

namespace OFW.Acl
{
    /// <summary>
    /// ANZX̃[\
    /// </summary>
    /// <remarks>uNvuǂ̑Ώۂɑ΂āvu\v`B
    /// <p>郍[ɑ΂Ēڃ[ݒ肵ȂĂÃ[̐eɃ[݂΂̃[̗pB\[XlB</p>
    /// </remarks>
    [Serializable]
    public class AclRule : IAclRule
    {
        ///<summary>[id]</summary>
        protected Int32 _id;
        ///<summary>[id]</summary>
        public Int32 id{
            get{return _id;}
            set{_id = value;}
        }
        ///<summary>[resource_id]</summary>
        protected int _resourceId;
        ///<summary>[resource_id]</summary>
        public int resourceId
        {
            get{return _resourceId;}
            set{_resourceId = value;}
        }
        ///<summary>[role_id]</summary>
        protected int _roleId;
        ///<summary>[role_id]</summary>
        public int roleId
        {
            get{return _roleId;}
            set{_roleId = value;}
        }
        ///<summary>[description]</summary>
        protected string _description;
        ///<summary>[description]</summary>
        public string description{
            get{return _description;}
            set{_description = value;}
        }
        /// <summary>
        /// 
        /// 
        /// AclPrivileg̘_a
        /// </summary>
        protected AclPrivilege _privilege;
        /// <summary>
        /// 
        /// </summary>
        public AclPrivilege privilege
        {
            get { return _privilege; }
            set { _privilege = value; }
        }
        /// <summary>
        /// \[X
        /// </summary>
        protected string _resourceName;
        /// <summary>
        /// \[X
        /// </summary>
        public string resourceName
        {
            get { return _resourceName; }
            set { _resourceName = value; }
        }
        /// <summary>
        /// [
        /// </summary>
        protected string _roleName;
        /// <summary>
        /// [
        /// </summary>
        public string roleName
        {
            get { return _roleName; }
            set { _roleName = value; }
        }

        /// <summary>
        /// default construct 
        /// </summary>
        public AclRule()
            : base()
        {
            this._id = 0;
            this._resourceId = 0;
            this._roleId = 0;
            this._description = "";

            this._resourceName = "";
            this._roleName = "";
            this._privilege = AclPrivilege.None;
            
        }
        /// <summary>
        /// ̃[ɓ̌ݒ肳Ă邩`FbN
        /// </summary>
        /// <param name="priv">`FbN</param>
        /// <returns>`FbNݒ肳ĂtrueAłȂfalse</returns>
        public bool isAllowed(AclPrivilege priv)
        {
            AclPrivilege masked = (this.privilege & priv);

            return (masked == priv);
        }
        /// <summary>
        /// w茠
        /// </summary>
        /// <param name="priv">w</param>
        public void setAllowed(AclPrivilege priv)
        {
            this.privilege |= priv;
        }
        /// <summary>
        /// w茠
        /// </summary>
        /// <param name="priv">w</param>
        /// <param name="allow">/ۂ̃tO</param>
        public void setAllowed(AclPrivilege priv,bool allow)
        {
            if(allow) this.privilege |= priv;
            else this.privilege &= (AclPrivilege.All ^ priv);
        }
        /// <summary>
        /// `FbN
        /// </summary>
        /// <param name="priv"></param>
        /// <returns></returns>
        public bool isDenied(AclPrivilege priv)
        {
            AclPrivilege masked = (this.privilege & priv);

            return (masked != priv);
        }
        /// <summary>
        /// w茠ۂ
        /// </summary>
        /// <param name="priv">w</param>
        public void setDenied(AclPrivilege priv)
        {
            this.privilege &= (AclPrivilege.All ^ priv);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="priv">Ώی</param>
        public void allow(AclPrivilege priv)
        {
            this.privilege |= priv;
        }
        /// <summary>
        /// ۂ
        /// </summary>
        /// <param name="priv">Ώی</param>
        public void deny(AclPrivilege priv)
        {
            this.privilege &= (AclPrivilege.All ^ priv);
        }

        #region ITypedSerializable o

        /// <summary>
        /// ^(VACYp)
        /// </summary>
        [System.Xml.Serialization.XmlAttribute]
        public string __TypeName
        {
            get
            {
                return this.GetType().FullName;
            }
            set
            {
                //do nothing;
            }
        }

        #endregion
    }
}
