using System;
using System.Collections.Generic;
using System.Text;

namespace OFW.Auth
{
    /// <summary>
    /// pX[hnbV@̒`
    /// </summary>
    public abstract class AbstractPasswordHash
    {
        /// <summary>
        /// ݒ
        /// </summary>
        protected AuthConfigSection config;
        /// <summary>
        /// GR[h@
        /// </summary>
        protected string encoding;
        /// <summary>
        /// ̒(Saltedȃ\bhłgpȂBSMD5,SSHA)
        /// </summary>
        protected int saltLength;

        /// <summary>
        /// \z
        /// </summary>
        public AbstractPasswordHash()
        {
            config = (AuthConfigSection)OFW.Config.ConfigFactory.GetConfig().GetSection("authenticate");

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="method"></param>
        /// <param name="encoding"></param>
        /// <param name="saltLength"></param>
        /// <returns></returns>
        public static AbstractPasswordHash GetInstance(string method,string encoding,int saltLength)
        {
            AbstractPasswordHash hash = GetInstance(method);
            hash.encoding = encoding;
            hash.saltLength = saltLength;
            return hash;
        }
        /// <summary>
        /// nbV@ɑΉnbV@`̎𓾂
        /// </summary>
        /// <param name="method">nbV@</param>
        /// <returns>ΉnbV@`</returns>
        public static AbstractPasswordHash GetInstance(string method)
        {
            if (method == "MD5")
            {
                return new PasswordHashMD5();
            }
            if (method == "SHA")
            {
                return new PasswordHashSHA();
            }
            if (method == "SMD5")
            {
                return new PasswordHashSMD5();
            }
            if (method == "SSHA")
            {
                return new PasswordHashSSHA();
            }

            return new DefaultPasswordHash();
        }
        /// <summary>
        /// VnbV
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        public abstract string CreateHash(string input);
        /// <summary>
        /// ͒l̃nbVʂ̒lɂȂ邩
        /// </summary>
        /// <param name="input"></param>
        /// <param name="target"></param>
        /// <returns></returns>
        public abstract bool ValidateHash(string input,string target);
        /// <summary>
        /// GR[h
        /// </summary>
        /// <param name="bytes"></param>
        /// <returns></returns>
        public string Encode(byte[] bytes)
        {


            if (encoding == "BASE64")
            {
                return System.Convert.ToBase64String(bytes);
            }
            if (encoding == "HEX")
            {
                return OFW.Util.StringUtil.BytesToHexString(bytes);
            }
            if (encoding == "PLAIN")
            {
                return OFW.Util.StringUtil.BytesToString(bytes);

            }
            return "";
        }
        /// <summary>
        /// ͕̃fR[h
        /// </summary>
        /// <param name="s">͕</param>
        /// <returns>fR[hʂ̃oCgz</returns>
        public byte[] Decode(string s)
        {
            string encodeMethod = config.Encode;
            if (encoding == "BASE64")
            {
                return System.Convert.FromBase64String(s);
            }
            if (encoding == "HEX")
            {
                return OFW.Util.StringUtil.HexStringToBytes(s);
            }
            if (encoding == "PLAIN")
            {
                return OFW.Util.StringUtil.StringToBytes(s);

            }
            return new byte[0];
        }

    }
}
