using System;
using System.Collections.Generic;
using System.Text;
using OFW.Util;

namespace OFW.FieldProperties
{
    /// <summary>
    /// BoolpFieldProperty̎
    /// </summary>
    [Serializable]
    public  class BoolFieldProperty : FieldProperty
    {
        /// <summary>
        /// default constructor
        /// </summary>
        /// <remarks>FieldTypê݃Zbg</remarks>
        public BoolFieldProperty() : base()
        {
            this.FieldType = typeof(bool);
        }
        /// <summary>
        /// Rs[RXgN^ǂ
        /// </summary>
        /// <param name="p">ɂȂFieldProperty</param>
        /// <remarks>FieldProperty̏gp邪AʂłBoolƂĈꍇȂǂɎgp</remarks>
        public BoolFieldProperty(FieldProperty p)
            : base(p)
        {
            this.FieldType = typeof(bool);
            if (p.GetType() == this.GetType())
            {
            }
        }

        /// <summary>
        /// ftHgl
        /// </summary>
        /// <returns>ftHgl̕\</returns>
        public override string DefaultValueDisplay()
        {

            return NumberUtil.FormatBool(NumberUtil.BoolValue( this.DefaultValue),"true","false");
        }
        /// <summary>
        /// ő咷
        /// </summary>
        /// <returns>ő咷(1ł悢)</returns>
        public override int MaxLength
        {
            get{
                return 1;
            }
        }
        /// <summary>
        /// ftHgl
        /// </summary>
        public override object DefaultValue
        {
            get
            {
                return this.mDefaultValue;
            }
            set
            {
                this.mDefaultValue = NumberUtil.BoolValue( value );
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override object Clone()
        {
            return new BoolFieldProperty(this);
        }
    }
}
