using System;
using System.Collections.Generic;
using System.Text;
using OFW.Util;

namespace OFW.FieldProperties
{
    /// <summary>
    /// 10ipFieldProperty
    /// </summary>
    [Serializable()]
    public class DecimalFieldProperty : FieldProperty
    {
        /// <summary>
        /// ől
        /// </summary>
        private decimal mMaxValue = Decimal.MaxValue;
        /// <summary>
        /// ől
        /// </summary>
        /// <remarks>
        /// ͐xɊÂőlƐݒ肳ꂽől̏̒lԂ
        /// </remarks>
        public decimal MaxValue
        {
            get {
                string m = (new String('9', (this.Precision - this.Scale)));
                if (this.Scale > 0)
                {
                    m += "." + (new String('9', this.Scale));
                }
                decimal mm = Decimal.Parse(m);

                return (mMaxValue > mm) ? mm : mMaxValue; 
            }
            set { mMaxValue = value; }
        }
        /// <summary>
        /// ŏl
        /// </summary>
        private decimal mMinValue = Decimal.MinValue;
        /// <summary>
        /// ŏl
        /// </summary>
        /// <remarks>
        /// ͐xɊÂőlƐݒ肳ꂽől̑傫̒lԂ
        /// </remarks>
        public decimal MinValue
        {
            get {
                string m = (new String('9', (this.Precision - this.Scale)));
                if (this.Scale > 0)
                {
                    m += "." + (new String('9', this.Scale));
                }
                decimal mm = Decimal.Parse(m) * (-1);

                return (mMinValue < mm) ? mm : mMinValue; 
            }
            set { mMinValue = value; }
        }
        /// <summary>
        /// default constructor
        /// </summary>
        public DecimalFieldProperty()
        {
            FieldType = typeof(decimal);
            setup("decimal", "", "", "", 20, 18, 0, false, 0, false);
        }
        /// <summary>
        /// Rs[RXgN^ǂ
        /// </summary>
        /// <param name="p">ɂȂvpeB</param>
        public DecimalFieldProperty(FieldProperty p)
            : base(p)
        {
            FieldType = typeof(decimal);

            if (p.GetType() == this.GetType())
            {
                MaxValue = ((DecimalFieldProperty)p).MaxValue;
                MinValue = ((DecimalFieldProperty)p).MinValue;
            }
        }

        /// <summary>
        /// ő咷
        /// </summary>
        /// <returns>͂łő咷Ԃ</returns>
        public override int MaxLength
        {
            get
            {
                int max = this.Precision;

                //","؂̕
                max += (this.Precision - this.Scale - 1) / 3;
                //̕
                max += 1;
                //_̕
                max += 1;

                return max;
            }
        }
        /// <summary>
        /// ftHgl̕\
        /// </summary>
        /// <returns></returns>
        public override string DefaultValueDisplay()
        {

            return NumberUtil.Format(this.DefaultValue, "#");
        }
        /// <summary>
        /// ftHgl
        /// </summary>
        public override object DefaultValue
        {
            get
            {
                return this.mDefaultValue;
            }
            set
            {
                if (value == null)
                {
                    this.mDefaultValue = null;
                    return;
                }
                this.mDefaultValue = NumberUtil.Value<decimal?>(value);
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override object Clone()
        {
            return new DecimalFieldProperty(this);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="length"></param>
        /// <param name="precision"></param>
        /// <param name="scale"></param>
        public override void setSize(int length, int precision, int scale)
        {
            if ((length == 0) && (precision == 0) && (scale == 0)) return;
            if ((length != 0) && (precision == 0) && (scale == 0))
            {
                this.Length = 20; //K ۂɂprecisionɉlengthݒ肷ׂ
                this.Precision = length;
                return;
            }
            this.Length = 20; //K ۂɂprecisionɉlengthݒ肷ׂ
            this.Precision = precision;
            this.Scale = scale;


        }

    }
}
