using System;
using System.Collections.Generic;
using System.Text;
using OFW.Util;

namespace OFW.FieldProperties
{
    /// <summary>
    /// long pFieldProperty
    /// </summary>
    /// <seealso cref="IntFieldProperty"/>
    [Serializable()]
    public class LongFieldProperty : FieldProperty
    {
        /// <summary>
        /// ől
        /// </summary>
        public long MaxValue = Int64.MaxValue;
        /// <summary>
        /// ŏl
        /// </summary>
        public long MinValue = Int64.MinValue;

        /// <summary>
        /// ftHg̍\z
        /// </summary>
        public LongFieldProperty()
            : base()
        {
            FieldType = typeof(long);
            setup("bigint", "", "", "", 8, 19, 0, false, 0, false);

        }
        /// <summary>
        /// default construct
        /// </summary>
        /// <param name="entityName"></param>
        /// <param name="fieldName"></param>
        /// <param name="displayName"></param>
        public LongFieldProperty(string entityName, string fieldName, string displayName)
            : base()
        {

            FieldType = typeof(int);
            setup("bigint", entityName, fieldName, displayName, 8, 19, 0, false, 0, false);
        }

        /// <summary>
        /// Rs[RXgN^ǂ
        /// </summary>
        /// <param name="p"></param>
        public LongFieldProperty(FieldProperty p)
            : base(p)
        {
            FieldType = typeof(long);
            if (p.GetType() == this.GetType())
            {
                MaxValue = ((LongFieldProperty)p).MaxValue;
                MinValue = ((LongFieldProperty)p).MinValue;
            }
        }
        /// <summary>
        /// ͂łő̒
        /// </summary>
        /// <returns>J}A܂ށA͂łő̒</returns>
        public override int MaxLength
        {
            get
            {

                int max = this.Precision;

                //","؂̕
                max += (this.Precision - this.Scale - 1) / 3;
                //̕
                max += 1;

                return max;
            }
        }
        /// <summary>
        /// \pl
        /// </summary>
        /// <returns>\pl</returns>
        public override string DefaultValueDisplay()
        {
            return NumberUtil.Format(this.DefaultValue, "#");
        }
        /// <summary>
        /// ftHgl
        /// </summary>
        public override object DefaultValue
        {
            get
            {
                return this.mDefaultValue;
            }
            set
            {
                this.mDefaultValue = NumberUtil.Value<long?>(value);
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override object Clone()
        {
            return new LongFieldProperty(this);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="length"></param>
        /// <param name="precision"></param>
        /// <param name="scale"></param>
        public override void setSize(int length, int precision, int scale)
        {
            //length,scale͖B
            if (precision != 0) this.Precision = precision;
        }

    }
}
