using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace OFW.Log
{
    /// <summary>
    /// Oo͂Lv`[Ă܂Ƃ߂ďo
    /// </summary>
    public class LogCapture : IDisposable
    {
        /// <summary>
        /// o͐
        /// </summary>
        internal LogWriter writer;
        /// <summary>
        /// Lv`[
        /// </summary>
        List<LogCaptureItem> capturedItems;
        /// <summary>
        /// \zBLoggerKv
        /// </summary>
        /// <param name="writer"></param>
        internal LogCapture(LogWriter writer)
	    {
            this.writer = writer;
            capturedItems = new List<LogCaptureItem>();
	    }
        /// <summary>
        /// o͂Lv`[
        /// </summary>
        /// <param name="level">Ώۃx</param>
        /// <param name="method">s̃\bh</param>
        /// <param name="message">o͂郁bZ[W</param>
        public void log(LogLevel level,MethodBase method,object message)
        {
            capturedItems.Add(new LogCaptureItem(level,GetCurrentUserId(),method.DeclaringType.Name,method.Name,message));
        }
        /// <summary>
        /// o͂Lv`[
        /// </summary>
        /// <param name="level">Ώۃx</param>
        /// <param name="user">݂̃[U[</param>
        /// <param name="method">s̃\bh</param>
        /// <param name="message">o͂郁bZ[W</param>
        public void log(LogLevel level, OFW.Auth.IUser user, MethodBase method, object message)
        {
            capturedItems.Add(new LogCaptureItem(level, GetUserId(user), method.DeclaringType.Name, method.Name, message));
        }
        /// <summary>
        /// ̃ACeǉ
        /// </summary>
        /// <param name="item"></param>
        public void addItem(LogCaptureItem item)
        {
            capturedItems.Add(item);
        }
        /// <summary>
        /// ܂ĂLv`[fo
        /// </summary>
        public void flush()
        {
            writer.WriteCaptured(capturedItems);
            capturedItems.Clear();
        }
        /// <summary>
        /// ݂̃[U[ID
        /// </summary>
        /// <returns></returns>
        internal string GetCurrentUserId()
        {
            Auth.AuthProvider provider = Auth.AuthProviderFactory.GetInstance();
            if (provider.IsAuthenticated())
            {
                return provider.GetIdentity().User.Id;
            }
            return "";
        }
        /// <summary>
        /// ݂̃[U[ID
        /// </summary>
        /// <returns></returns>
        internal string GetUserId(OFW.Auth.IUser user)
        {
            if (user == null)
            {
                return "";
            }
            return user.Id;
        }


        #region IDisposable o
        /// <summary>
        /// Iɔj
        /// </summary>
        public void Dispose()
        {
            if (capturedItems.Count > 0)
            {
                flush();
            }
            this.writer = null;
        }

        #endregion
    }
}
