using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;
using OFW.Config;
namespace OFW.Log
{
    /// <summary>
    /// ^CX^vtTraceListenr
    /// </summary>
    /// <example>
    /// //C#
    /// System.Diagnostics.Trace.WriteLine("message"); // 2008/09/19 22:55:30.544 message Əo
    /// System.Diagnostics.Trace.WriteLine("message","Info");// 2008/09/19 22:55:30.544 [Info]message Əo
    ///
    /// //(web.config|app.config)
    ///  &lt;system.diagnostics>
    ///    &lt;switches>
    ///      &lt;add name="DebugTrace" value="1"/>
    ///    &lt;/switches>
    ///    
    ///    &lt;trace autoflush="true" >
    ///      &lt;listeners>
    ///        &lt;clear/>
    ///        &lt;add name="LogTraceListener" type="common.DailyTracer,LogTracer" baseName="log" baseDir="c:\hoge">&lt;/add>
    ///      &lt;/listeners>
    ///    &lt;/trace>
    ///  &lt;/system.diagnostics>
    /// //Lݒɂc:\hoge\log.20080919.log(2008/9/19ɎsƂ)Ƀg[Xo͂B
    /// </example>
    public class LogTraceListener : TraceListener
    {
        string _baseName;
        string _baseDir;

        StreamWriter _currentWriter;

        /// <summary>
        /// ftHg̍\z
        /// </summary>
        public LogTraceListener()
            : base()
        {
            this._baseDir = "";
            this._baseName = "";
            this._currentWriter = null;
        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="name"></param>
        public LogTraceListener(string name)
        {
            this._baseDir = "";
            this._baseName = "";
            this._currentWriter = null;
        }
        /// <summary>
        /// g[X
        /// </summary>
        public override void Close()
        {
            if (_currentWriter != null)
            {
                _currentWriter.Flush();
                _currentWriter.Close();
                _currentWriter = null;
            }
            base.Close();
        }
        /// <summary>
        /// g[Xo͂tbV
        /// </summary>
        public override void Flush()
        {
            if (_currentWriter != null)
            {
                //    _currentWriter.Flush(); //VJg
                _currentWriter.Flush();
            }
            base.Flush();
        }
        /// <summary>
        /// IuWFNgj
        /// </summary>
        /// <param name="disposing"></param>
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        /// <summary>
        /// T|[g
        /// </summary>
        /// <returns></returns>
        protected override string[] GetSupportedAttributes()
        {
            return new string[] { "baseDir", "baseName" };
        }
        /// <summary>
        /// writer擾
        /// </summary>
        /// <returns></returns>
        /// <remarks>
        /// writergpł΂writerԂ
        /// writerĂ/܂gpłȂȂVwriter𐶐ĕԂB<br />
        /// {[ɂ萶g[Xt@C̃t@CgpȂΈ莞ԑ҂ēx̃t@C̎gps邪A܂łĂJȂꍇt@CɘAԂtĎsB10񎎍ssO𑗏o
        /// </remarks>
        private StreamWriter getWriter()
        {
            if (_currentWriter != null) return _currentWriter;
            string filename = getTraceFileName(0);


            FileStream fs = null;
            StreamWriter writer = null;
            int numRetry = 0;
            int numFile = 0;
            while (writer == null)
            {
                try
                {
                    fs = new FileStream(filename, FileMode.Append, FileAccess.Write, FileShare.None);
                    writer = new StreamWriter(fs);
                    break;
                }
                catch
                {
                }
                numRetry++;
                if (numRetry > 10)
                {
                    numFile++;
                    if (numFile > 10) break;
                    filename = getTraceFileName(numFile);
                    numRetry = 0;
                }

                System.Threading.Thread.Sleep(100);
            }
            if (writer == null) throw new Exception("trace file cannot be created " + _baseDir + "/" + _baseName);
            _currentWriter = writer;
            return writer;
        }
        /// <summary>
        /// g[Xo
        /// </summary>
        /// <param name="message"></param>
        /// <remarks>
        /// Ăяo̓^CX^vtȂ(tłȂ)B
        /// </remarks>
        public override void Write(string message)
        {
            using (StreamWriter writer = getWriter())
            {
                writer.Write(message);
                this.Close();
            }
        }
        /// <summary>
        /// g[Xo(s)
        /// </summary>
        /// <param name="message"></param>
        /// <remarks>s̐擪Ƀ^CX^vtAg[Xo͂Bo͌gpwriterB
        /// 
        /// </remarks>
        public override void WriteLine(string message)
        {
            using (StreamWriter writer = getWriter())
            {
                if (!string.IsNullOrEmpty(message))
                {
                    writer.WriteLine(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss.ffffff") + "\t" + message);
                }

                this.Close();
            }
        }
        /// <summary>
        /// g[Xo(sAJeS[B
        /// </summary>
        /// <param name="message"></param>
        /// <param name="category">JeS[w</param>
        /// <remarks>s̐擪Ƀ^CX^vtAg[Xo͂Bo͌gpwriterB
        /// 
        /// </remarks>
        public override void WriteLine(string message, string category)
        {
            using (StreamWriter writer = getWriter())
            {
                if (!string.IsNullOrEmpty(message))
                {
                    writer.WriteLine(DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss.ffffff") + "\t[" + category + "]\t" + message);
                }
                this.Close();
            }
        }

        private string getTraceFileName(int num)
        {
            if (this._baseDir == "") this._baseDir = this.Attributes["baseDir"];
            if (this._baseName == "") this._baseName = this.Attributes["baseName"];

            string suffix = "";
            if (num > 0) suffix = "-" + num.ToString("00");

            string fileName  = "";
            if (_baseName != "") fileName += _baseName + ".";
            fileName +=  DateTime.Now.ToString("yyyyMMdd") + suffix + ".log";
            string fullName = Path.Combine(_baseDir, fileName);

            if (!Directory.Exists(_baseDir)) Directory.CreateDirectory(_baseDir);

            return fullName;
        }
    }
}
