using System;
using System.Collections.Generic;
using System.Text;
using System.Resources;

namespace OFW.MessageResources
{
    /// <summary>
    /// bZ[W\[XIuWFNg𐶐
    /// </summary>
    public class MessageResourceFactory
    {
        /// <summary>
        /// ftHg̃\[XAZu
        /// </summary>
        const string DEFAULT_ASSEMBLY_NAME = "Message.Resources";
        /// <summary>
        /// bZ[W\[Xi[AZu
        /// </summary>
        static System.Reflection.Assembly messageResourceAssembly;
        /// <summary>
        /// ɍ\zbZ[W\[X̃LbV
        /// </summary>
        static Dictionary<string, MessageResource> messageResourceCache;
        /// <summary>
        /// ÓItB[h\z
        /// </summary>
        static MessageResourceFactory()
        {
            messageResourceCache = new Dictionary<string, MessageResource>();
        }
        /// <summary>
        /// wL[ɊY郁bZ[W\[X擾
        /// </summary>
        /// <param name="keys">L[w</param>
        /// <returns>wL[ɊY郁bZ[W\[X</returns>
        /// <remarks>bZ[W\[X̃\[XeLXg̃t@C"systemname.subsystem.category.txt"łꍇA
        /// "systemname","subsystem","category"Ɏw肷B<br />
        /// \[Xdll src/build/message.resource.projgpĐAexe|webQƂłpXɔzuB<br />
        /// ۂɎgp郊\[Xdll̖̂ config/appSettings/key=MessageResourceAssemblyName Ɏw肷Bł"Message.Resources.dll"ǂݍ
        /// </remarks>
        public static MessageResource GetInstance(params string[] keys)
        {
            //wL[\[XALbṼL[Ɉ`ɑgݗĂ
            string key = BuildDirectoryKey(keys);
            //LbVɑ݂΂̃IuWFNgԂB
            if (messageResourceCache.ContainsKey(key))
            {
                return messageResourceCache[key];
            }
            if (messageResourceAssembly == null) LoadMessageResourceAssembly();

            MessageResource mr = new MessageResource(GetResourceManager(key));
            messageResourceCache[key] = mr; //addgƕʃXbhANZX2dɂȂ邩BbN

            return mr;


        }
        static void LoadMessageResourceAssembly()
        {
            Config.ConfigFile config = Config.ConfigFactory.GetConfig();
            string resourceAssemblyName = config.GetAppSettingString("MessageResourceAssemblyName","");
            if (resourceAssemblyName == "") resourceAssemblyName = DEFAULT_ASSEMBLY_NAME;
            messageResourceAssembly = System.Reflection.Assembly.Load(resourceAssemblyName);

        }
        static ResourceManager GetResourceManager(string key)
        {
            return new ResourceManager(key, messageResourceAssembly);

        }

        /// <summary>
        /// wL[z񂩂fBNg[L[𐶐
        /// </summary>
        /// <param name="keys"></param>
        /// <returns></returns>
        static string BuildDirectoryKey(string[] keys)
        {
            string builtKey = "";

            StringBuilder keyBuilder = new StringBuilder();
            for (int i = 0; i < keys.Length; i++)
            {
                if (i > 0) keyBuilder.Append(".");
                keyBuilder.Append(keys[i].ToLower());
            }
            builtKey = keyBuilder.ToString();
            return builtKey;
        }

    }
}
