using System;
using System.Collections.Generic;
using System.Text;
using OFW.FieldProperties;

namespace OFW.Models
{
    /// <summary>
    /// EntityPropertẙ
    /// </summary>
    public class DefaultEntityProperty : EntityProperty
    {
        /// <summary>
        /// 
        /// </summary>
        public List<FieldProperty> fieldList;
        /// <summary>
        /// 
        /// </summary>
        public List<FieldProperty> primaryKeyList;


        /// <summary>
        /// 
        /// </summary>
        public DefaultEntityProperty()
        {
            fieldList = new List<FieldProperty>();
            primaryKeyList = new List<FieldProperty>();
        }
        /// <summary>
        /// Rs[RXgN^
        /// </summary>
        /// <param name="original"></param>
        public DefaultEntityProperty(DefaultEntityProperty original)
        {
            this.fieldList = new List<FieldProperty>();
            this.primaryKeyList = new List<FieldProperty>();

            this.Alias = original.Alias;
            this.CreatedAtField = original.CreatedAtField;
            this.EntityName = original.EntityName;
            this.entityType = original.entityType;

            foreach (FieldProperty p in original.fieldList)
            {
                FieldProperty newField = p.Clone() as FieldProperty;
                this.fieldList.Add(newField);
                if (p.IsPrimaryKey) this.primaryKeyList.Add(newField);
            }
            this.Schema = original.Schema;
        }


        #region IEntityProperty o

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        override public IEnumerable<FieldProperty> Fields()
        {
            return this.fieldList;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        override public IEnumerable<FieldProperty> PrimaryKeys()
        {
            return this.primaryKeyList;
        }

        #endregion
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override object Clone()
        {
            return new DefaultEntityProperty(this);
        }
        /// <summary>
        /// ̗񖼁AږŃANZXCfNT
        /// </summary>
        /// <param name="fieldName"></param>
        /// <returns></returns>
        public FieldProperty this[string fieldName]
        {
            get
            {
                return find(fieldName);
            }
        }
        FieldProperty find(string name)
        {
            FieldProperty p = fieldList.Find(delegate(FieldProperty pp) { return pp.FieldName == name; });
            return p;
        }
    }
}
