using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;

namespace OFW.Util
{
    /// <summary>
    /// [AhX񏈗
    /// </summary>
    public class MailAddressUtil
    {
        /// <summary>
        /// address-list Ƃē͂ꂽ̐K
        /// </summary>
        /// <param name="s"></param>
        /// <returns></returns>
        public static string NormalizeMailAddressList(string s)
        {
            string[] list = SplitMailAddressList(s);
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < list.Length; i++)
            {
                if (list[i] == "") continue;
                if (b.Length > 0) b.Append(",");
                b.Append(NormalizeMailAddress(list[i]));
            }
            return b.ToString();
        }
        /// <summary>
        /// address Ƃē͂ꂽ̐K
        /// 
        /// "displayname" &lt;addr&gt;̌`œ͂ꍇAsvȃXy[X̍폜ADQUOT̒ǉȂǂs
        /// </summary>
        /// <param name="s">address</param>
        /// <returns>KAhX</returns>
        public static string NormalizeMailAddress(string s)
        {
            string[] addr = SplitNameAddress(s);
            string normalized = FormatNameAddress(addr);
            return normalized;
        }
        /// <summary>
        /// address-spec Ƃē͂ꂽ̐K
        /// 
        /// display name܂܂Ȃꍇ̐KsB
        /// &lt;A&gt;͍폜BJ}̓sIhɕϊ
        /// </summary>
        /// <param name="s">address</param>
        /// <returns>KAhX</returns>
        public static string NormalizeMailAddressSpec(string s)
        {
            string normalized = StringUtil.DeleteAllWhiteSpace(StringUtil.DeleteNewLine(StringUtil.ToNarrow(s))).Replace("", ",").Replace(',', '.').Replace("<", "").Replace(">", "").ToLower();
            return normalized;
        }
        /// <summary>
        /// ꂽ name-addrătH[}bg
        /// </summary>
        /// <param name="nameAddress">ꂽ name-addr</param>
        /// <returns>displayNameDQUOTň͂݁AAhX̓uPbgň͂ށBdisplayNameȂ΃AhX̂</returns>
        public static string FormatNameAddress(string[] nameAddress)
        {
            string nameAddressFormatted = "";
            if (nameAddress[0] == "")
            {
                nameAddressFormatted = nameAddress[1];
            }
            else
            {
                nameAddressFormatted = "\"" + nameAddress[0] + "\" <" + nameAddress[1] + ">";
            }
            return nameAddressFormatted;
        }
        /// <summary>
        /// address-list Ƃē͂ꂽaddress̔zɕ
        /// 
        /// outlookȂǃZ~R؂ɎgpMUAAhXXgRs[ꍇɎgpB
        /// RFC2822xł̓AhXXǵuJ}؂vłăZ~R͋ȂB]đ̋؂蕶J}ɕϊB
        /// </summary>
        /// <param name="s">address-listBJ}؂܂̓Z~R؂ŕLq</param>
        /// <returns>X̃AhXLq̔z</returns>
        public static string[] SplitMailAddressList(string s)
        {

            string[] arr = SplitList(s);
            List<string> newList = new List<string>();
            for (int i = 0; i < arr.Length; i++)
            {
                string address = NormalizeMailAddress(arr[i]);
                if (address != "")
                {
                    newList.Add(address);
                }
            }


            return newList.ToArray();
        }
        /// <summary>
        /// address list̕
        /// </summary>
        /// <param name="s">address list҂Ă镶</param>
        /// <returns>X̃AhXvfɎz</returns>
        /// <remarks></remarks>
        public static string[] SplitList(string s)
        {
            StringBuilder b = new StringBuilder(s);
            b.Replace(";", ",");
            string[] arr = StringUtil.Split(b.ToString(), ",");
            return arr;
        }
        /// <summary>
        /// \ƃAhXɕ
        /// </summary>
        /// <param name="s">display name + AhXȂ镶</param>
        /// <returns>display nameƃAhXvfɂzB0Ԗڂdisplay name,1ԖڂAhXBĂvf͋󕶎</returns>
        public static string[] SplitNameAddress(string s)
        {

            StringReader reader = new StringReader(s);
            StringWriter writer = new StringWriter();
            bool inQuots = false;
            int len = 0;
            List<string> elements = new List<string>();
            while (reader.Peek() != -1)
            {
                int c = reader.Read();
                int next = reader.Peek();


                if (c == '"' || c == '\'' || c == '<' || c == '>')
                {
                    if (!inQuots)
                    {
                        if (len == 0)
                        {
                            inQuots = true;
                            continue;
                        }
                    }

                    if (inQuots)
                    {
                        if (next == -1 || next == ' ' || next == '@' || next == '<' || next == '>')
                        {
                            writer.Close();
                            string el = writer.ToString();
                            elements.Add(el);
                            writer = new StringWriter();
                            len = 0;
                            inQuots = false;
                            continue;
                        }

                    }

                    if (c == '"') { writer.Write('\\'); len++; }
                    writer.Write((char)c);
                    len++;
                    continue;
                }
                if (c == ' ' || c == '@' )
                {
                    if (!inQuots)
                    {
                        if (len == 0)
                        {
                            continue;
                        }
                        else
                        {
                            writer.Close();
                            string el = writer.ToString();
                            elements.Add(el);
                            writer = new StringWriter();
                            len = 0;
                            inQuots = false;
                            continue;
                        }
                    }
                }
                if (c == '\\')
                {
                    if (next == -1)
                    {
                        writer.Write('\\');
                        writer.Write('\\');
                        len++;
                        len++;
                        continue;
                    }
                    writer.Write('\\');
                    c = reader.Read();
                    writer.Write((char)c);
                    len++;
                    len++;
                    continue;
                }
                writer.Write((char)c);
                len++;
            }
            reader.Close();

            writer.Close();
            if (len > 0)
            {
                string el = writer.ToString();
                elements.Add(el);
                writer = new StringWriter();
            }

            string[] nameAndAddress = new string[] { "", "" };//ォ炱glȂ悤ɋ󕶎2
            if (elements.Count == 0)
            {
                //Ȃ
            }
            if (elements.Count == 1)
            {
                nameAndAddress[1] = NormalizeMailAddressSpec(elements[0]);
            }
            if (elements.Count > 1)
            {
                nameAndAddress[0] = StringUtil.Trim(elements[0]);
                nameAndAddress[1] = NormalizeMailAddressSpec(elements[1]);
                //3ڂ͖BӖȂB
            }

            return nameAndAddress;


        }

    }
    /// <summary>
    /// [AhX̌
    /// </summary>
    public class MailAddressValidator 
    {
        /// <summary>
        /// G[bZ[W̐擪ɕt镶BXĝƂuǂ̍ڂ̉Ԗځv𖾎邽߂Ɏgp
        /// </summary>
        public string ErrorMessagePrefix;
        /// <summary>
        /// ،ʂ̃bZ[WBG[̂
        /// </summary>
        public List<string> ErrorMessage;
        /// <summary>
        /// ftHg\z
        /// </summary>
        public MailAddressValidator()
        {
            ErrorMessage = new List<string>();
            ErrorMessagePrefix = "";
        }
        /// <summary>
        /// address-list Ƃē͂ꂽ̌
        /// 
        /// ؂蕶(J}AZ~R)܂߂ɃAhX𕡐LqꍇfalseƂȂB
        /// Windows UI璼ڌĂяoƂ͖͂
        /// javascriptȂǂŐݒ肳ꂽaddress-listLq͗vf͂̃\bhŌ؂
        /// </summary>
        /// <param name="s">normalizeꂽaddress list</param>
        /// <returns>address-list̋LqƂĐꍇtrueAłȂfalseB</returns>
        public bool ValidateMailAddressList(string s)
        {
            string[] list = MailAddressUtil.SplitList(s);
            return ValidateMailAddressListArray(list);
        }
        /// <summary>
        /// address-list Ƃē͂ꂽ̌؂̕o[W
        /// 
        /// address-listaddresszɂă`FbNB
        /// ܂͕͂ꂽaddressLq`FbN
        /// </summary>
        /// <param name="list">normalizeꂽaddress̔z</param>
        /// <returns>SĂ̗vfꍇɂ̂true,ꂩ̗vfɐȂ݂̂鎞false</returns>
        public bool ValidateMailAddressListArray(string[] list)
        {
            bool valid = true;
            for (int i = 0; i < list.Length; i++)
            {
                if (!ValidateMailAddress(list[i]))
                {
                    valid = false;
                    string msg = ErrorMessage[ErrorMessage.Count - 1];
                    msg = string.Format("({0}{1}[{2}]) " + msg, ErrorMessagePrefix, i + 1, list[i]);
                    ErrorMessage[ErrorMessage.Count - 1] = msg;

                }
            }
            return valid;
        }

        /// <summary>
        /// address Ƃē͂ꂽ̌
        /// </summary>
        /// <param name="s">normalizeꂽaddress</param>
        /// <returns>addressLqƂĐꍇtrue,łȂfalse</returns>
        public bool ValidateMailAddress(string s)
        {
            string[] nameAddress = MailAddressUtil.SplitNameAddress(s);
            return ValidateMailAddressSpec(nameAddress[1]);
        }
        /// <summary>
        /// address-spec Ƃē͂ꂽ̌
        /// 
        /// h@hAAsIhAAȂaddress-specƂĐȂ̂rB
        /// ꕔvoC_[AoCLAŋĂp^[łĂRFC2822ŋĂȂ͕̂sƂ݂ȂB
        /// voC_[̃[U[ɑ΂Ă͑RׂAiEXsA[AhX̕ύX𑣂B
        /// </summary>
        /// <param name="s">normalizeꂽaddress spec</param>
        /// <returns>address-specƂĐꍇtrueAłȂfalse</returns>
        public bool ValidateMailAddressSpec(string s)
        {
            bool valid = true;
            if (s == "") return true; //ĂӖȂBK{ȂRequiredValidatorƂg
            //@1邱
            int posAtmark = s.IndexOf("@");
            if (posAtmark < 0)
            {
                valid = false;
                ErrorMessage.Add("[AhXɂ\"@\"(Abg}[N)KvłB");
                return valid;
            }
            posAtmark = s.IndexOf("@",posAtmark + 1);
            if (posAtmark >= 0)
            {
                valid = false;
                ErrorMessage.Add("[AhXɂ\"@\"(Abg}[N)KvłB");
                return valid;
            }

            string[] parts = StringUtil.Split(s, "@");
            string localPart = parts[0];
            string domainPart = parts[1];

            if (localPart.Length == 0)
            {
                ErrorMessage.Add("[AhX\"foo@bar.com\"̌`œ͂ĂB");
            }
            if (domainPart.Length == 0)
            {
                ErrorMessage.Add("[AhX\"foo@bar.com\"̌`œ͂ĂB");
            }

            //local part
            // "."̘A͕s
            if (localPart.IndexOf("..") >= 0)
            {
                valid = false;
                ErrorMessage.Add("[AhXɂ\"..\"(hbg̘A)͋Lqł܂B");
                return valid;
            }
            // @O"."͕s
            if (localPart.Substring(localPart.Length - 1, 1) == ".")
            {
                valid = false;
                ErrorMessage.Add("\"@\"(Abg}[N)̒O\".\"(hbg)͋Lqł܂B");
                return valid;
            }
            //localpart ̕p^[`FbN
            Regex reLocalPart = new Regex(RegExpFormat.MailBoxName);
            if (!reLocalPart.IsMatch(localPart))
            {
                valid = false;
                ErrorMessage.Add("[AhXɎgpłȂAp^[܂܂Ă܂B");
                return valid;
            }

            //domain part
            //1ڂ"-"ł̓_
            if (domainPart.StartsWith("-"))
            {
                valid = false;
                ErrorMessage.Add("hC\"-\"A\"_\"A\"-\"ł͊Jnł܂");
                return valid;
            }
            //1ڂ"_"ł̓_
            if (domainPart.StartsWith("_"))
            {
                valid = false;
                ErrorMessage.Add("hC\"-\"A\"_\"A\"-\"ł͊Jnł܂");
                return valid;
            }
            //1ڂ"."ł̓_ (DNSdlɂ΍Ō̃hbg͋ł͂H)
            //1ڂ"_"ł̓_
            if (domainPart.StartsWith("."))
            {
                valid = false;
                ErrorMessage.Add("hC\"-\"A\"_\"A\"-\"ł͊Jnł܂");
                return valid;
            }
            //p^[`FbN

            Regex reDomainPart = new Regex(RegExpFormat.Domain);
            if (!reLocalPart.IsMatch(domainPart))
            {
                valid = false;
                ErrorMessage.Add("[AhXɎgpłȂAp^[܂܂Ă܂B");
                return valid;
            }
            return true;

        }
        /// <summary>
        /// ؂Zbg(ԂΏԂ̏AbZ[W̃NA)
        /// </summary>
        public void Reset()
        {
            ErrorMessage.Clear();
        }
    }
}
