using System;
using System.Collections.Generic;
using System.Text;

namespace OFW.Util
{
    /// <summary>
    /// ^`FbN
    /// </summary>
	public class TypeChecker
    {
        private static Encoding sjisEnc = Encoding.GetEncoding("Shift_JIS");

        /// <summary>
        /// RXgN^
        /// </summary>
        private TypeChecker()
        {
        }

        /// <summary>
        /// int^Cṽ`FbN
		/// lw͈͓ɂ邩`FbN
        /// </summary>
        /// <param name="aValue">`FbNΏ</param>
        /// <param name="aMin"></param>
        /// <param name="aMax"></param>
        /// <returns>validȂtrue</returns>
        public static bool CheckNumeric(int aValue, int aMin, int aMax)
        {
            bool booRet = true;

            try
            {
                if ((aValue < aMin) || (aValue > aMax))
                {
                    booRet = false;
                }
            }
            catch
            {
                booRet = false;
            }
            finally
            {
            }

            return (booRet);
        }

        /// <summary>
        /// double^Cṽ`FbN
		/// slw͈͓ɂ邩`FbN
        /// </summary>
        /// <param name="aValue">`FbNΏ</param>
        /// <param name="aMin"></param>
        /// <param name="aMax"></param>
        /// <returns>validȂtrue</returns>
        public static bool CheckNumeric(double aValue, double aMin, double aMax)
        {
            bool booRet = true;

            try
            {
                if ((aValue < aMin) || (aValue > aMax))
                {
                    booRet = false;
                }
            }
            catch
            {
                booRet = false;
            }
            finally
            {
            }

            return (booRet);
        }

        /// <summary>
        /// decimal̃`FbN
		/// 10ilw͈͓ɂ邩`FbN
        /// </summary>
        /// <param name="aValue">`FbNΏ</param>
        /// <param name="aMin"></param>
        /// <param name="aMax"></param>
        /// <returns>validȂtrue</returns>
        public static bool CheckNumeric(decimal aValue, decimal aMin, decimal aMax)
        {
            bool booRet = true;

            try
            {
                if ((aValue < aMin) || (aValue > aMax))
                {
                    booRet = false;
                }
            }
            catch
            {
                booRet = false;
            }
            finally
            {
            }

            return (booRet);
        }

        /// <summary>
        /// double^Cṽ`FbN
		/// w͈͓ɂ邩Aw萸x𒴂ĂȂ`FbN
        /// </summary>
        /// <param name="aValue">`FbNΏ</param>
        /// <param name="aMin"></param>
        /// <param name="aMax"></param>
        /// <param name="scale">L(total)</param>
        /// <param name="precision">L(_ȉ)</param>
        /// <returns>validȂtrue</returns>
        public static bool CheckNumeric(double aValue, int aMin, int aMax, int scale, int precision)
        {
            bool booRet = true;
            string strInt = "";
            string strDec = "";

            try
            {
                if ((aValue < aMin) || (aValue > aMax))
                {
                    booRet = false;
                }
                else
                {
                    if (aValue.ToString().IndexOf(".") >= 0)
                    {
                        strInt = aValue.ToString().Substring(0, aValue.ToString().IndexOf("."));
                        strDec = aValue.ToString().Substring(aValue.ToString().IndexOf(".") + 1);
                    }
                    else
                    {
                        strInt = aValue.ToString();
                        strDec = "";
                    }

                    if ((strInt.Length + strDec.Length) > scale)
                    {
                        booRet = false;
                    }
                    else if (strDec.Length > precision)
                    {
                        booRet = false;
                    }
                }
            }
            catch
            {
                booRet = false;
            }
            finally
            {
            }

            return (booRet);
        }

        /// <summary>
        /// decimal̃`FbN
		/// 10iw͈͓ɂ邩Aw萸x𒴂ĂȂ`FbN
        /// </summary>
        /// <param name="aValue">`FbNΏ</param>
        /// <param name="aMin"></param>
        /// <param name="aMax"></param>
        /// <param name="scale">L((_ȉ))</param>
        /// <param name="precision">L total</param>
        /// <returns>validȂtrue</returns>
        public static bool CheckNumeric(decimal aValue, decimal aMin, decimal aMax, int precision, int scale)
        {
            bool booRet = true;
            string strInt = "";
            string strDec = "";

            try
            {
                if ((aValue < aMin) || (aValue > aMax))
                {
                    booRet = false;
                }
                else
                {
                    if (aValue.ToString().IndexOf(".") >= 0)
                    {
                        strInt = aValue.ToString().Substring(0, aValue.ToString().IndexOf("."));
                        strDec = aValue.ToString().Substring(aValue.ToString().IndexOf(".") + 1);
                    }
                    else
                    {
                        strInt = aValue.ToString();
                        strDec = "";
                    }

                    if ((strInt.Length + strDec.Length) > (precision - scale))
                    {
                        booRet = false;
                    }
                    else if (strDec.Length > scale)
                    {
                        booRet = false;
                    }
                }
            }
            catch
            {
                booRet = false;
            }
            finally
            {
            }

            return (booRet);
        }

        /// <summary>
        /// ͕񂪓t\̕񂩂ǂ̃`FbN
		/// t҂镶񂪎wtH[}bgɂĂ邩`FbN
        /// </summary>
        /// <param name="aDateString">t҂Ă镶</param>
        /// <param name="aFormat">wtH[}bg</param>
        /// <returns>OKȂtrue</returns>
        public static bool CheckDateString(string aDateString, string aFormat)
        {
            bool booRet = true;
            DateTime dtWork;
            string strWork = "";

            try
            {
                dtWork = DateTime.Parse(aDateString);
                strWork = dtWork.ToString(aFormat);

                if (strWork != aDateString)
                {
                    booRet = false;
                }
            }
            catch
            {
                booRet = false;
            }
            finally
            {
            }

            return (booRet);
        }
        
        /// <summary>
        /// ͕񂪎wtH[}bgɂĂ邩ǂ̃`FbN
        /// </summary>
        /// <param name="aValue">Ώە</param>
        /// <param name="format">tH[}bg(K\)</param>
        /// <returns>OKȂtrue</returns>
        public static bool CheckFormatString(string aValue, string format)
        {
            bool booRet = true;

            try
            {
                if(System.Text.RegularExpressions.Regex.IsMatch(aValue, format) == false)
                {
                    booRet = false;
                }
            }
            catch
            {
                booRet = false;
            }
            finally
            {
            }
            
            return (booRet);
        }

        /// <summary>
        /// 񒷂`FbN(bytew)
        /// </summary>
        /// <param name="aValue">`FbNΏە</param>
        /// <param name="aBytes">oCg</param>
        /// <returns>wȓȂtrue</returns>
        public static bool CheckStringLengthByte(string aValue, int aBytes)
        {
            bool booRet = true;

            try
            {
                if (sjisEnc.GetByteCount(aValue) > aBytes)
                {
                    booRet = false;
                }
            }
            catch
            {
                booRet = false;
            }
            finally
            {
            }

            return (booRet);
        }

        /// <summary>
        /// 񒷂`FbN(Ch)
        /// </summary>
        /// <param name="aValue">`FbNΏە</param>
        /// <param name="aLength"></param>
        /// <returns>wȓȂtrue</returns>
        public static bool CheckStringLengthWide(string aValue, int aLength)
        {
            bool booRet = true;

            try
            {
                if (aValue.Length > aLength)
                {
                    booRet = false;
                }
            }
            catch
            {
                booRet = false;
            }
            finally
            {
            }

            return (booRet);
        }
    }
}
