using System;
using System.Collections.Generic;
using System.Text;
using OFW.FieldProperties;
using OFW.Util;

namespace OFW.Validators
{
    /// <summary>
    /// 10itB[hpValidator
    /// </summary>
    /// <remarks>w萸xɑ΂`FbNsB</remarks>
    public class DecimalFieldValidator : FieldValidator
    {
        /// <summary>
        /// ftHg
        /// </summary>
        public DecimalFieldValidator() : base()
        {
            this.mProperty = new DecimalFieldProperty();
        }
        /// <summary>
        /// vpeBw
        /// </summary>
        /// <param name="p"></param>
        public DecimalFieldValidator(FieldProperty p) : base(p)
        {

        }
        /// <summary>
        /// ^Cv`FbÑI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateType(object aValue)
        {
            this.ErrorMessage = "";
            try
            {
                if (aValue is decimal)
                {
                    return true;
                }
                else
                {
                    this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                    return false;
                }
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }

        }
        /// <summary>
        /// ͈̓`FbÑI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateRange(object aValue)
        {
            this.ErrorMessage = "";
            try
            {
                DecimalFieldProperty prop = (DecimalFieldProperty)this.mProperty;

                decimal checkVale = Decimal.Parse(aValue.ToString());
                if (!TypeChecker.CheckNumeric(checkVale, prop.MinValue, prop.MaxValue))
                {
                    this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_RANGE"), prop.DisplayName, prop.MinValue.ToString(), prop.MaxValue.ToString());
                    return false;
                }
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }
            return true;
        }
        /// <summary>
        /// tH[}bg`FbÑI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateFormat(object aValue)
        {
            this.ErrorMessage = "";
            if (aValue == null) return true;

            decimal inputValue = NumberUtil.DecimalValue(aValue);

            //wprecision,scaleɊÂtH[}bg
            DecimalFieldProperty p = (DecimalFieldProperty)this.mProperty;
            string m = (new String('0', (p.Precision - p.Scale)));
            if (p.Scale > 0)
            {
                m += "." + (new String('0', p.Scale));
            }
            decimal normalizeValue = NumberUtil.DecimalValue(inputValue.ToString(m));

            if (inputValue != normalizeValue)
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }
            else
            {
                return true;
            }


            //return base.ValidateFormat(aValue, aFieldPorpery, out this.ErrorMessage);
        }
    }
}
