using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Sample.Data.Models.Base
{
    /// <summary>
    /// table MAST_SITEɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class MastSiteTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[SITE_CODE]</summary>
        public FieldProperty siteCode;
        ///<summary>[OPEN_DATE]</summary>
        public FieldProperty openDate;
        ///<summary>[CLOSE_DATE]</summary>
        public FieldProperty closeDate;
        ///<summary>[SORT_SEQ]</summary>
        public FieldProperty sortSeq;
        ///<summary>[NAME]</summary>
        public FieldProperty name;
        ///<summary>[ANK_NAME]</summary>
        public FieldProperty ankName;
        ///<summary>[COMPANY_CODE]</summary>
        public FieldProperty companyCode;
        ///<summary>[SITE_URL]</summary>
        public FieldProperty siteUrl;
        ///<summary>[SITE_URL_OTHER]</summary>
        public FieldProperty siteUrlOther;
        ///<summary>[SITE_CATEGORY1]</summary>
        public FieldProperty siteCategory1;
        ///<summary>[SITE_CATEGORY2]</summary>
        public FieldProperty siteCategory2;
        ///<summary>[DEVICE_CODE]</summary>
        public FieldProperty deviceCode;
        ///<summary>[MENU_DEVICE_CODE]</summary>
        public FieldProperty menuDeviceCode;
        ///<summary>[MENU_ADTYPE_CODE]</summary>
        public FieldProperty menuAdtypeCode;
        ///<summary>[GOODS_CATEGORY_CODE]</summary>
        public FieldProperty goodsCategoryCode;
        ///<summary>[CARRIER_CODE1]</summary>
        public FieldProperty carrierCode1;
        ///<summary>[CARRIER_CODE2]</summary>
        public FieldProperty carrierCode2;
        ///<summary>[CARRIER_CODE3]</summary>
        public FieldProperty carrierCode3;
        ///<summary>[CARRIER_CODE4]</summary>
        public FieldProperty carrierCode4;
        ///<summary>[MEDIA_COST_RATE]</summary>
        public FieldProperty mediaCostRate;
        ///<summary>[AGENCY_MARGIN_RATE]</summary>
        public FieldProperty agencyMarginRate;
        ///<summary>[SP_OPEN_FLAG]</summary>
        public FieldProperty spOpenFlag;
        ///<summary>[PM_OPEN_FLAG]</summary>
        public FieldProperty pmOpenFlag;
        ///<summary>[IO_OPEN_FLAG]</summary>
        public FieldProperty ioOpenFlag;
        ///<summary>[AD_GUIDE_OPEN_FLAG]</summary>
        public FieldProperty adGuideOpenFlag;
        ///<summary>[IMPRESSION]</summary>
        public FieldProperty impression;
        ///<summary>[IMPRESSION_TERM]</summary>
        public FieldProperty impressionTerm;
        ///<summary>[IMPRESSION_TOPPAGE]</summary>
        public FieldProperty impressionToppage;
        ///<summary>[IMPRESSION_TOPPAGE_TERM]</summary>
        public FieldProperty impressionToppageTerm;
        ///<summary>[UNIQUE_USER]</summary>
        public FieldProperty uniqueUser;
        ///<summary>[UNIQUE_USER_TERM]</summary>
        public FieldProperty uniqueUserTerm;
        ///<summary>[UNIQUE_USER_TOPPAGE]</summary>
        public FieldProperty uniqueUserToppage;
        ///<summary>[UNIQUE_USER_TOPPAGE_TERM]</summary>
        public FieldProperty uniqueUserToppageTerm;
        ///<summary>[MALE_RATE]</summary>
        public FieldProperty maleRate;
        ///<summary>[FEMALE_RATE]</summary>
        public FieldProperty femaleRate;
        ///<summary>[PUBLISHED_YEAR]</summary>
        public FieldProperty publishedYear;
        ///<summary>[PUBLISHED_MONTH]</summary>
        public FieldProperty publishedMonth;
        ///<summary>[PUBLISHED_DAY]</summary>
        public FieldProperty publishedDay;
        ///<summary>[PUBLISHED_DATA_KIND]</summary>
        public FieldProperty publishedDataKind;
        ///<summary>[UPPER_SITE_CODE]</summary>
        public FieldProperty upperSiteCode;
        ///<summary>[PAYMENT_COMPANY]</summary>
        public FieldProperty paymentCompany;
        ///<summary>[BUSINESS_DIRECT_FLAG]</summary>
        public FieldProperty businessDirectFlag;
        ///<summary>[ADSERVER_FLAG]</summary>
        public FieldProperty adserverFlag;
        ///<summary>[SPECIALMENU_FLAG]</summary>
        public FieldProperty specialmenuFlag;
        ///<summary>[TOP_OPEN_FLAG]</summary>
        public FieldProperty topOpenFlag;
        ///<summary>[OPEN_MENU_COUNT]</summary>
        public FieldProperty openMenuCount;
        ///<summary>[MAKE_DATE]</summary>
        public FieldProperty makeDate;
        ///<summary>[DOCUMENT_ADDRESS]</summary>
        public FieldProperty documentAddress;
        ///<summary>[AG_COMPANY_CODE]</summary>
        public FieldProperty agCompanyCode;
        ///<summary>[INSIDE_OPEN_LEVEL]</summary>
        public FieldProperty insideOpenLevel;
        ///<summary>[OUTSIDE_OPEN_LEVEL]</summary>
        public FieldProperty outsideOpenLevel;
        ///<summary>[HOME_RATE]</summary>
        public FieldProperty homeRate;
        ///<summary>[WORK_RATE]</summary>
        public FieldProperty workRate;
        ///<summary>[OVERLAP_RATE]</summary>
        public FieldProperty overlapRate;
        ///<summary>[BUSINESS_REP_DIRECT_FLAG]</summary>
        public FieldProperty businessRepDirectFlag;
        ///<summary>[CLIENT_SITE_FLAG]</summary>
        public FieldProperty clientSiteFlag;
        ///<summary>[PRINT_UPPER_SITE_CODE]</summary>
        public FieldProperty printUpperSiteCode;
        ///<summary>[TEAM_CODE]</summary>
        public FieldProperty teamCode;
        ///<summary>[CHECK_NAME]</summary>
        public FieldProperty checkName;
        ///<summary>[PRICE_COST_FROM_DATE]</summary>
        public FieldProperty priceCostFromDate;
        ///<summary>[VALID_FLAG]</summary>
        public FieldProperty validFlag;
        ///<summary>[INSERT_DATE_TIME]</summary>
        public FieldProperty insertDateTime;
        ///<summary>[INSERT_OPERATOR_CODE]</summary>
        public FieldProperty insertOperatorCode;
        ///<summary>[UPDATE_DATE_TIME]</summary>
        public FieldProperty updateDateTime;
        ///<summary>[OPERATOR_CODE]</summary>
        public FieldProperty operatorCode;
        

        /// <summary>
        /// default construct
        /// </summary>
        public MastSiteTableProperty()
        {
            this.EntityName = "MAST_SITE";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            siteCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "SITE_CODE","[SITE_CODE]", 5, 5, 0, false, "",true);
            openDate = FieldProperty.NewInstance("varchar", "MAST_SITE", "OPEN_DATE","[OPEN_DATE]", 8, 8, 0, false, "",false);
            closeDate = FieldProperty.NewInstance("varchar", "MAST_SITE", "CLOSE_DATE","[CLOSE_DATE]", 8, 8, 0, true, "",false);
            sortSeq = FieldProperty.NewInstance("smallint", "MAST_SITE", "SORT_SEQ","[SORT_SEQ]", 2, 5, 0, true, null,false);
            name = FieldProperty.NewInstance("varchar", "MAST_SITE", "NAME","[NAME]", 100, 100, 0, false, "",false);
            ankName = FieldProperty.NewInstance("varchar", "MAST_SITE", "ANK_NAME","[ANK_NAME]", 100, 100, 0, false, "",false);
            companyCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "COMPANY_CODE","[COMPANY_CODE]", 4, 4, 0, true, "",false);
            siteUrl = FieldProperty.NewInstance("varchar", "MAST_SITE", "SITE_URL","[SITE_URL]", 100, 100, 0, true, "",false);
            siteUrlOther = FieldProperty.NewInstance("varchar", "MAST_SITE", "SITE_URL_OTHER","[SITE_URL_OTHER]", 100, 100, 0, true, "",false);
            siteCategory1 = FieldProperty.NewInstance("smallint", "MAST_SITE", "SITE_CATEGORY1","[SITE_CATEGORY1]", 2, 5, 0, true, null,false);
            siteCategory2 = FieldProperty.NewInstance("smallint", "MAST_SITE", "SITE_CATEGORY2","[SITE_CATEGORY2]", 2, 5, 0, true, null,false);
            deviceCode = FieldProperty.NewInstance("smallint", "MAST_SITE", "DEVICE_CODE","[DEVICE_CODE]", 2, 5, 0, false, 0,false);
            menuDeviceCode = FieldProperty.NewInstance("smallint", "MAST_SITE", "MENU_DEVICE_CODE","[MENU_DEVICE_CODE]", 2, 5, 0, true, null,false);
            menuAdtypeCode = FieldProperty.NewInstance("smallint", "MAST_SITE", "MENU_ADTYPE_CODE","[MENU_ADTYPE_CODE]", 2, 5, 0, true, null,false);
            goodsCategoryCode = FieldProperty.NewInstance("smallint", "MAST_SITE", "GOODS_CATEGORY_CODE","[GOODS_CATEGORY_CODE]", 2, 5, 0, true, null,false);
            carrierCode1 = FieldProperty.NewInstance("smallint", "MAST_SITE", "CARRIER_CODE1","[CARRIER_CODE1]", 2, 5, 0, true, null,false);
            carrierCode2 = FieldProperty.NewInstance("smallint", "MAST_SITE", "CARRIER_CODE2","[CARRIER_CODE2]", 2, 5, 0, true, null,false);
            carrierCode3 = FieldProperty.NewInstance("smallint", "MAST_SITE", "CARRIER_CODE3","[CARRIER_CODE3]", 2, 5, 0, true, null,false);
            carrierCode4 = FieldProperty.NewInstance("smallint", "MAST_SITE", "CARRIER_CODE4","[CARRIER_CODE4]", 2, 5, 0, true, null,false);
            mediaCostRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "MEDIA_COST_RATE","[MEDIA_COST_RATE]", 7, 5, 2, true, null,false);
            agencyMarginRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "AGENCY_MARGIN_RATE","[AGENCY_MARGIN_RATE]", 7, 5, 2, true, null,false);
            spOpenFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "SP_OPEN_FLAG","[SP_OPEN_FLAG]", 2, 5, 0, true, null,false);
            pmOpenFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "PM_OPEN_FLAG","[PM_OPEN_FLAG]", 2, 5, 0, true, null,false);
            ioOpenFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "IO_OPEN_FLAG","[IO_OPEN_FLAG]", 2, 5, 0, true, null,false);
            adGuideOpenFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "AD_GUIDE_OPEN_FLAG","[AD_GUIDE_OPEN_FLAG]", 2, 5, 0, true, null,false);
            impression = FieldProperty.NewInstance("decimal", "MAST_SITE", "IMPRESSION","[IMPRESSION]", 14, 12, 0, true, null,false);
            impressionTerm = FieldProperty.NewInstance("smallint", "MAST_SITE", "IMPRESSION_TERM","[IMPRESSION_TERM]", 2, 5, 0, true, null,false);
            impressionToppage = FieldProperty.NewInstance("decimal", "MAST_SITE", "IMPRESSION_TOPPAGE","[IMPRESSION_TOPPAGE]", 14, 12, 0, true, null,false);
            impressionToppageTerm = FieldProperty.NewInstance("smallint", "MAST_SITE", "IMPRESSION_TOPPAGE_TERM","[IMPRESSION_TOPPAGE_TERM]", 2, 5, 0, true, null,false);
            uniqueUser = FieldProperty.NewInstance("decimal", "MAST_SITE", "UNIQUE_USER","[UNIQUE_USER]", 14, 12, 0, true, null,false);
            uniqueUserTerm = FieldProperty.NewInstance("smallint", "MAST_SITE", "UNIQUE_USER_TERM","[UNIQUE_USER_TERM]", 2, 5, 0, true, null,false);
            uniqueUserToppage = FieldProperty.NewInstance("decimal", "MAST_SITE", "UNIQUE_USER_TOPPAGE","[UNIQUE_USER_TOPPAGE]", 20, 18, 0, true, null,false);
            uniqueUserToppageTerm = FieldProperty.NewInstance("smallint", "MAST_SITE", "UNIQUE_USER_TOPPAGE_TERM","[UNIQUE_USER_TOPPAGE_TERM]", 2, 5, 0, true, null,false);
            maleRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "MALE_RATE","[MALE_RATE]", 7, 5, 2, true, null,false);
            femaleRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "FEMALE_RATE","[FEMALE_RATE]", 7, 5, 2, true, null,false);
            publishedYear = FieldProperty.NewInstance("smallint", "MAST_SITE", "PUBLISHED_YEAR","[PUBLISHED_YEAR]", 2, 5, 0, true, null,false);
            publishedMonth = FieldProperty.NewInstance("smallint", "MAST_SITE", "PUBLISHED_MONTH","[PUBLISHED_MONTH]", 2, 5, 0, true, null,false);
            publishedDay = FieldProperty.NewInstance("smallint", "MAST_SITE", "PUBLISHED_DAY","[PUBLISHED_DAY]", 2, 5, 0, true, null,false);
            publishedDataKind = FieldProperty.NewInstance("smallint", "MAST_SITE", "PUBLISHED_DATA_KIND","[PUBLISHED_DATA_KIND]", 2, 5, 0, true, null,false);
            upperSiteCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "UPPER_SITE_CODE","[UPPER_SITE_CODE]", 5, 5, 0, true, "",false);
            paymentCompany = FieldProperty.NewInstance("varchar", "MAST_SITE", "PAYMENT_COMPANY","[PAYMENT_COMPANY]", 4, 4, 0, true, "",false);
            businessDirectFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "BUSINESS_DIRECT_FLAG","[BUSINESS_DIRECT_FLAG]", 2, 5, 0, true, null,false);
            adserverFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "ADSERVER_FLAG","[ADSERVER_FLAG]", 2, 5, 0, true, null,false);
            specialmenuFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "SPECIALMENU_FLAG","[SPECIALMENU_FLAG]", 2, 5, 0, true, null,false);
            topOpenFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "TOP_OPEN_FLAG","[TOP_OPEN_FLAG]", 2, 5, 0, true, null,false);
            openMenuCount = FieldProperty.NewInstance("smallint", "MAST_SITE", "OPEN_MENU_COUNT","[OPEN_MENU_COUNT]", 2, 5, 0, true, null,false);
            makeDate = FieldProperty.NewInstance("varchar", "MAST_SITE", "MAKE_DATE","[MAKE_DATE]", 8, 8, 0, true, "",false);
            documentAddress = FieldProperty.NewInstance("varchar", "MAST_SITE", "DOCUMENT_ADDRESS","[DOCUMENT_ADDRESS]", 100, 100, 0, true, "",false);
            agCompanyCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "AG_COMPANY_CODE","[AG_COMPANY_CODE]", 4, 4, 0, true, "",false);
            insideOpenLevel = FieldProperty.NewInstance("smallint", "MAST_SITE", "INSIDE_OPEN_LEVEL","[INSIDE_OPEN_LEVEL]", 2, 5, 0, true, null,false);
            outsideOpenLevel = FieldProperty.NewInstance("smallint", "MAST_SITE", "OUTSIDE_OPEN_LEVEL","[OUTSIDE_OPEN_LEVEL]", 2, 5, 0, true, null,false);
            homeRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "HOME_RATE","[HOME_RATE]", 7, 5, 2, true, null,false);
            workRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "WORK_RATE","[WORK_RATE]", 7, 5, 2, true, null,false);
            overlapRate = FieldProperty.NewInstance("decimal", "MAST_SITE", "OVERLAP_RATE","[OVERLAP_RATE]", 7, 5, 2, true, null,false);
            businessRepDirectFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "BUSINESS_REP_DIRECT_FLAG","[BUSINESS_REP_DIRECT_FLAG]", 2, 5, 0, true, null,false);
            clientSiteFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "CLIENT_SITE_FLAG","[CLIENT_SITE_FLAG]", 2, 5, 0, true, null,false);
            printUpperSiteCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "PRINT_UPPER_SITE_CODE","[PRINT_UPPER_SITE_CODE]", 5, 5, 0, true, "",false);
            teamCode = FieldProperty.NewInstance("smallint", "MAST_SITE", "TEAM_CODE","[TEAM_CODE]", 2, 5, 0, true, null,false);
            checkName = FieldProperty.NewInstance("varchar", "MAST_SITE", "CHECK_NAME","[CHECK_NAME]", 100, 100, 0, true, "",false);
            priceCostFromDate = FieldProperty.NewInstance("varchar", "MAST_SITE", "PRICE_COST_FROM_DATE","[PRICE_COST_FROM_DATE]", 8, 8, 0, true, "",false);
            validFlag = FieldProperty.NewInstance("smallint", "MAST_SITE", "VALID_FLAG","[VALID_FLAG]", 2, 5, 0, true, null,false);
            insertDateTime = FieldProperty.NewInstance("smalldatetime", "MAST_SITE", "INSERT_DATE_TIME","[INSERT_DATE_TIME]", 16, 16, 0, true, null,false);
            insertOperatorCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "INSERT_OPERATOR_CODE","[INSERT_OPERATOR_CODE]", 6, 6, 0, true, "",false);
            updateDateTime = FieldProperty.NewInstance("smalldatetime", "MAST_SITE", "UPDATE_DATE_TIME","[UPDATE_DATE_TIME]", 16, 16, 0, true, null,false);
            operatorCode = FieldProperty.NewInstance("varchar", "MAST_SITE", "OPERATOR_CODE","[OPERATOR_CODE]", 6, 6, 0, true, "",false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.siteCode;
            yield return this.openDate;
            yield return this.closeDate;
            yield return this.sortSeq;
            yield return this.name;
            yield return this.ankName;
            yield return this.companyCode;
            yield return this.siteUrl;
            yield return this.siteUrlOther;
            yield return this.siteCategory1;
            yield return this.siteCategory2;
            yield return this.deviceCode;
            yield return this.menuDeviceCode;
            yield return this.menuAdtypeCode;
            yield return this.goodsCategoryCode;
            yield return this.carrierCode1;
            yield return this.carrierCode2;
            yield return this.carrierCode3;
            yield return this.carrierCode4;
            yield return this.mediaCostRate;
            yield return this.agencyMarginRate;
            yield return this.spOpenFlag;
            yield return this.pmOpenFlag;
            yield return this.ioOpenFlag;
            yield return this.adGuideOpenFlag;
            yield return this.impression;
            yield return this.impressionTerm;
            yield return this.impressionToppage;
            yield return this.impressionToppageTerm;
            yield return this.uniqueUser;
            yield return this.uniqueUserTerm;
            yield return this.uniqueUserToppage;
            yield return this.uniqueUserToppageTerm;
            yield return this.maleRate;
            yield return this.femaleRate;
            yield return this.publishedYear;
            yield return this.publishedMonth;
            yield return this.publishedDay;
            yield return this.publishedDataKind;
            yield return this.upperSiteCode;
            yield return this.paymentCompany;
            yield return this.businessDirectFlag;
            yield return this.adserverFlag;
            yield return this.specialmenuFlag;
            yield return this.topOpenFlag;
            yield return this.openMenuCount;
            yield return this.makeDate;
            yield return this.documentAddress;
            yield return this.agCompanyCode;
            yield return this.insideOpenLevel;
            yield return this.outsideOpenLevel;
            yield return this.homeRate;
            yield return this.workRate;
            yield return this.overlapRate;
            yield return this.businessRepDirectFlag;
            yield return this.clientSiteFlag;
            yield return this.printUpperSiteCode;
            yield return this.teamCode;
            yield return this.checkName;
            yield return this.priceCostFromDate;
            yield return this.validFlag;
            yield return this.insertDateTime;
            yield return this.insertOperatorCode;
            yield return this.updateDateTime;
            yield return this.operatorCode;
            
        }
                /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> PrimaryKeys()
        {
            yield return  this.siteCode;
            
        }
                
    }
}