using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Models;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.Expressions;
using System.Reflection;

namespace Sample.Data.Models 
{
    /// <summary>
    /// MastMenu f`
    /// </summary>
    [Serializable()]
	public class MastMenuModel : DbModel<MastMenuEntity,MastMenuProperty>
	{
        /// <summary>
        /// default construct  
        /// </summary>
        public MastMenuModel() : base()
        {
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        public MastMenuModel(Connection connection) : base(connection)
        {
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        /// <param name="property">̃vpeB</param>
        public MastMenuModel(Connection connection, MastMenuProperty property) : base(connection,property)
        {
        }
        List<Association> createAssociation()
        {
            MastSiteProperty siteTable = new MastSiteProperty();
            MastMenuProperty menuTable = new MastMenuProperty();
            MastManuscriptProperty manuscriptTable = new MastManuscriptProperty();

            ExpressionFactory ef = connection.getExpressionFactory();
            //menu - site - manuscript
            Association assoc = new Association(
                "site",
                Association.Multiplicity.TO_ONE,
                new MastSiteProperty(),
                createSite,
                ef.relation(menuTable.siteCode, siteTable.siteCode)
                );
            Association menuManuscriptAssoc = new Association(
                "manuscripts",
                Association.Multiplicity.TO_MANY,
                new MastManuscriptProperty(),
                createManuscript,
                ef.relation(menuTable.siteCode, manuscriptTable.siteCode),
                ef.relation(menuTable.menuCode, manuscriptTable.menuCode)
                );
            List<Association> assocs = new List<Association>();
            assocs.Add(assoc);
            assocs.Add(menuManuscriptAssoc);
            return  assocs;
        }
        public List<MastMenuEntity> findAll()
        {
            try
            {
                connect();
                ExpressionFactory ef = connection.getExpressionFactory();
                MastSiteProperty siteTable = new MastSiteProperty();
                MastMenuProperty menuTable = new MastMenuProperty();
                MastManuscriptProperty manuscriptTable = new MastManuscriptProperty();

                AssociationSelect<MastMenuEntity> select = new AssociationSelect<MastMenuEntity>(connection);
                List<Association> assoc = createAssociation();
                select.associate(assoc[0],assoc[1]);
                select.from(menuTable);
                select.select(siteTable.siteCode);
                select.select(siteTable.name);
                select.select(menuTable.siteCode);
                select.select(menuTable.menuCode);
                select.select(menuTable.name);
                select.select(manuscriptTable.siteCode);
                select.select(manuscriptTable.menuCode);
                select.select(manuscriptTable.seq);
                select.select(manuscriptTable.fromDate);
                select.select(manuscriptTable.endDate);

                Criteria c = new Criteria();
                c.where(ef.columnValue(siteTable.validFlag, 1));
                c.where(ef.columnValue(menuTable.validFlag, 1));
                c.where(ef.columnValue(manuscriptTable.validFlag, 1));
                c.orderBy(siteTable.siteCode);
                c.orderBy(menuTable.menuCode);
                c.orderBy(manuscriptTable.seq);
                c.limit = 1000;
                select.setCriteria(c);

                List<MastMenuEntity> menus = select.queryAsEntity();
                return menus;

            }
            finally
            {
                disconnect();
            }
        }
        Entity createSite(DataRow row, string alias)
        {
            MastSiteEntity site = new MastSiteEntity();
            site.Map(row, alias);
            return site;
        }
        Entity createManuscript(DataRow row, string alias)
        {
            MastManuscriptEntity manuscript = new MastManuscriptEntity();
            manuscript.Map(row, alias);
            return manuscript;
        }

	}

}