using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.Windows.Forms;

namespace FormLoader
{
    public class Loader
    {
        protected static CFW.common.Logger.AbstractLogger log = CFW.common.Logger.LoggerFactory.GetLogger("default", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName);

        public static Form Load(string className, string path)
        {
            log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " start");

            Form frm = GetInstance(path, className);
            log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " end");

            return frm;
        }
        /// <summary>
        /// ݒ肳ꂽF؃voC_[擾
        /// </summary>
        /// <returns></returns>
        static Form GetInstance(string path, string className)
        {
            log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " start");
            Type t = GetImplementationType(path, className);
            if (t == null) throw new Exception("no implement");
            Form p = (Form)System.Activator.CreateInstance(t);

            log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " end");
            return p;

        }
        /// <summary>
        /// w^CvTypeIuWFNg擾
        /// </summary>
        /// <param name="pn"></param>
        /// <returns></returns>
        static Type GetImplementationType(string path, string className)
        {
            log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " end");
            try
            {
                string[] ts = className.Split(',');
                Type t = null;
                try
                {
                    //NXŎ擾ł炻̃^CvԂ
                    t = Type.GetType(ts[0]);
                }
                catch { }
                if (t != null)
                {
                    log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " found  " + ts[0]);
                    return t;
                }
                try
                {
                    //Ȃ悤Ȃ̂dll[hĒTĂ݂BŌȂnull
                    t = AppDomain.CurrentDomain.Load(ts[1]).GetType(ts[0]);
                }
                catch { }
                if (t != null)
                {
                    log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " found " + className);
                    return t;
                }

                //classNameł͌Ȃ
                System.Reflection.Assembly asm = System.Reflection.Assembly.LoadFrom(path);
                t = asm.GetType(ts[0]);
                if (t != null)
                {
                    log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " found with LoadFrom " + path);
                    return t;
                }

                return t;

            }
            catch (Exception)
            {

                throw;
            }
            finally
            {
                log.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name + " end");
            }

        }

    }
}
