using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Truck.Core.Models.Base
{
    /// <summary>
    /// table APPLICATION_MENU Field`
    /// </summary>
    [Serializable()]
    public class ApplicationMenuTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[ID]</summary>
        protected Int32 _id;
        ///<summary>[ID]</summary>
        public Int32 id{
            get{return _id;}
            set{_id = value;}
        }
        ///<summary>[NAME]</summary>
        protected string _name;
        ///<summary>[NAME]</summary>
        public string name{
            get{return _name;}
            set{_name = value;}
        }
        ///<summary>[DISPLAY_NAME]</summary>
        protected string _displayName;
        ///<summary>[DISPLAY_NAME]</summary>
        public string displayName{
            get{return _displayName;}
            set{_displayName = value;}
        }
        ///<summary>[TITLE]</summary>
        protected string _title;
        ///<summary>[TITLE]</summary>
        public string title{
            get{return _title;}
            set{_title = value;}
        }
        ///<summary>[CLASS_NAME]</summary>
        protected string _className;
        ///<summary>[CLASS_NAME]</summary>
        public string className{
            get{return _className;}
            set{_className = value;}
        }
        ///<summary>[EXECUTION_TYPE]</summary>
        protected string _executionType;
        ///<summary>[EXECUTION_TYPE]</summary>
        public string executionType{
            get{return _executionType;}
            set{_executionType = value;}
        }
        ///<summary>[ARGUMENTS]</summary>
        protected string _arguments;
        ///<summary>[ARGUMENTS]</summary>
        public string arguments{
            get{return _arguments;}
            set{_arguments = value;}
        }
        ///<summary>[FORE_COLOR]</summary>
        protected string _foreColor;
        ///<summary>[FORE_COLOR]</summary>
        public string foreColor{
            get{return _foreColor;}
            set{_foreColor = value;}
        }
        ///<summary>[BACK_COLOR]</summary>
        protected string _backColor;
        ///<summary>[BACK_COLOR]</summary>
        public string backColor{
            get{return _backColor;}
            set{_backColor = value;}
        }
        ///<summary>[LEFT_SIDE]</summary>
        protected Int32 _leftSide;
        ///<summary>[LEFT_SIDE]</summary>
        public Int32 leftSide{
            get{return _leftSide;}
            set{_leftSide = value;}
        }
        ///<summary>[RIGHT_SIDE]</summary>
        protected Int32 _rightSide;
        ///<summary>[RIGHT_SIDE]</summary>
        public Int32 rightSide{
            get{return _rightSide;}
            set{_rightSide = value;}
        }
        ///<summary>[DESCRIPTION]</summary>
        protected string _description;
        ///<summary>[DESCRIPTION]</summary>
        public string description{
            get{return _description;}
            set{_description = value;}
        }
        ///<summary>[DELETED]</summary>
        protected Int32 _deleted;
        ///<summary>[DELETED]</summary>
        public Int32 deleted{
            get{return _deleted;}
            set{_deleted = value;}
        }
        ///<summary>[CREATED_AT]</summary>
        protected DateTime? _createdAt;
        ///<summary>[CREATED_AT]</summary>
        public DateTime? createdAt{
            get{return _createdAt;}
            set{_createdAt = value;}
        }
        ///<summary>[MODIFIED_AT]</summary>
        protected DateTime? _modifiedAt;
        ///<summary>[MODIFIED_AT]</summary>
        public DateTime? modifiedAt{
            get{return _modifiedAt;}
            set{_modifiedAt = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public ApplicationMenuTableRow() : base()
        {
            this._id = 0;
            this._name = "";
            this._displayName = "";
            this._title = "";
            this._className = "";
            this._executionType = "";
            this._arguments = "";
            this._foreColor = "";
            this._backColor = "";
            this._leftSide = 0;
            this._rightSide = 0;
            this._description = "";
            this._deleted = 0;
            this._createdAt = null;
            this._modifiedAt = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "ID"){ this._id = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "NAME"){ this._name = StringUtil.StringValue( value );return; }
            if(name ==  "DISPLAY_NAME"){ this._displayName = StringUtil.StringValue( value );return; }
            if(name ==  "TITLE"){ this._title = StringUtil.StringValue( value );return; }
            if(name ==  "CLASS_NAME"){ this._className = StringUtil.StringValue( value );return; }
            if(name ==  "EXECUTION_TYPE"){ this._executionType = StringUtil.StringValue( value );return; }
            if(name ==  "ARGUMENTS"){ this._arguments = StringUtil.StringValue( value );return; }
            if(name ==  "FORE_COLOR"){ this._foreColor = StringUtil.StringValue( value );return; }
            if(name ==  "BACK_COLOR"){ this._backColor = StringUtil.StringValue( value );return; }
            if(name ==  "LEFT_SIDE"){ this._leftSide = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "RIGHT_SIDE"){ this._rightSide = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "DESCRIPTION"){ this._description = StringUtil.StringValue( value );return; }
            if(name ==  "DELETED"){ this._deleted = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "CREATED_AT"){ this._createdAt = DateUtil.DateValue( value );return; }
            if(name ==  "MODIFIED_AT"){ this._modifiedAt = DateUtil.DateValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "ID") return this._id;
            if(name ==  "NAME") return this._name;
            if(name ==  "DISPLAY_NAME") return this._displayName;
            if(name ==  "TITLE") return this._title;
            if(name ==  "CLASS_NAME") return this._className;
            if(name ==  "EXECUTION_TYPE") return this._executionType;
            if(name ==  "ARGUMENTS") return this._arguments;
            if(name ==  "FORE_COLOR") return this._foreColor;
            if(name ==  "BACK_COLOR") return this._backColor;
            if(name ==  "LEFT_SIDE") return this._leftSide;
            if(name ==  "RIGHT_SIDE") return this._rightSide;
            if(name ==  "DESCRIPTION") return this._description;
            if(name ==  "DELETED") return this._deleted;
            if(name ==  "CREATED_AT") return this._createdAt;
            if(name ==  "MODIFIED_AT") return this._modifiedAt;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            ApplicationMenuTableRow clone = new ApplicationMenuTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(ApplicationMenuTableRow source)
        {
            this.id = source.id;
            this.name = source.name;
            this.displayName = source.displayName;
            this.title = source.title;
            this.className = source.className;
            this.executionType = source.executionType;
            this.arguments = source.arguments;
            this.foreColor = source.foreColor;
            this.backColor = source.backColor;
            this.leftSide = source.leftSide;
            this.rightSide = source.rightSide;
            this.description = source.description;
            this.deleted = source.deleted;
            this.createdAt = source.createdAt;
            this.modifiedAt = source.modifiedAt;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("ID")){ this._id = NumberUtil.Value<Int32>(row["ID"]); }
            if (cols.Contains("NAME")){ this._name = StringUtil.StringValue(row["NAME"]); }
            if (cols.Contains("DISPLAY_NAME")){ this._displayName = StringUtil.StringValue(row["DISPLAY_NAME"]); }
            if (cols.Contains("TITLE")){ this._title = StringUtil.StringValue(row["TITLE"]); }
            if (cols.Contains("CLASS_NAME")){ this._className = StringUtil.StringValue(row["CLASS_NAME"]); }
            if (cols.Contains("EXECUTION_TYPE")){ this._executionType = StringUtil.StringValue(row["EXECUTION_TYPE"]); }
            if (cols.Contains("ARGUMENTS")){ this._arguments = StringUtil.StringValue(row["ARGUMENTS"]); }
            if (cols.Contains("FORE_COLOR")){ this._foreColor = StringUtil.StringValue(row["FORE_COLOR"]); }
            if (cols.Contains("BACK_COLOR")){ this._backColor = StringUtil.StringValue(row["BACK_COLOR"]); }
            if (cols.Contains("LEFT_SIDE")){ this._leftSide = NumberUtil.Value<Int32>(row["LEFT_SIDE"]); }
            if (cols.Contains("RIGHT_SIDE")){ this._rightSide = NumberUtil.Value<Int32>(row["RIGHT_SIDE"]); }
            if (cols.Contains("DESCRIPTION")){ this._description = StringUtil.StringValue(row["DESCRIPTION"]); }
            if (cols.Contains("DELETED")){ this._deleted = NumberUtil.Value<Int32>(row["DELETED"]); }
            if (cols.Contains("CREATED_AT")){ this._createdAt = DateUtil.DateValue(row["CREATED_AT"]); }
            if (cols.Contains("MODIFIED_AT")){ this._modifiedAt = DateUtil.DateValue(row["MODIFIED_AT"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "ID");if (cols.Contains(columnName)){ this._id = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "NAME");if (cols.Contains(columnName)){ this._name = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DISPLAY_NAME");if (cols.Contains(columnName)){ this._displayName = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "TITLE");if (cols.Contains(columnName)){ this._title = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CLASS_NAME");if (cols.Contains(columnName)){ this._className = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "EXECUTION_TYPE");if (cols.Contains(columnName)){ this._executionType = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ARGUMENTS");if (cols.Contains(columnName)){ this._arguments = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "FORE_COLOR");if (cols.Contains(columnName)){ this._foreColor = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "BACK_COLOR");if (cols.Contains(columnName)){ this._backColor = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "LEFT_SIDE");if (cols.Contains(columnName)){ this._leftSide = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "RIGHT_SIDE");if (cols.Contains(columnName)){ this._rightSide = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "DESCRIPTION");if (cols.Contains(columnName)){ this._description = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DELETED");if (cols.Contains(columnName)){ this._deleted = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "CREATED_AT");if (cols.Contains(columnName)){ this._createdAt = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MODIFIED_AT");if (cols.Contains(columnName)){ this._modifiedAt = DateUtil.DateValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._id = NumberUtil.Value<Int32>(reader[0]);
            this._name = StringUtil.StringValue(reader[1]);
            this._displayName = StringUtil.StringValue(reader[2]);
            this._title = StringUtil.StringValue(reader[3]);
            this._className = StringUtil.StringValue(reader[4]);
            this._executionType = StringUtil.StringValue(reader[5]);
            this._arguments = StringUtil.StringValue(reader[6]);
            this._foreColor = StringUtil.StringValue(reader[7]);
            this._backColor = StringUtil.StringValue(reader[8]);
            this._leftSide = NumberUtil.Value<Int32>(reader[9]);
            this._rightSide = NumberUtil.Value<Int32>(reader[10]);
            this._description = StringUtil.StringValue(reader[11]);
            this._deleted = NumberUtil.Value<Int32>(reader[12]);
            this._createdAt = DateUtil.DateValue(reader[13]);
            this._modifiedAt = DateUtil.DateValue(reader[14]);
            
            this.IsNew = false;
        }
    }

}