using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace ConnectionTest.Models.Base
{
    /// <summary>
    /// table sample Field`
    /// </summary>
    [Serializable()]
    [Connection.Attr.Entity("sample1")]
    public class SampleTableRow2 : CFW.Models.Entity,ICloneable
    {
        ///<summary>[id]</summary>
        protected Int32 _id;
        ///<summary>[id]</summary>
        [Connection.Attr.Field(sqlTypeName="int", fieldName="id",displayName="ID")]
        public Int32 id
        {
            get{return _id;}
            set{_id = value;}
        }
        ///<summary>[short_field]</summary>
        protected System.Nullable<Int16> _shortField;
        ///<summary>[short_field]</summary>
        [Connection.Attr.Field(sqlTypeName="smallint",fieldName = "short_field",displayName="16rbgtB[h")]
        public System.Nullable<Int16> shortField
        {
            get{return _shortField;}
            set{_shortField = value;}
        }
        ///<summary>[date_field]</summary>
        protected DateTime? _dateField;
        ///<summary>[date_field]</summary>
        [Connection.Attr.Field(sqlTypeName="datetime",fieldName = "date_field")]
        public DateTime? dateField
        {
            get{return _dateField;}
            set{_dateField = value;}
        }
        ///<summary>[timestamp_field]</summary>
        protected DateTime? _timestampField;
        ///<summary>[timestamp_field]</summary>
        [Connection.Attr.Field(sqlTypeName="datetime",fieldName = "timestamp_field")]
        public DateTime? timestampField
        {
            get{return _timestampField;}
            set{_timestampField = value;}
        }
        ///<summary>[string_field1]</summary>
        protected string _stringField1;
        ///<summary>[string_field1]</summary>
        [Connection.Attr.Field(sqlTypeName="varchar",fieldName = "string_field1")]
        public string stringField1
        {
            get{return _stringField1;}
            set{_stringField1 = value;}
        }
        ///<summary>[string_field2]</summary>
        protected string _stringField2;
        ///<summary>[string_field2]</summary>
        [Connection.Attr.Field(sqlTypeName="nvarchar",fieldName = "string_field2",length=10)]
        public string stringField2
        {
            get{return _stringField2;}
            set{_stringField2 = value;}
        }
        ///<summary>[string_field3]</summary>
        protected string _stringField3;
        ///<summary>[string_field3]</summary>
        [Connection.Attr.Field(sqlTypeName="nvarchar",fieldName = "string_field2", length = 100)]
        public string stringField3
        {
            get{return _stringField3;}
            set{_stringField3 = value;}
        }
        ///<summary>[number_field1]</summary>
        protected System.Nullable<Decimal> _numberField1;
        ///<summary>[number_field1]</summary>
        [Connection.Attr.Field(sqlTypeName="decimal",fieldName = "number_field1", precision = 18,scale=0,defaultValue=0)]
        public System.Nullable<Decimal> numberField1
        {
            get{return _numberField1;}
            set{_numberField1 = value;}
        }
        ///<summary>[number_field2]</summary>
        protected System.Nullable<Decimal> _numberField2;
        ///<summary>[number_field2]</summary>
        [Connection.Attr.Field(sqlTypeName="decimal",fieldName = "number_field2", precision = 10, scale = 0, defaultValue = 0)]
        public System.Nullable<Decimal> numberField2
        {
            get{return _numberField2;}
            set{_numberField2 = value;}
        }
        ///<summary>[number_field3]</summary>
        protected System.Nullable<Decimal> _numberField3;
        ///<summary>[number_field3]</summary>
        [Connection.Attr.Field(sqlTypeName="decimal",fieldName = "number_field3", precision = 10, scale = 2, defaultValue = 0)]
        public System.Nullable<Decimal> numberField3
        {
            get{return _numberField3;}
            set{_numberField3 = value;}
        }
        ///<summary>[date_field]</summary>
        protected DateTime? _createdAt;
        ///<summary>[date_field]</summary>
        [Connection.Attr.Field(sqlTypeName="datetime",fieldName = "created_at")]
        [Connection.Attr.CreatedAtField]
        public DateTime? createdAt
        {
            get { return _createdAt; }
            set { _createdAt = value; }
        }
        ///<summary>[date_field]</summary>
        protected DateTime? _modifieddAt;
        ///<summary>[date_field]</summary>
        [Connection.Attr.Field(sqlTypeName="datetime",fieldName = "modified_at")]
        [Connection.Attr.ModifiedAtField]
        public DateTime? modifiedAt
        {
            get { return _modifieddAt; }
            set { _modifieddAt = value; }
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public SampleTableRow2()
            : base()
        {
            this._id = 0;
            this._shortField = null;
            this._dateField = null;
            this._timestampField = null;
            this._stringField1 = "";
            this._stringField2 = "";
            this._stringField3 = "";
            this._numberField1 = null;
            this._numberField2 = null;
            this._numberField3 = null;
            
        }

        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if (name == "id") { this._id = NumberUtil.Value<Int32>(value); return; }
            if (name == "short_field") { this._shortField = NumberUtil.Value<Int16?>(value); return; }
            if (name == "date_field") { this._dateField = DateUtil.DateValue(value); return; }
            if (name == "timestamp_field") { this._timestampField = DateUtil.DateValue(value); return; }
            if (name == "string_field1") { this._stringField1 = StringUtil.StringValue(value); return; }
            if (name == "string_field2") { this._stringField2 = StringUtil.StringValue(value); return; }
            if (name == "string_field3") { this._stringField3 = StringUtil.StringValue(value); return; }
            if (name == "number_field1") { this._numberField1 = NumberUtil.Value<Decimal?>(value); return; }
            if (name == "number_field2") { this._numberField2 = NumberUtil.Value<Decimal?>(value); return; }
            if (name == "number_field3") { this._numberField3 = NumberUtil.Value<Decimal?>(value); return; }

        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if (name == "id") return this._id;
            if (name == "short_field") return this._shortField;
            if (name == "date_field") return this._dateField;
            if (name == "timestamp_field") return this._timestampField;
            if (name == "string_field1") return this._stringField1;
            if (name == "string_field2") return this._stringField2;
            if (name == "string_field3") return this._stringField3;
            if (name == "number_field1") return this._numberField1;
            if (name == "number_field2") return this._numberField2;
            if (name == "number_field3") return this._numberField3;

            return null;
        }

        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            SampleTableRow2 clone = new SampleTableRow2();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(SampleTableRow2 source)
        {
            this.id = source.id;
            this.shortField = source.shortField;
            this.dateField = source.dateField;
            this.timestampField = source.timestampField;
            this.stringField1 = source.stringField1;
            this.stringField2 = source.stringField2;
            this.stringField3 = source.stringField3;
            this.numberField1 = source.numberField1;
            this.numberField2 = source.numberField2;
            this.numberField3 = source.numberField3;


            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;

        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("id")) { this._id = NumberUtil.Value<Int32>(row["id"]); }
            if (cols.Contains("short_field")) { this._shortField = NumberUtil.Value<Int16?>(row["short_field"]); }
            if (cols.Contains("date_field")) { this._dateField = DateUtil.DateValue(row["date_field"]); }
            if (cols.Contains("timestamp_field")) { this._timestampField = DateUtil.DateValue(row["timestamp_field"]); }
            if (cols.Contains("string_field1")) { this._stringField1 = StringUtil.StringValue(row["string_field1"]); }
            if (cols.Contains("string_field2")) { this._stringField2 = StringUtil.StringValue(row["string_field2"]); }
            if (cols.Contains("string_field3")) { this._stringField3 = StringUtil.StringValue(row["string_field3"]); }
            if (cols.Contains("number_field1")) { this._numberField1 = NumberUtil.Value<Decimal?>(row["number_field1"]); }
            if (cols.Contains("number_field2")) { this._numberField2 = NumberUtil.Value<Decimal?>(row["number_field2"]); }
            if (cols.Contains("number_field3")) { this._numberField3 = NumberUtil.Value<Decimal?>(row["number_field3"]); }

            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row, string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "id"); if (cols.Contains(columnName)) { this._id = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "short_field"); if (cols.Contains(columnName)) { this._shortField = NumberUtil.Value<Int16?>(row[columnName]); }
            columnName = BuildColumnName(alias, "date_field"); if (cols.Contains(columnName)) { this._dateField = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "timestamp_field"); if (cols.Contains(columnName)) { this._timestampField = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "string_field1"); if (cols.Contains(columnName)) { this._stringField1 = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "string_field2"); if (cols.Contains(columnName)) { this._stringField2 = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "string_field3"); if (cols.Contains(columnName)) { this._stringField3 = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "number_field1"); if (cols.Contains(columnName)) { this._numberField1 = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "number_field2"); if (cols.Contains(columnName)) { this._numberField2 = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "number_field3"); if (cols.Contains(columnName)) { this._numberField3 = NumberUtil.Value<Decimal?>(row[columnName]); }

            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._id = NumberUtil.Value<Int32>(reader[0]);
            this._shortField = NumberUtil.Value<Int16?>(reader[1]);
            this._dateField = DateUtil.DateValue(reader[2]);
            this._timestampField = DateUtil.DateValue(reader[3]);
            this._stringField1 = StringUtil.StringValue(reader[4]);
            this._stringField2 = StringUtil.StringValue(reader[5]);
            this._stringField3 = StringUtil.StringValue(reader[6]);
            this._numberField1 = NumberUtil.Value<Decimal?>(reader[7]);
            this._numberField2 = NumberUtil.Value<Decimal?>(reader[8]);
            this._numberField3 = NumberUtil.Value<Decimal?>(reader[9]);

            this.IsNew = false;
        }
    }

}