using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;

using CFW.Models;
using CFW.Util;
using CFW.Database;
namespace DbCommandExec
{
    public partial class CommandEditorForm : Form
    {
        Enumerations typeEnumeration = new Enumerations();
        BindingList<Parameter> parameters;
        public Command command;

        public CommandEditorForm()
        {
            InitializeComponent();

            dataGridView1.AutoGenerateColumns = false;
            createTypeEnumeration();
            DataGridViewComboBoxColumn typeCombo = dataGridView1.Columns[1] as DataGridViewComboBoxColumn;
            typeCombo.DisplayMember = "Name";
            typeCombo.ValueMember = "Id";
            typeCombo.DataSource = typeEnumeration;

            command = new Command();
            parameters = new BindingList<Parameter>();
            parameters.AllowEdit = true;
            parameters.AllowNew = true;
            parameters.AllowRemove = true;

        }

        private void CommandEditor_Load(object sender, EventArgs e)
        {
            if (command == null) command = new Command();
            parameters = new BindingList<Parameter>(command.Parameters);
            updateView();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            updateCommand();
            DialogResult = DialogResult.OK;
        }
        void updateView()
        {
            textBox1.Text = command.Text;
            dataGridView1.DataSource = parameters;
            dataGridView1.Refresh();
        }
        void updateCommand()
        {
            command.Text = textBox1.Text;
            command.Parameters = fixParameters();
        }
        List<Parameter> fixParameters()
        {
            List<Parameter> fixedParameters = new List<Parameter>();
            foreach (Parameter p in parameters)
            {
                p.ParameterValue = filterValue(p.ParameterType, p.ParameterValue);
                fixedParameters.Add(p);
            }
            return fixedParameters;
        }
        private void createTypeEnumeration()
        {
            typeEnumeration.Add(createTypeEnumerationItem(DbType.AnsiString));
            typeEnumeration.Add(createTypeEnumerationItem(DbType.AnsiStringFixedLength));
            typeEnumeration.Add(createTypeEnumerationItem(DbType.Boolean));
            typeEnumeration.Add(createTypeEnumerationItem(DbType.Byte));
            typeEnumeration.Add(createTypeEnumerationItem(DbType.DateTime));
            typeEnumeration.Add(createTypeEnumerationItem(DbType.Decimal));
            typeEnumeration.Add(createTypeEnumerationItem(DbType.Double));
            typeEnumeration.Add(createTypeEnumerationItem(DbType.Int16));
            typeEnumeration.Add(createTypeEnumerationItem(DbType.Int32));
            typeEnumeration.Add(createTypeEnumerationItem(DbType.Int64));
            typeEnumeration.Add(createTypeEnumerationItem(DbType.Single));
            typeEnumeration.Add(createTypeEnumerationItem(DbType.String));
            typeEnumeration.Add(createTypeEnumerationItem(DbType.StringFixedLength));
        }
        private SimpleEnumerationItem createTypeEnumerationItem(DbType t)
        {
            return new SimpleEnumerationItem(t,t.ToString());
        }
        object filterValue(DbType t, object value)
        {
            switch (t)
            {
                case DbType.AnsiString: return StringUtil.StringValue(value);
                case DbType.AnsiStringFixedLength: return StringUtil.StringValue(value);
                case DbType.Boolean: return NumberUtil.BoolValue(value);
                case DbType.Byte: return NumberUtil.Value<byte?>(value);
                case DbType.DateTime: return DateUtil.DateValue(value);
                case DbType.Decimal: return NumberUtil.Value<decimal?>(value);
                case DbType.Double: return NumberUtil.Value<double?>(value);
                case DbType.Int16: return NumberUtil.Value<Int16?>(value);
                case DbType.Int32: return NumberUtil.Value<Int32?>(value);
                case DbType.Int64: return NumberUtil.Value<Int64?>(value);
                case DbType.Single: return NumberUtil.Value<float?>(value);
                case DbType.String: return StringUtil.StringValue(value);
                case DbType.StringFixedLength: return StringUtil.StringValue(value);
                default: return value;
            }
        }
        Parameter createParameter(DataGridViewRow row)
        {
            return new Parameter();
        }

        private void dataGridView1_DataError(object sender, DataGridViewDataErrorEventArgs e)
        {
            MessageBox.Show(e.ToString());
        }

        private void formatButton_Click(object sender, EventArgs e)
        {
            StringBuilder builder = new StringBuilder(textBox1.Text);

            builder.Replace(",", "," + Environment.NewLine);
            builder.Replace(" FROM ", Environment.NewLine + "FROM ");
            builder.Replace(" INNER ", Environment.NewLine + " INNER ");
            builder.Replace(" LEFT ", Environment.NewLine + " LEFT ");
            builder.Replace(" RIGHT ", Environment.NewLine + " RIGHT ");
            builder.Replace(" ON ", Environment.NewLine + " ON ");
            builder.Replace(" WHERE ", Environment.NewLine + " WHERE ");
            builder.Replace(" HAVING ", Environment.NewLine + " HAVING ");
            builder.Replace(" GROUP BY ", Environment.NewLine + " GROUP BY ");
            builder.Replace(" ORDER BY ", Environment.NewLine + " ORDER BY ");
            builder.Replace(" AND ", Environment.NewLine + " AND ");
            builder.Replace(" OR ", Environment.NewLine + " OR ");

            textBox1.Text = builder.ToString();

        }
    }
}