using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Windows.Forms;
using CFW.Windows.Forms.Adapters;

namespace FormAdapterSample
{
    public partial class DateInputTest : Form
    {
        DateInputElement element1;
        DateInputElement element2;
        DateInputElement element3;

        public DateInputTest()
        {
            InitializeComponent();

            element1 = new DateInputElement(textBox1, "yyyy/M/d", "yyyy/MM/dd");
            element2 = new DateInputElement(textBox2, "H:m:s", "HH:mm:ss");
            element3 = new DateInputElement(textBox3, "yyyy/M/d H:m:s", "yyyy/MM/dd HH:mm:ss");
        }

        private void button1_Click(object sender, EventArgs e)
        {
            element1.UpdateField();
            element2.UpdateField();
            element3.UpdateField();

            result1.Text = (element1.Validate(true)) ? CFW.Util.StringUtil.StringValue(element1.GetValue()) : element1.ErrorMessage;
            result2.Text = (element2.Validate(true)) ? CFW.Util.StringUtil.StringValue(element2.GetValue()) : element2.ErrorMessage;
            result3.Text = (element3.Validate(true)) ? CFW.Util.StringUtil.StringValue(element3.GetValue()) : element3.ErrorMessage;

        }

        private void button2_Click(object sender, EventArgs e)
        {
            DateTime? newValue = CFW.Util.DateUtil.Parse(newValueInput.Text);
            element1.SetValue(newValue, true);
            element2.SetValue(newValue, true);
            element3.SetValue(newValue, true);

        }
    }
}