using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Xml;
using System.Xml.Serialization;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.TableCommand;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableProperty;


namespace Konozama.Shop.Model.TableAccess
{
    /// <summary>
    /// table[order_items]ɑ΂鑀
    /// </summary>
    [Serializable()]
    public class OrderItemsTableAccess
    {
        /// <summary>
        /// f[^\[Xւ̐ڑ
        /// </summary>
        private Connection connection;
        /// <summary>
        /// order_itemsɑΉvpeB
        /// </summary>
        private OrderItemsTableProperty property;



#region constructors
        /// <summary>
        /// default construct  gps
        /// </summary>
        private OrderItemsTableAccess()
        {
            this.connection = ConnectionFactory.GetConnectionByName("default");
            this.property = new OrderItemsTableProperty();
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        public OrderItemsTableAccess(Connection db)
        {
            this.connection = db;
            this.property = new  OrderItemsTableProperty();
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="db">̐ڑBJĂO</param>
        public OrderItemsTableAccess(Connection db, OrderItemsTableProperty property)
        {
            this.connection = db;
            this.property = property;
        }
#endregion

#region public interface
        /// <summary>
        /// order_items֍s̑}
        /// </summary>
        /// <param name="data">}sf[^</param>
        public int Insert(OrderItemsTableRow data)
        {
            TableInsertCommand command = BuildInsertCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }

        /// <summary>
        /// order_items֍s̍XV
        /// </summary>
        /// <param name="data">XVsf[^</param>
        public int Update(OrderItemsTableRow data)
        {
            TableUpdateCommand command = BuildUpdateCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// order_items֍s̍XV
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo</remarks>
        /// <param name="data">XVsf[^</param>
        /// <param name="condition"></param>
        public int Update(OrderItemsTableRow data,  TableCommandCondition condition)
        {
            TableUpdateCommand command = BuildUpdateCommand(data,condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// order_itemss̍폜
        /// </summary>
        /// <param name="data">폜sf[^BL[̂݃ZbgłĂOK</param>
        public int Delete(OrderItemsTableRow data)
        {
            TableDeleteCommand command = BuildDeleteCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// order_itemss̍폜
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo
        /// <param name="condition"></param>
        public int Delete(TableCommandCondition condition)
        {
            TableDeleteCommand command = BuildDeleteCommand(condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// order_items̍s݊mF
        /// </summary>
        /// <param name="data">L[ݒ肵f[^</param>
        /// <return>ݒ肵L[ɊYs݂鎞true</return>
        public bool Exists(OrderItemsTableRow data)
        {
            TableSelectCommand command = BuildExistsCommand(data);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            int cnt = NumberUtil.IntValue(result.Tables[0].Rows[0][0]);
            if(cnt > 0) return true;
            else return false;
        }
        /// <summary>
        /// order_items̍s擾
        /// L[1s擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">L[ݒ肵f[^</param>
        public OrderItemsTableRow Get(OrderItemsTableRow condition)
        {
            TableSelectCommand command = BuildSelectCommand(condition);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            OrderItemsTableRow data = null;

            if(result.Tables[0].Rows.Count>0){
                data = new OrderItemsTableRow();
                data.Map(result.Tables[0].Rows[0],"order_items");
                data.IsNew = false;
            }
            return data;
        }
        /// <summary>
        /// order_items̍s擾
        /// [U[ݒɊYsׂĎ擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">WHERE</param>
        /// <param name="order">\[g</param>
        public List<OrderItemsTableRow> GetList( TableCommandCondition condition,List<TableCommandColumn> order)
        {
            OrderItemsTableRow data = null;

            TableSelectCommand command = BuildSelectCommand(condition,order);

            DataSet result = connection.ExecuteQuery(command.GetCommand());

			List<OrderItemsTableRow> list = new List<OrderItemsTableRow>();
            if(result.Tables[0].Rows.Count>0){
                for (int i = 0; i < result.Tables[0].Rows.Count; i++)
                {
	                data = new OrderItemsTableRow();
	                data.Map(result.Tables[0].Rows[0],"order_items");
                    data.IsNew = false;
                    list.Add(data);
                }
            }
            return list;
        }
#endregion
        /// <summary>
        /// order_itemsւinsert sqlR}h
        /// </summary>
        /// <param name="data">ǉf[^</param>
        public TableInsertCommand BuildInsertCommand(OrderItemsTableRow data)
        {
            TableInsertCommand command = new TableInsertCommand("order_items");

            if (property.Id.DoUpdate) command.AddInsert(property.Id, data.Id);
            if (property.OrderId.DoUpdate) command.AddInsert(property.OrderId, data.OrderId);
            if (property.ProductId.DoUpdate) command.AddInsert(property.ProductId, data.ProductId);
            if (property.UnitPrice.DoUpdate) command.AddInsert(property.UnitPrice, data.UnitPrice);
            if (property.Quantity.DoUpdate) command.AddInsert(property.Quantity, data.Quantity);
            if (property.Price.DoUpdate) command.AddInsert(property.Price, data.Price);
            
            return command;
        }
        /// <summary>
        /// order_itemsւupdate sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        public TableUpdateCommand BuildUpdateCommand(OrderItemsTableRow data)
        {
            TableUpdateCommand command = new TableUpdateCommand("order_items");

            //XV`
            if (property.Id.DoUpdate) command.AddUpdate(property.Id, data.Id);
            if (property.OrderId.DoUpdate) command.AddUpdate(property.OrderId, data.OrderId);
            if (property.ProductId.DoUpdate) command.AddUpdate(property.ProductId, data.ProductId);
            if (property.UnitPrice.DoUpdate) command.AddUpdate(property.UnitPrice, data.UnitPrice);
            if (property.Quantity.DoUpdate) command.AddUpdate(property.Quantity, data.Quantity);
            if (property.Price.DoUpdate) command.AddUpdate(property.Price, data.Price);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            
            return command;
        }

        /// <summary>
        /// order_itemsւ̍XVSqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        /// <param name="condition">Ώۏ</param>
        public TableUpdateCommand BuildUpdateCommand(OrderItemsTableRow data, TableCommandCondition condition)
        {
            TableUpdateCommand command = new TableUpdateCommand("order_items");

            //XV`
            if (property.Id.DoUpdate) command.AddUpdate(property.Id, data.Id);
            if (property.OrderId.DoUpdate) command.AddUpdate(property.OrderId, data.OrderId);
            if (property.ProductId.DoUpdate) command.AddUpdate(property.ProductId, data.ProductId);
            if (property.UnitPrice.DoUpdate) command.AddUpdate(property.UnitPrice, data.UnitPrice);
            if (property.Quantity.DoUpdate) command.AddUpdate(property.Quantity, data.Quantity);
            if (property.Price.DoUpdate) command.AddUpdate(property.Price, data.Price);
            

            //XV`
            command.AddWhere(condition);

            return command;
        }

        /// <summary>
        /// order_itemsւselect sqlR}h(WHERE͊O炤
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(TableCommandCondition condition)
        {
            TableDeleteCommand command = new TableDeleteCommand("order_items");


            //XV`
            command.AddWhere(condition);

            return command;
        }
        /// <summary>
        /// order_itemsւdelete sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(OrderItemsTableRow data)
        {
            TableDeleteCommand command = new TableDeleteCommand("order_items");

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// order_itemsւselect count(*)(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildExistsCommand(OrderItemsTableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("order_items");

            //XV`
            command.AddSelect(new TableCommandColumn("CNT","COUNT(*)"));

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// order_itemsւselect sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildSelectCommand(OrderItemsTableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("order_items");

            //XV`
            command.AddSelect(property.Id);
            command.AddSelect(property.OrderId);
            command.AddSelect(property.ProductId);
            command.AddSelect(property.UnitPrice);
            command.AddSelect(property.Quantity);
            command.AddSelect(property.Price);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// order_itemsւselect sqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        /// <param name="order">\[g</param>
        public TableSelectCommand BuildSelectCommand(TableCommandCondition condition,List<TableCommandColumn> order)
        {
            TableSelectCommand command = new TableSelectCommand("order_items");

            //XV`
            command.AddSelect(property.Id);
            command.AddSelect(property.OrderId);
            command.AddSelect(property.ProductId);
            command.AddSelect(property.UnitPrice);
            command.AddSelect(property.Quantity);
            command.AddSelect(property.Price);
            

            //XV`
            if(condition != null)   command.AddWhere(condition);
            //
            if (order != null) command.OrderBy.AddRange(order);

            return command;
        }
        /// <summary>
        /// order_itemsselect list
        /// </summary>
        /// <param name="tableAlias">e[uɕtʖ</param>
        /// <param name="columnAliasPrefix">ɕtʖ̐ړ</param>
        public string  GetSelectListString(string tableAlias , string columnAliasPrefix)
        {
        	StringBuilder builder = new StringBuilder();

            //XV`
            builder.AppendLine(", "+ tableAlias + ".id AS " + columnAliasPrefix + "id" );
            builder.AppendLine(", "+ tableAlias + ".order_id AS " + columnAliasPrefix + "order_id" );
            builder.AppendLine(", "+ tableAlias + ".product_id AS " + columnAliasPrefix + "product_id" );
            builder.AppendLine(", "+ tableAlias + ".unit_price AS " + columnAliasPrefix + "unit_price" );
            builder.AppendLine(", "+ tableAlias + ".quantity AS " + columnAliasPrefix + "quantity" );
            builder.AppendLine(", "+ tableAlias + ".price AS " + columnAliasPrefix + "price" );
            

            return builder.ToString().Substring(1);
        }
    }
}
