using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Xml;
using System.Xml.Serialization;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.TableCommand;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableProperty;


namespace Konozama.Shop.Model.TableAccess
{
    /// <summary>
    /// table[orders]ɑ΂鑀
    /// </summary>
    [Serializable()]
    public class OrdersTableAccess
    {
        /// <summary>
        /// f[^\[Xւ̐ڑ
        /// </summary>
        private Connection connection;
        /// <summary>
        /// ordersɑΉvpeB
        /// </summary>
        private OrdersTableProperty property;



#region constructors
        /// <summary>
        /// default construct  gps
        /// </summary>
        private OrdersTableAccess()
        {
            this.connection = ConnectionFactory.GetConnectionByName("default");
            this.property = new OrdersTableProperty();
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        public OrdersTableAccess(Connection db)
        {
            this.connection = db;
            this.property = new  OrdersTableProperty();
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="db">̐ڑBJĂO</param>
        public OrdersTableAccess(Connection db, OrdersTableProperty property)
        {
            this.connection = db;
            this.property = property;
        }
#endregion

#region public interface
        /// <summary>
        /// orders֍s̑}
        /// </summary>
        /// <param name="data">}sf[^</param>
        public int Insert(OrdersTableRow data)
        {
            TableInsertCommand command = BuildInsertCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }

        /// <summary>
        /// orders֍s̍XV
        /// </summary>
        /// <param name="data">XVsf[^</param>
        public int Update(OrdersTableRow data)
        {
            TableUpdateCommand command = BuildUpdateCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// orders֍s̍XV
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo</remarks>
        /// <param name="data">XVsf[^</param>
        /// <param name="condition"></param>
        public int Update(OrdersTableRow data,  TableCommandCondition condition)
        {
            TableUpdateCommand command = BuildUpdateCommand(data,condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// orderss̍폜
        /// </summary>
        /// <param name="data">폜sf[^BL[̂݃ZbgłĂOK</param>
        public int Delete(OrdersTableRow data)
        {
            TableDeleteCommand command = BuildDeleteCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// orderss̍폜
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo
        /// <param name="condition"></param>
        public int Delete(TableCommandCondition condition)
        {
            TableDeleteCommand command = BuildDeleteCommand(condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// orders̍s݊mF
        /// </summary>
        /// <param name="data">L[ݒ肵f[^</param>
        /// <return>ݒ肵L[ɊYs݂鎞true</return>
        public bool Exists(OrdersTableRow data)
        {
            TableSelectCommand command = BuildExistsCommand(data);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            int cnt = NumberUtil.IntValue(result.Tables[0].Rows[0][0]);
            if(cnt > 0) return true;
            else return false;
        }
        /// <summary>
        /// orders̍s擾
        /// L[1s擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">L[ݒ肵f[^</param>
        public OrdersTableRow Get(OrdersTableRow condition)
        {
            TableSelectCommand command = BuildSelectCommand(condition);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            OrdersTableRow data = null;

            if(result.Tables[0].Rows.Count>0){
                data = new OrdersTableRow();
                data.Map(result.Tables[0].Rows[0],"orders");
                data.IsNew = false;
            }
            return data;
        }
        /// <summary>
        /// orders̍s擾
        /// [U[ݒɊYsׂĎ擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">WHERE</param>
        /// <param name="order">\[g</param>
        public List<OrdersTableRow> GetList( TableCommandCondition condition,List<TableCommandColumn> order)
        {
            OrdersTableRow data = null;

            TableSelectCommand command = BuildSelectCommand(condition,order);

            DataSet result = connection.ExecuteQuery(command.GetCommand());

			List<OrdersTableRow> list = new List<OrdersTableRow>();
            if(result.Tables[0].Rows.Count>0){
                for (int i = 0; i < result.Tables[0].Rows.Count; i++)
                {
	                data = new OrdersTableRow();
	                data.Map(result.Tables[0].Rows[0],"orders");
                    data.IsNew = false;
                    list.Add(data);
                }
            }
            return list;
        }
#endregion
        /// <summary>
        /// ordersւinsert sqlR}h
        /// </summary>
        /// <param name="data">ǉf[^</param>
        public TableInsertCommand BuildInsertCommand(OrdersTableRow data)
        {
            TableInsertCommand command = new TableInsertCommand("orders");

            if (property.Id.DoUpdate) command.AddInsert(property.Id, data.Id);
            if (property.CustomerId.DoUpdate) command.AddInsert(property.CustomerId, data.CustomerId);
            if (property.OrderDate.DoUpdate) command.AddInsert(property.OrderDate, data.OrderDate);
            if (property.PaymentMethod.DoUpdate) command.AddInsert(property.PaymentMethod, data.PaymentMethod);
            if (property.DeliveryPlace.DoUpdate) command.AddInsert(property.DeliveryPlace, data.DeliveryPlace);
            
            return command;
        }
        /// <summary>
        /// ordersւupdate sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        public TableUpdateCommand BuildUpdateCommand(OrdersTableRow data)
        {
            TableUpdateCommand command = new TableUpdateCommand("orders");

            //XV`
            if (property.Id.DoUpdate) command.AddUpdate(property.Id, data.Id);
            if (property.CustomerId.DoUpdate) command.AddUpdate(property.CustomerId, data.CustomerId);
            if (property.OrderDate.DoUpdate) command.AddUpdate(property.OrderDate, data.OrderDate);
            if (property.PaymentMethod.DoUpdate) command.AddUpdate(property.PaymentMethod, data.PaymentMethod);
            if (property.DeliveryPlace.DoUpdate) command.AddUpdate(property.DeliveryPlace, data.DeliveryPlace);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            
            return command;
        }

        /// <summary>
        /// ordersւ̍XVSqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        /// <param name="condition">Ώۏ</param>
        public TableUpdateCommand BuildUpdateCommand(OrdersTableRow data, TableCommandCondition condition)
        {
            TableUpdateCommand command = new TableUpdateCommand("orders");

            //XV`
            if (property.Id.DoUpdate) command.AddUpdate(property.Id, data.Id);
            if (property.CustomerId.DoUpdate) command.AddUpdate(property.CustomerId, data.CustomerId);
            if (property.OrderDate.DoUpdate) command.AddUpdate(property.OrderDate, data.OrderDate);
            if (property.PaymentMethod.DoUpdate) command.AddUpdate(property.PaymentMethod, data.PaymentMethod);
            if (property.DeliveryPlace.DoUpdate) command.AddUpdate(property.DeliveryPlace, data.DeliveryPlace);
            

            //XV`
            command.AddWhere(condition);

            return command;
        }

        /// <summary>
        /// ordersւselect sqlR}h(WHERE͊O炤
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(TableCommandCondition condition)
        {
            TableDeleteCommand command = new TableDeleteCommand("orders");


            //XV`
            command.AddWhere(condition);

            return command;
        }
        /// <summary>
        /// ordersւdelete sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(OrdersTableRow data)
        {
            TableDeleteCommand command = new TableDeleteCommand("orders");

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// ordersւselect count(*)(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildExistsCommand(OrdersTableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("orders");

            //XV`
            command.AddSelect(new TableCommandColumn("CNT","COUNT(*)"));

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// ordersւselect sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildSelectCommand(OrdersTableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("orders");

            //XV`
            command.AddSelect(property.Id);
            command.AddSelect(property.CustomerId);
            command.AddSelect(property.OrderDate);
            command.AddSelect(property.PaymentMethod);
            command.AddSelect(property.DeliveryPlace);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// ordersւselect sqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        /// <param name="order">\[g</param>
        public TableSelectCommand BuildSelectCommand(TableCommandCondition condition,List<TableCommandColumn> order)
        {
            TableSelectCommand command = new TableSelectCommand("orders");

            //XV`
            command.AddSelect(property.Id);
            command.AddSelect(property.CustomerId);
            command.AddSelect(property.OrderDate);
            command.AddSelect(property.PaymentMethod);
            command.AddSelect(property.DeliveryPlace);
            

            //XV`
            if(condition != null)   command.AddWhere(condition);
            //
            if (order != null) command.OrderBy.AddRange(order);

            return command;
        }
        /// <summary>
        /// ordersselect list
        /// </summary>
        /// <param name="tableAlias">e[uɕtʖ</param>
        /// <param name="columnAliasPrefix">ɕtʖ̐ړ</param>
        public string  GetSelectListString(string tableAlias , string columnAliasPrefix)
        {
        	StringBuilder builder = new StringBuilder();

            //XV`
            builder.AppendLine(", "+ tableAlias + ".id AS " + columnAliasPrefix + "id" );
            builder.AppendLine(", "+ tableAlias + ".customer_id AS " + columnAliasPrefix + "customer_id" );
            builder.AppendLine(", "+ tableAlias + ".order_date AS " + columnAliasPrefix + "order_date" );
            builder.AppendLine(", "+ tableAlias + ".payment_method AS " + columnAliasPrefix + "payment_method" );
            builder.AppendLine(", "+ tableAlias + ".delivery_place AS " + columnAliasPrefix + "delivery_place" );
            

            return builder.ToString().Substring(1);
        }
    }
}
