using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace SQLiteSample
{
    public class TextBoxTraceListener : System.Diagnostics.TraceListener
    {
        TextBox targetTextBox;

        public TextBoxTraceListener(TextBox textBox)
        {
            this.targetTextBox = textBox;
        }

        public override void Write(string message)
        {
            targetTextBox.AppendText(message);
        }

        public override void WriteLine(string message)
        {
           targetTextBox.AppendText(message);
           targetTextBox.AppendText(Environment.NewLine);
        }
    }
}
