using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Windows.Forms.Adapters;
using CFW.Windows.Forms;
using CFW.Util;
using TaskManager.Models;

namespace TaskManager.Forms.Adapters
{
    public class TaskSearchConditionFormAdapter : CFW.Forms.FormAdapter
    {
        public TaskSearchCondition theEntity;
        public FormAdapterElement periodFrom;
        public FormAdapterElement periodTo;
        public FormAdapterElement categories;
        public FormAdapterElement statuses;
        public FormAdapterElement priorities;

        public TaskSearchConditionFormAdapter()
        {
            theEntity = null;
            periodFrom = new NullAdapterElement();
            periodTo = new NullAdapterElement();
            categories = new NullAdapterElement();
            statuses = new NullAdapterElement();
            priorities = new NullAdapterElement();
        }
        public override bool Validate()
        {
            ResetValidation();
            bool valid = true;
            
            if (this.periodFrom != null)
            {
                if (!this.periodFrom.Validate())
                {
                    valid = false;
                    this.messages.Add(this.periodFrom.ErrorMessage);
                }
            }

            if (this.periodTo != null)
            {
                if (!this.periodTo.Validate())
                {
                    valid = false;
                    this.messages.Add(this.periodTo.ErrorMessage);
                }
            }
            if (this.categories != null)
            {
                if (!this.categories.Validate())
                {
                    valid = false;
                    this.messages.Add(this.categories.ErrorMessage);
                }
            }
            if (this.statuses != null)
            {
                if (!this.statuses.Validate())
                {
                    valid = false;
                    this.messages.Add(this.statuses.ErrorMessage);
                }
            }
            if (this.priorities != null)
            {
                if (!this.priorities.Validate())
                {
                    valid = false;
                    this.messages.Add(this.priorities.ErrorMessage);
                }
            }




            
            return valid;
        }

        public override void UpdateFields()
        {
            if (this.periodFrom != null) this.periodFrom.UpdateField();
            if (this.periodTo != null) this.periodTo.UpdateField();
            if (this.categories != null) this.categories.UpdateField();
            if (this.statuses != null) this.statuses.UpdateField();
            if (this.priorities != null) this.priorities.UpdateField();

        }

        public override void SetEntity(CFW.Models.Entity entity)
        {
            theEntity = entity as TaskSearchCondition;

            if (this.periodFrom != null) this.periodFrom.SetValue(theEntity.periodFrom);
            if (this.periodTo != null) this.periodTo.SetValue(theEntity.periodTo);
            if (this.categories != null) this.categories.SetValue(theEntity.categories);
            if (this.statuses != null) this.statuses.SetValue(theEntity.statuses);
            if (this.priorities != null) this.priorities.SetValue(theEntity.priorities);

        }

        public override CFW.Models.Entity GetEntity()
        {
            return theEntity;
        }

        public override void UpdateEntity()
        {
            if (this.periodFrom != null) theEntity.periodFrom = DateUtil.DateValue( this.periodFrom.GetValue() );
            if (this.periodTo != null) theEntity.periodTo = DateUtil.DateValue( this.periodTo.GetValue() );
            if (this.categories != null) theEntity.categories = CFW.Util.Util.toList<int>( this.categories.GetValue());
            if (this.statuses != null) theEntity.statuses = CFW.Util.Util.toList<short>(this.statuses.GetValue());
            if (this.priorities != null) theEntity.priorities = CFW.Util.Util.toList<byte>(this.priorities.GetValue()); 
        }

        public override void RenderView()
        {
            if (this.periodFrom != null) this.periodFrom.Render();
            if (this.periodTo != null) this.periodTo.Render();
            if (this.categories != null) this.categories.Render();
            if (this.statuses != null) this.statuses.Render();
            if (this.priorities != null) this.priorities.Render();
        }
    }
}
