using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Models;

using TaskManager.Models;

namespace TaskManager
{
    public partial class KeyValueListTestForm : Form
    {
        Enumerations list;

        public KeyValueListTestForm()
        {
            InitializeComponent();
        }

        private void KeyValueListTestForm_Load(object sender, EventArgs e)
        {
            loadList();
            render();
        }
        private void loadList()
        {
            CategoriesModel model = new CategoriesModel();
            list = model.getEnumerations();
        }
        private void render()
        {
            listBox1.DisplayMember = "Name";
            listBox1.ValueMember = "Id";
            listBox1.DataSource = list;
            listBox1.Refresh();
            dataGridView1.DataSource = list;
            dataGridView1.Refresh();

            comboBox1.DisplayMember = "Name";
            comboBox1.ValueMember = "Id";
            comboBox1.DataSource = list;
            comboBox1.Refresh();

            checkBoxList1.DataSource = list;
            checkBoxList1.Refresh();

            radioButtonList1.DataSource = list;
            radioButtonList1.Refresh();
        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            object selectedValue = listBox1.SelectedValue;

            label1.Text = selectedValue.ToString();
            label2.Text = list.findIndexById(selectedValue).ToString();

        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            label1.Text = comboBox1.SelectedValue.ToString();
            label2.Text = list.findIndexById(comboBox1.SelectedValue).ToString();

        }

        private void button1_Click(object sender, EventArgs e)
        {
            checkBoxList1.setValues(new int[] { 1, 4, 10 });
        }

        private void button2_Click(object sender, EventArgs e)
        {
            label1.Text = "";
            IEnumerable values = checkBoxList1.getValues();
            foreach (object value in values)
            {
                label1.Text += value.ToString() + " ";
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            radioButtonList1.setValue(5);

        }

        private void button4_Click(object sender, EventArgs e)
        {

            label1.Text = "";
            object value = radioButtonList1.getValue();
            label1.Text += value.ToString() + " ";
        }

    }
}