using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace TaskManager.Models.Base
{
    /// <summary>
    /// table auth_users_roles Field`
    /// </summary>
    [Serializable()]
    public class AuthUsersRolesTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[id]</summary>
        protected Int32 _id;
        ///<summary>[id]</summary>
        public Int32 id{
            get{return _id;}
            set{_id = value;}
        }
        ///<summary>[login_id]</summary>
        protected string _loginId;
        ///<summary>[login_id]</summary>
        public string loginId{
            get{return _loginId;}
            set{_loginId = value;}
        }
        ///<summary>[acl_roles_id]</summary>
        protected Int32 _aclRolesId;
        ///<summary>[acl_roles_id]</summary>
        public Int32 aclRolesId{
            get{return _aclRolesId;}
            set{_aclRolesId = value;}
        }
        ///<summary>[description]</summary>
        protected string _description;
        ///<summary>[description]</summary>
        public string description{
            get{return _description;}
            set{_description = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public AuthUsersRolesTableRow() : base()
        {
            this._id = 0;
            this._loginId = "";
            this._aclRolesId = 0;
            this._description = "";
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "id"){ this._id = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "login_id"){ this._loginId = StringUtil.StringValue( value );return; }
            if(name ==  "acl_roles_id"){ this._aclRolesId = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "description"){ this._description = StringUtil.StringValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "id") return this._id;
            if(name ==  "login_id") return this._loginId;
            if(name ==  "acl_roles_id") return this._aclRolesId;
            if(name ==  "description") return this._description;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            AuthUsersRolesTableRow clone = new AuthUsersRolesTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(AuthUsersRolesTableRow source)
        {
            this.id = source.id;
            this.loginId = source.loginId;
            this.aclRolesId = source.aclRolesId;
            this.description = source.description;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("id")){ this._id = NumberUtil.Value<Int32>(row["id"]); }
            if (cols.Contains("login_id")){ this._loginId = StringUtil.StringValue(row["login_id"]); }
            if (cols.Contains("acl_roles_id")){ this._aclRolesId = NumberUtil.Value<Int32>(row["acl_roles_id"]); }
            if (cols.Contains("description")){ this._description = StringUtil.StringValue(row["description"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "id");if (cols.Contains(columnName)){ this._id = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "login_id");if (cols.Contains(columnName)){ this._loginId = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "acl_roles_id");if (cols.Contains(columnName)){ this._aclRolesId = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "description");if (cols.Contains(columnName)){ this._description = StringUtil.StringValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._id = NumberUtil.Value<Int32>(reader[0]);
            this._loginId = StringUtil.StringValue(reader[1]);
            this._aclRolesId = NumberUtil.Value<Int32>(reader[2]);
            this._description = StringUtil.StringValue(reader[3]);
            
            this.IsNew = false;
        }
    }

}