﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using CFW.ErrorHandler;
using CFW.Windows.ErrorHandler;

namespace TaskManager
{
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            ApplicationErrorHandler.SetUp(new DefaultApplicationErrorHandler("Task Manager"));

            using (Forms.LoginForm login = new TaskManager.Forms.LoginForm())
            {
                if (login.ShowDialog() == DialogResult.OK)
                {
                    Application.Run(new TaskMain());
                }
            }
        }
    }
}