using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.Common;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml.Serialization;
using CFW.Database;
using CFW.Database.CommandBuilder;
using CFW.Database.Expressions;
using CFW;
using CFW.Log;
using CFW.Serializer;
using Nii.JSON;

namespace WebSvc
{
    public partial class Form1 : Form
    {
        Logger logger = LoggerFactory.GetLogger("default", "test");
        DataSet foundResult;
        string key;
        System.Net.CookieContainer container;
        DbWebService.DbWebService service;
        public Form1()
        {
            InitializeComponent();
        }
        /// <summary>
        /// R}hwebT[rXpɃRs[
        /// </summary>
        /// <param name="command">̃R}h</param>
        /// <returns>webT[rXp</returns>
        string CopyCommandArray(Command command)
        {
            System.Xml.Serialization.XmlSerializer ser = new System.Xml.Serialization.XmlSerializer(command.GetType());
            System.IO.StringWriter writer = new System.IO.StringWriter();
            ser.Serialize(writer, command);
            writer.Close();
            return writer.ToString();
        }
        void openService()
        {
            service = new DbWebService.DbWebService();
            container = new System.Net.CookieContainer();
            service.CookieContainer = container;
            key = service.Open((int)IsolationLevel.ReadUncommitted, false);
        }
        void closeService()
        {
            service.Close(false);
        }
        private void button1_Click(object sender, EventArgs e)
        {
            logger.Debug("test1", "start");
            openService();
            string commandString = CopyCommandArray(createCommand());
            foundResult = service.ExecuteQuery(key, commandString, 20);

            closeService();

            logger.Debug("test1", "end");
            updateView();
        }
        Command createCommand()
        {
            Command command1 = new Command("select top 1000 * from mast_site");
            Command command2 = new Command("select top 1000 * from mast_menu");
            Command command3 = new Command("select top 1000 * from mast_manuscript");

            return command2;
        }
        void updateView()
        {
            flowLayoutPanel1.Controls.Clear();
            if (foundResult == null)
            {
                Label ll = new Label();
                ll.Text = "result is null";
                flowLayoutPanel1.Controls.Add(ll);
                return;
            }
            foreach (DataTable table in foundResult.Tables)
            {
                DataGridView grid = new DataGridView();
                grid.AutoGenerateColumns = true;
                grid.DataSource = table;
                grid.Width = flowLayoutPanel1.ClientSize.Width - 20;
                grid.Height = 200;
                flowLayoutPanel1.Controls.Add(grid);
            }
        }
        void updateView2()
        {
            flowLayoutPanel1.Controls.Clear();
            if (foundResult == null)
            {
                Label ll = new Label();
                ll.Text = "result is null";
                flowLayoutPanel1.Controls.Add(ll);
                return;
            }
            foreach (DataTable table in foundResult.Tables)
            {
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            logger.Debug("test2", "start");
            openService();
            string commandString = CopyCommandArray(createCommand());
            string result = service.ExecuteQueryAsSerialized(key, commandString, 20);

            XmlSerializer ser = new XmlSerializer(typeof(DataSet));
            foundResult = (DataSet) ser.Deserialize(new StringReader(result));

            closeService();

            logger.Debug("test2", "end");
            updateView();

        }

        private void button3_Click(object sender, EventArgs e)
        {
            logger.Debug("test3", "start");
            openService();
            string commandString = CopyCommandArray(createCommand());
            string result = service.ExecuteQueryAsSerialized3(key, commandString, 20);

            DataSXSerializer ser = new DataSXSerializer();
            foundResult = (DataSet)ser.DeserializeDataSet(new StringReader(result));

            closeService();

            logger.Debug("test3", "end");
            updateView();

        }

        private void button4_Click(object sender, EventArgs e)
        {
            logger.Debug("test4", "start");
            Connection con = ConnectionFactory.GetConnectionByName("default");
            con.Open();
            foundResult = con.ExecuteQuery(createCommand());

            con.Close();

            logger.Debug("test4", "end");
            updateView();

        }

        private void button5_Click(object sender, EventArgs e)
        {
            logger.Debug("test5", "start");
            Connection con = ConnectionFactory.GetConnectionByName("default");
            con.Open();
            foundResult = con.ExecuteQuery(new Command("select * from mast_menu order by site_code,menu_code"));

            con.Close();



            con = ConnectionFactory.GetConnectionByName("sqlite");
            con.Open();
            Command command = new Command();
            string q = @"CREATE TABLE if not exists  [MAST_MENU](
	[SITE_CODE]  NOT NULL,
	[MENU_CODE]  NOT NULL,
	[SORT_SEQ]  NULL,
	[OPEN_DATE]  NOT NULL,
	[CLOSE_DATE]  NULL,
	[MENU_GROUP_CODE]  NULL,
	[NAME]  NOT NULL,
	[ANK_NAME]  NOT NULL,
	[DEVICE_CODE]  NOT NULL,
	[MENU_DEVICE_CODE]  NULL,
	[MENU_ADTYPE_CODE]  NULL,
	[OPTIN_TYPE]  NULL,
	[MANAGEMENT_CODE]  NOT NULL,
	[GUARANTEE_CODE]  NOT NULL,
	[MENU_CATEGORY1]  NULL,
	[MENU_CATEGORY2]  NULL,
	[LIST_CODE]  NULL,
	[FLAME_COUNT]  NULL,
	[FLAME_COUNT_KIND]  NOT NULL,
	[ROTATION_FLAME_COUNT]  NULL,
	[FLAME_SELECT_FLAG]  NULL,
	[GOODS_CATEGORY_CODE]  NULL,
	[PAYMENT_COMPANY]  NULL,
	[SP_OPEN_FLAG]  NULL,
	[PM_OPEN_FLAG]  NULL,
	[AD_GUIDE_OPEN_FLAG]  NULL,
	[REGULATION_GUIDE_FLAG]  NULL,
	[IO_OPEN_FLAG]  NULL,
	[ES_AUDIENCE_FLAG]  NULL,
	[ES_PERFORMANCE_FLAG]  NULL,
	[ES_REACH_FLAG]  NULL,
	[SEARCH_URL_FLAG]  NULL,
	[PACKAGE_FLAG]  NULL,
	[MENU_SELECTION_COUNT]  NULL,
	[CARRIER_CODE1]  NULL,
	[CARRIER_CODE2]  NULL,
	[CARRIER_CODE3]  NULL,
	[CARRIER_CODE4]  NULL,
	[PAGE_REMARKS]  NULL,
	[REMARKS]  NULL,
	[DAC_REMARKS]  NULL,
	[B_STATUS]  NULL,
	[D_STATUS]  NULL,
	[P_STATUS]  NULL,
	[P_CAMPAIGN_STATUS_FROM]  NULL,
	[P_CAMPAIGN_STATUS_TO]  NULL,
	[M_STATUS]  NULL,
	[T_STATUS]  NULL,
	[TOTAL_STATUS]  NULL,
	[TOTAL_STATUS_TO]  NULL,
	[COUNT_URL_KIND]  NULL,
	[COUNT_URL]  NULL,
	[REPORT_KIND]  NOT NULL,
	[REPORT_DETAIL]  NULL,
	[REPORT_RECEIVE]  NULL,
	[SEGMENT_EQUAL_FLAG]  NULL,
	[STOCK_FLAG]  NULL,
	[STOCK_COUNT]  NULL,
	[CAPTURE_SEQ]  NULL,
	[AG_COMPANY_CODE]  NULL,
	[INSIDE_OPEN_LEVEL]  NULL,
	[OUTSIDE_OPEN_LEVEL]  NULL,
	[LIMIT_OPEN_REMARKS]  NULL,
	[PUBLISH_PAGE_FLAG]  NULL,
	[ES_REMARKS]  NULL,
	[MENU_FRAME_CODE]  NULL,
	[FRAME_NAME_REFRECT_FLAG]  NULL,
	[DELIVERY_OPTION_NAME]  NULL,
	[GET_REPORT_DESTINATION]  NULL,
	[REPORT_TREAT_KIND_SEQ]  NULL,
	[USE_SITE_LIMIT_OPEN_FLAG]  NULL,
	[USE_SITE_CARRIER_FLAG]  NULL,
	[COST_MENU_FLAG]  NULL,
	[CHECK_NAME]  NULL,
	[PRICE_GROUP_FROM_DATE]  NULL,
	[MANUSCRIPT_FROM_DATE]  NULL,
	[PRICE_COST_FROM_DATE]  NULL,
	[TRANSMIT_FROM_DATE]  NULL,
	[REFER_SITE_PRICE_COST_FLAG]  NULL,
	[TEAM_CODE]  NULL,
	[VALID_FLAG]  NULL,
	[BASE_UPDATE_DATE_TIME] NULL,
	[INSERT_DATE_TIME]  NULL,
	[INSERT_OPERATOR_CODE]  NULL,
	[UPDATE_DATE_TIME]  NULL,
	[OPERATOR_CODE]  NULL,
 CONSTRAINT [PK_MAST_MENU] PRIMARY KEY
(
	[SITE_CODE] ASC,
	[MENU_CODE] ASC
)
)
";
            command.Text = q;
            con.ExecuteUpdate(command);

            command.Text = "delete from MAST_MENU";
            con.ExecuteUpdate(command);

            string insq = "INSERT INTO MAST_MENU VALUES(";
            int c = 0;
            foreach (DataColumn col in foundResult.Tables[0].Columns)
            {
                if (c > 0) insq += ",";
                insq += "@" + col.ColumnName;
                c++;

            }
            insq += ")";

            command.Text = insq;

            con.BeginTransaction();
            foreach (DataRow row in foundResult.Tables[0].Rows)
            {
                foreach (DataColumn col in foundResult.Tables[0].Columns)
                {
                    command.SetParameter(new Parameter("@" + col.ColumnName,row[col]));

                }
                con.ExecuteUpdate(command);
            }
            con.CommitTransaction();

            con.Close();

            logger.Debug("test5", "end");

        }

        private void button6_Click(object sender, EventArgs e)
        {
            logger.Debug("test6", "start");
            Connection con = ConnectionFactory.GetConnectionByName("sqlite");
            con.Open();
            Command command = new Command( "select * from MAST_MENU LIMIT 100" );
            foundResult = con.ExecuteQuery(command);

            con.Close();

            logger.Debug("test6", "end");
            updateView();

        }

        private void button7_Click(object sender, EventArgs e)
        {
            logger.Debug("test7", "start");
            Connection con = ConnectionFactory.GetConnectionByName("default");
            con.Open();
            foundResult = con.ExecuteQuery(createCommand());


            con.Close();
            XmlSerializer serializer = new XmlSerializer(foundResult.GetType());
            StringWriter writer = new StringWriter();
            serializer.Serialize(writer, foundResult);

            logger.Debug("test7", writer.ToString());

        }

        private void button8_Click(object sender, EventArgs e)
        {
            logger.Debug("test8", "start");
            Connection con = ConnectionFactory.GetConnectionByName("default");
            con.Open();
            StringWriter writer = new StringWriter();
            writer.Write("<dataset>\r\n");
            writer.Write("<tables>\r\n");
            DbDataReader reader = con.ExecuteReader(createCommand(), 20);


            do
            {
                writer.Write("<table>\r\n");
                int numColumns = reader.FieldCount;
                int i = 0;
                while (reader.Read())
                {
                    if (i == 0)
                    {
                        writer.Write("<columns>\r\n");
                        for (int c = 0; c < numColumns; c++)
                        {
                            writer.Write(string.Format("<column name=\"{0}\" type=\"{1}\" />\r\n", reader.GetName(c), reader.GetFieldType(c).ToString()));
                        }
                        writer.Write("</columns>\r\n");

                        writer.Write("<rows>\r\n");
                    }
                    writer.Write("<row>");
                    for (int c = 0; c < numColumns; c++)
                    {
                        writer.Write(string.Format("<{0} value=\"{1}\" />", reader.GetName(c), reader.GetValue(c).ToString().Replace('\x0b', ' ').Replace("&", "&amp;").Replace("\"", "&quot;").Replace("<", "&lt;")));
                    }
                    writer.Write("</row>");


                    i++;
                }

                writer.Write("</rows>\r\n");
                writer.Write("</table>\r\n");


            } while (reader.NextResult());
            reader.Close();
            writer.Write("</tables>\r\n");
            writer.Write("</dataset>\r\n");

            
            con.Close();

            logger.Debug("test8", "end");
        }

        private void button9_Click(object sender, EventArgs e)
        {
            logger.Debug("test9", "start");
            Connection con = ConnectionFactory.GetConnectionByName("default");
            con.Open();
            foundResult = con.ExecuteQuery(createCommand(), 20);

            DataSetJSON serializer = new DataSetJSON();
            StringWriter writer = new StringWriter();
            serializer.SerializeDataSet(writer, foundResult);
            con.Close();

            logger.Debug("test8", "end");

        }

        private void button10_Click(object sender, EventArgs e)
        {
            logger.Debug("test10", "start");
            openService();
            string commandString = CopyCommandArray(createCommand());
            string result = service.ExecuteQueryAsSerialized4(key, commandString, 20);

            DataSetJSON d = new DataSetJSON();
            foundResult = (DataSet)d.DeserializeDataSet(new StringReader(result));

            closeService();

            logger.Debug("test10", "end");
            updateView();

        }

        private void button11_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            string s = textBox1.Text.Substring(0, 5);
            string m = textBox1.Text.Substring(5, 4);

            string q = "SITE_CODE = '{0}' AND MENU_CODE = '{1}'";
            DataRow[] rows =  foundResult.Tables[0].Select(string.Format(q, s, m));

            sw.Stop();
            label1.Text = string.Format("elapsed : {0:#,##0.000}ms", (double)sw.ElapsedTicks / (double)System.Diagnostics.Stopwatch.Frequency);

        }

        private void button12_Click(object sender, EventArgs e)
        {
            logger.Debug("test7", "start");
            Connection con = ConnectionFactory.GetConnectionByName("default");
            con.Open();
            SelectCommandBuilder builder = new SelectCommandBuilder(con);
            ExpressionFactory expr = con.getExpressionFactory();
            builder.from("MAST_MENU", "MENU")
            .option("TOP 1000")
            .select("*");
            
            foundResult = con.ExecuteQuery(builder.getCommand());


            con.Close();
            Newtonsoft.Json.JavaScriptObject jso = new Newtonsoft.Json.JavaScriptObject();
            Newtonsoft.Json.JavaScriptArray tablesArray = new Newtonsoft.Json.JavaScriptArray();
            foreach (DataTable table in foundResult.Tables)
            {
                Newtonsoft.Json.JavaScriptObject tableObject = new Newtonsoft.Json.JavaScriptObject();
                tableObject["name"] = table.TableName;

                Newtonsoft.Json.JavaScriptArray columnsArray = new Newtonsoft.Json.JavaScriptArray();
                foreach (DataColumn column in table.Columns)
                {
                    Newtonsoft.Json.JavaScriptObject columnObject = new Newtonsoft.Json.JavaScriptObject();
                    columnObject["name"] = column.ColumnName;
                    columnObject["type"] = column.DataType.Name;
                    columnsArray.Add(columnObject);
                }
                tableObject["columns"] = columnsArray;

                Newtonsoft.Json.JavaScriptArray rowsArray = new Newtonsoft.Json.JavaScriptArray();
                foreach (DataRow row in table.Rows)
                {
                    Newtonsoft.Json.JavaScriptObject rowObject = new Newtonsoft.Json.JavaScriptObject();

                    foreach (DataColumn column in table.Columns)
                    {
                        rowObject[column.ColumnName] = row[column.ColumnName];
                    }
                    rowsArray.Add(rowObject);
                }
                tableObject["rows"] = rowsArray;
                tablesArray.Add(tableObject);
                
            }
            jso["tables"] = tablesArray;
            StringWriter writer = new StringWriter();
            Newtonsoft.Json.JsonSerializer serializer = new Newtonsoft.Json.JsonSerializer();
            serializer.Serialize(writer, jso);

            logger.Debug("test7", writer.ToString());

        }

        private void button13_Click(object sender, EventArgs e)
        {
            SerializeCheckForm form = new SerializeCheckForm();
            form.Show();
        }

        private void button14_Click(object sender, EventArgs e)
        {
            JSONObject jso = new JSONObject(textBox1.Text);
            logger.Debug("test7", jso.ToString());

        }
    }
}