using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test.Acl
{

    [TestFixture]
    public class AccessControl
    {
        CFW.Acl.AccessControl acl;

        [NUnit.Framework.SetUp]
        public void Startup()
        {
            acl = new CFW.Acl.AccessControl();
            acl.AddRole("anonymous", null);
            acl.AddRole("admin", null);
            acl.AddRole("member", null);

            acl.AddRole("common", "member");
            acl.AddRole("first developement div", "member");
            acl.AddRole("logistics", "first developement div");
            acl.AddRole("logistics1", "logistics");
            acl.AddRole("logistics2", "logistics");
            acl.AddRole("education", "first developement div");
            acl.AddRole("junior high school", "education");
            acl.AddRole("senior high school", "education");
            acl.AddRole("finance", "first developement div");
            acl.AddRole("second developement div", "member");
            acl.AddRole("travel", "second developement div");
            acl.AddRole("travel1", "travel");
            acl.AddRole("travel2", "travel");
            acl.AddRole("travel3", "travel");

            acl.AddResource("VXe", null);
            acl.AddResource("DAC", "VXe");
            acl.AddResource("u", "VXe");
            acl.AddResource("͂", "VXe");

            acl.AddResource("s", null);
            acl.AddResource("SKYLINK", "s");
            acl.AddResource("ATAKS", "s");
            acl.AddResource("FJ-T", "s");

            /*
             * travel1FJ-T,SKYLINK̑S邪AATAKSReadłȂB
             * travel2͗sƂ̑SĂg
             * `[͗sƂRead,Updateo
             * */
            acl.AddRule("FJ-T", "travel1",CFW.Acl.AclPrivilege.All);
            acl.AddRule("ATAKS", "travel2", CFW.Acl.AclPrivilege.All);
            acl.AddRule("ATAKS", "travel1", CFW.Acl.AclPrivilege.Read);
            acl.AddRule("SKYLINK", "travel3", CFW.Acl.AclPrivilege.All);
            acl.AddRule("s", "travel", CFW.Acl.AclPrivilege.All);
            acl.AddRule("s", "education", CFW.Acl.AclPrivilege.Read | CFW.Acl.AclPrivilege.Update);

            /*
             * logostics1DAC̑SĂgB
             * financeDAC̓ǂݎȊOVXȇSĂgȂB
             * */
            acl.AddRule("DAC", "logistics1", CFW.Acl.AclPrivilege.All);
            acl.AddRule("DAC", "finance", CFW.Acl.AclPrivilege.Read);

            acl.DumpResources();
            acl.DumpRoles();
        }
        [NUnit.Framework.Test]
        public void IsAllowed()
        {
            bool result = false;

            string resource = "FJ-T";
            CFW.Acl.IAclRole role1 = acl.FindRoleByName("travel1");
            CFW.Acl.IAclRole role2 = acl.FindRoleByName("travel2");
            CFW.Acl.IAclRole role3 = acl.FindRoleByName("logistics1");
            CFW.Acl.IAclRole role4 = acl.FindRoleByName("finance");

            List<CFW.Acl.IAclRole> roles = new List<CFW.Acl.IAclRole>();
            /*
             * travel1G
             * FJ-T ALL
             * ATAKS READ
             * SKYLINK
             * */

            //FJ-Tɑ΂Atravel1͑S
            roles.Clear();
            roles.Add(role1);
            result = acl.IsAllowed(resource, CFW.Acl.AclPrivilege.All, roles);
            Assert.IsTrue(result);

            //FJ-Tɑ΂Atravel2͑S
            roles.Clear();
            roles.Add(role2);
            result = acl.IsAllowed(resource, CFW.Acl.AclPrivilege.All, roles);
            Assert.IsTrue(result);


            //FJ-Tɑ΂Alogistics1͉łȂ
            roles.Clear();
            roles.Add(role3);
            result = acl.IsAllowed(resource, CFW.Acl.AclPrivilege.All, roles);
            Assert.IsFalse(result);

            result = acl.IsAllowed(resource, CFW.Acl.AclPrivilege.Read, roles);
            Assert.IsFalse(result);
            result = acl.IsAllowed(resource, CFW.Acl.AclPrivilege.Create, roles);
            Assert.IsFalse(result);
            result = acl.IsAllowed(resource, CFW.Acl.AclPrivilege.Update, roles);
            Assert.IsFalse(result);
            result = acl.IsAllowed(resource, CFW.Acl.AclPrivilege.Delete, roles);
            Assert.IsFalse(result);

            resource = "ATAKS";
            //ATAKSɑ΂Atravel1͓ǂݎ肾ł
            roles.Clear();
            roles.Add(role1);
            result = acl.IsAllowed(resource, CFW.Acl.AclPrivilege.All, roles);
            Assert.IsFalse(result);
            result = acl.IsAllowed(resource, CFW.Acl.AclPrivilege.Read, roles);
            Assert.IsTrue(result);

            //ATAKSɑ΂Atravel2͂Ȃłł
            roles.Clear();
            roles.Add(role2);
            result = acl.IsAllowed(resource, CFW.Acl.AclPrivilege.All, roles);
            Assert.IsTrue(result);

        }
    }
}
