using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test.Auth
{
    [NUnit.Framework.TestFixture]
    public class PasswordHashTest
    {
        [NUnit.Framework.Test]
        public void TestCreateHashMD5()
        {
            CFW.Auth.AbstractPasswordHash hash = CFW.Auth.AbstractPasswordHash.GetInstance("MD5","BASE64",0);
            string newHash = hash.CreateHash("test");
            Assert.AreEqual("CY9rzUYh03PK3k6DJie09g==", newHash);


            string newHash2 = hash.CreateHash("hatsunemiku");
            Assert.AreEqual("NSP+X5aWZCChlQ5RTcx0Ew==", newHash2);

        }
        [NUnit.Framework.Test]
        public void TestValidateHashMD5()
        {
            CFW.Auth.AbstractPasswordHash hash = CFW.Auth.AbstractPasswordHash.GetInstance("MD5", "BASE64", 0);
            bool result = hash.ValidateHash("test", "CY9rzUYh03PK3k6DJie09g==");
            Assert.IsTrue(result);
            
            result = hash.ValidateHash("test1", "CY9rzUYh03PK3k6DJie09g==");
            Assert.IsFalse(result);

            result = hash.ValidateHash("hatsunemiku", "NSP+X5aWZCChlQ5RTcx0Ew==");
            Assert.IsTrue(result);


        }
        [NUnit.Framework.Test]
        public void TestCreateHashSHA()
        {
            CFW.Auth.AbstractPasswordHash hash = CFW.Auth.AbstractPasswordHash.GetInstance("SHA", "BASE64", 0);


            string newHash2 = hash.CreateHash("hatsunemiku");
            Assert.AreEqual("7LEpa2zWy5GH1WElHy+Siy6i3OY=", newHash2);

        }
        [NUnit.Framework.Test]
        public void TestValidateHashSHA()
        {
            CFW.Auth.AbstractPasswordHash hash = CFW.Auth.AbstractPasswordHash.GetInstance("SHA", "BASE64", 0);

            bool result = hash.ValidateHash("hatsunemiku", "7LEpa2zWy5GH1WElHy+Siy6i3OY=");
            Assert.IsTrue(result);


        }
        [NUnit.Framework.Test]
        public void TestCreateHashSMD5()
        {
            CFW.Auth.AbstractPasswordHash hash = CFW.Auth.AbstractPasswordHash.GetInstance("SMD5", "BASE64", 8);
            string newHash = hash.CreateHash("hatsunemiku");

            bool valid = hash.ValidateHash("hatsunemiku",newHash);
            Assert.IsTrue(valid);

            valid = hash.ValidateHash("hatsunemikumiku", newHash);
            Assert.IsFalse(valid);
        }
        [NUnit.Framework.Test]
        public void TestCreateHashSSHA()
        {
            CFW.Auth.AbstractPasswordHash hash = CFW.Auth.AbstractPasswordHash.GetInstance("SSHA", "BASE64", 8);
            string newHash = hash.CreateHash("hatsunemiku");

            bool valid = hash.ValidateHash("hatsunemiku", newHash);
            Assert.IsTrue(valid);

            valid = hash.ValidateHash("hatsunemikumiku", newHash);
            Assert.IsFalse(valid);
        }
        [NUnit.Framework.Test]
        public void TestCreateHashSalted()
        {
            CFW.Auth.AbstractPasswordHash hash = CFW.Auth.AbstractPasswordHash.GetInstance("SSHA", "BASE64", 8);
            string sshaHash = hash.CreateHash("hatsunemiku");

            CFW.Auth.AbstractPasswordHash sha = CFW.Auth.AbstractPasswordHash.GetInstance("SHA", "BASE64", 8);
            string shaHash = sha.CreateHash("hatsunemiku");

            Assert.AreNotEqual(sshaHash, shaHash);

            CFW.Auth.AbstractPasswordHash smd5 = CFW.Auth.AbstractPasswordHash.GetInstance("SMD5", "BASE64", 8);
            string smd5Hash = smd5.CreateHash("hatsunemiku");

            Assert.AreNotEqual(sshaHash, smd5Hash);

            CFW.Auth.AbstractPasswordHash md5 = CFW.Auth.AbstractPasswordHash.GetInstance("MD5", "BASE64", 8);
            string md5Hash = md5.CreateHash("hatsunemiku");

            Assert.AreNotEqual(smd5Hash,md5Hash);
        }
    }
}
