using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test
{
    [TestFixture]
    public class CsvTokenizerTest
    {
        [NUnit.Framework.Test]
        public void TestTokenizer()
        {
            string text = "aaa,bbb,ccc,,ddd";
            List<string> tokens = new List<string>();
            CFW.Util.CsvTokenizer tokenizer = new CFW.Util.CsvTokenizer(text, ',');
            while (tokenizer.HasMoreTokens())
            {
                tokens.Add(tokenizer.NextToken());
            }
            Assert.AreEqual(5, tokens.Count);
            Assert.AreEqual("aaa", tokens[0]);
            Assert.AreEqual("bbb", tokens[1]);
            Assert.AreEqual("ccc", tokens[2]);
            Assert.AreEqual("", tokens[3]);
            Assert.AreEqual("ddd", tokens[4]);
        }
        [NUnit.Framework.Test]
        public void TestTokenizer2()
        {
            string text = "aaa,bbb,ccc,,\"dd,ee,ff\"";
            List<string> tokens = new List<string>();
            CFW.Util.CsvTokenizer tokenizer = new CFW.Util.CsvTokenizer(text, ',');
            while (tokenizer.HasMoreTokens())
            {
                tokens.Add(tokenizer.NextToken());
            }
            Assert.AreEqual(5, tokens.Count);
            Assert.AreEqual("aaa", tokens[0]);
            Assert.AreEqual("bbb", tokens[1]);
            Assert.AreEqual("ccc", tokens[2]);
            Assert.AreEqual("", tokens[3]);
            Assert.AreEqual("dd,ee,ff", tokens[4]);
        }
        [NUnit.Framework.Test]
        public void TestTokenizer3()
        {
            string text = "aaa,bbb,ccc,,\"dd,ee,\\\"ff\"";
            List<string> tokens = new List<string>();
            CFW.Util.CsvTokenizer tokenizer = new CFW.Util.CsvTokenizer(text, ',');
            while (tokenizer.HasMoreTokens())
            {
                tokens.Add(tokenizer.NextToken());
            }
            Assert.AreEqual(5, tokens.Count);
            Assert.AreEqual("aaa", tokens[0]);
            Assert.AreEqual("bbb", tokens[1]);
            Assert.AreEqual("ccc", tokens[2]);
            Assert.AreEqual("", tokens[3]);
            Assert.AreEqual("dd,ee,\\\"ff", tokens[4]);
        }
    }
}
