using System;
using System.Collections.Generic;
using System.Text;
using CFW.FieldProperties;
using NUnit.Framework;

namespace CFW.Common.Test.FieldProperties
{
    [NUnit.Framework.TestFixture]
    public class DateTimeFieldPropertyTest
    {
        [NUnit.Framework.Test]
        public void createTest1()
        {
            FieldProperty p = FieldProperty.create("datetime");
            Assert.IsInstanceOfType(typeof(DateFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(DateTime), p.FieldType);
            Assert.AreEqual(16, p.Length);
            Assert.AreEqual(23, p.Precision);
            Assert.AreEqual(3, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(null, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest2()
        {
            FieldProperty p = FieldProperty.create("datetime", "testtable", "column1", "1");
            Assert.IsInstanceOfType(typeof(DateFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("testtable", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(DateTime), p.FieldType);
            Assert.AreEqual(16, p.Length);
            Assert.AreEqual(23, p.Precision);
            Assert.AreEqual(3, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(null, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest3()
        {
            //lengthw肵ĂӖ͖B
            FieldProperty p = FieldProperty.create("datetime", 5);
            Assert.IsInstanceOfType(typeof(DateFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(DateTime), p.FieldType);
            Assert.AreEqual(16, p.Length);
            Assert.AreEqual(23, p.Precision);
            Assert.AreEqual(3, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(null, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest4()
        {
            FieldProperty p = FieldProperty.create("datetime", 3, 2);
            Assert.IsInstanceOfType(typeof(DateFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(DateTime), p.FieldType);
            //d
            Assert.AreEqual(16, p.Length);
            Assert.AreEqual(23, p.Precision);
            Assert.AreEqual(3, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(null, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest5()
        {
            //full spec
            FieldProperty p = FieldProperty.create("datetime", "table1", "column1", "1", 100, 50, 0, false, null, true);
            Assert.IsInstanceOfType(typeof(DateFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("table1", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(DateTime), p.FieldType);
            Assert.AreEqual(16, p.Length);
            Assert.AreEqual(23, p.Precision);
            Assert.AreEqual(3, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsTrue(p.IsPrimaryKey);
            Assert.AreEqual(null, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType1()
        {
            FieldProperty p = FieldProperty.create(typeof(DateTime));
            Assert.IsInstanceOfType(typeof(DateFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(DateTime), p.FieldType);
            Assert.AreEqual(16, p.Length);
            Assert.AreEqual(23, p.Precision);
            Assert.AreEqual(3, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(null, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType2()
        {
            FieldProperty p = FieldProperty.create(typeof(DateTime), "testtable", "column1", "1");
            Assert.IsInstanceOfType(typeof(DateFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("testtable", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(DateTime), p.FieldType);
            Assert.AreEqual(16, p.Length);
            Assert.AreEqual(23, p.Precision);
            Assert.AreEqual(3, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(null, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType3()
        {
            //lengthw肵ĂӖ͖B
            FieldProperty p = FieldProperty.create(typeof(DateTime), 5);
            Assert.IsInstanceOfType(typeof(DateFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(DateTime), p.FieldType);
            Assert.AreEqual(16, p.Length);
            Assert.AreEqual(23, p.Precision);
            Assert.AreEqual(3, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(null, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType4()
        {
            //precision,scalew肵precision̂ݍ̗pB͍őlAŏlɊւ
            FieldProperty p = FieldProperty.create(typeof(DateTime), 4, 2);
            Assert.IsInstanceOfType(typeof(DateFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(DateTime), p.FieldType);
            Assert.AreEqual(16, p.Length);
            Assert.AreEqual(23, p.Precision);
            Assert.AreEqual(3, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(null, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType5()
        {
            //full spec
            FieldProperty p = FieldProperty.create(typeof(DateTime), "table1", "column1", "1", 100, 50, 0, false, null, true);
            Assert.IsInstanceOfType(typeof(DateFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("table1", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(DateTime), p.FieldType);
            Assert.AreEqual(16, p.Length);
            Assert.AreEqual(23, p.Precision);
            Assert.AreEqual(3, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsTrue(p.IsPrimaryKey);
            Assert.AreEqual(null, p.DefaultValue);

        }
    }
}
