using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test.Forms.Filters
{

    [TestFixture]
    public class DateTimeFilterTest 
    {
        [NUnit.Framework.Test]
        public void FilterString()
        {
            CFW.Forms.Filters.DateTimeFilter filter = new CFW.Forms.Filters.DateTimeFilter(DateTimeInputFormat.DATE_LONG);

            string source = "abcdefghijklmn";
            object result = filter.FilterValue(source);
            Assert.IsNull(result);

            source = "abcdef1965/2/1";
            result = filter.FilterValue(source);
            Assert.IsNotNull(result);
            Assert.AreEqual(DateTime.Parse("1965/2/1"), result);


        }
        [NUnit.Framework.Test]
        public void FilterString2()
        {
            CFW.Forms.Filters.DateTimeFilter filter = new CFW.Forms.Filters.DateTimeFilter(DateTimeInputFormat.DATE_LONG,true);

            string source = "abcdefghijklmn";
            object result = filter.FilterValue(source);
            Assert.IsNull(result);

            source = "abcdef";
            result = filter.FilterValue(source);
            Assert.IsNull(result);


        }
        [NUnit.Framework.Test]
        public void FilterString3()
        {
            CFW.Forms.Filters.DateTimeFilter filter = new CFW.Forms.Filters.DateTimeFilter(DateTimeInputFormat.DATE_LONG, true);

            string source = "1999/2/5";
            object result = filter.FilterValue(source);
            Assert.IsNotNull(result);
            Assert.AreEqual(DateTime.Parse("1999/2/5"),result);

            source = "1999/2/29";
            result = filter.FilterValue(source);
            Assert.IsNull(result);


        }

    }
}
