using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
namespace CFW.Common.Test
{

    [NUnit.Framework.TestFixture]
    public class StringTokenizerTest
    {
        [NUnit.Framework.Test]
        public void TestTokenizer()
        {
            string text = "a b c\t\t\t\t\td    e    f";
            List<string> tokens = new List<string>();
            CFW.Util.StringTokenizer tokenizer = new CFW.Util.StringTokenizer(text);
            while (tokenizer.HasMoreTokens())
            {
                tokens.Add(tokenizer.NextToken());
            }
            Assert.AreEqual(6, tokens.Count);
            Assert.AreEqual("a", tokens[0]);
            Assert.AreEqual("b", tokens[1]);
            Assert.AreEqual("c", tokens[2]);
            Assert.AreEqual("d", tokens[3]);
            Assert.AreEqual("e", tokens[4]);
            Assert.AreEqual("f", tokens[5]);
        }
        [NUnit.Framework.Test]
        public void TestTokenizer2()
        {
            string text = "a b c\t\t\t\t\td    e    f";
            List<string> tokens = new List<string>();
            CFW.Util.StringTokenizer tokenizer = new CFW.Util.StringTokenizer(text, new int[] {'\t' });
            while (tokenizer.HasMoreTokens())
            {
                tokens.Add(tokenizer.NextToken());
            }
            Assert.AreEqual(2, tokens.Count);
            Assert.AreEqual("a b c", tokens[0]);
            Assert.AreEqual("d    e    f", tokens[1]);
        }
        [NUnit.Framework.Test]
        public void TestTokenizer3()
        {
            string text = "aaa,bbb,ccc,,ddd";
            List<string> tokens = new List<string>();
            CFW.Util.StringTokenizer tokenizer = new CFW.Util.StringTokenizer(text, new int[] { ',' }, new int[] { });
            while (tokenizer.HasMoreTokens())
            {
                tokens.Add(tokenizer.NextToken());
            }
            Assert.AreEqual(5, tokens.Count);
            Assert.AreEqual("aaa", tokens[0]);
            Assert.AreEqual("bbb", tokens[1]);
            Assert.AreEqual("ccc", tokens[2]);
            Assert.AreEqual("", tokens[3]);
            Assert.AreEqual("ddd", tokens[4]);
        }
    }
}
