using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using CFW.Database.Test.AdventureWorks.Models.Base;

namespace CFW.Database.Test.AdventureWorks.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table SalesOrderHeader Field`
    /// </summary>
    public class SalesOrderHeaderTableFormAdapter : CFW.Forms.FormAdapter
	{
		private SalesOrderHeaderTableRow theEntity;

		///<summary>[SalesOrderID]</summary>
		public FormAdapterElement salesOrderID;
		///<summary>[RevisionNumber]</summary>
		public FormAdapterElement revisionNumber;
		///<summary>[OrderDate]</summary>
		public FormAdapterElement orderDate;
		///<summary>[DueDate]</summary>
		public FormAdapterElement dueDate;
		///<summary>[ShipDate]</summary>
		public FormAdapterElement shipDate;
		///<summary>[Status]</summary>
		public FormAdapterElement status;
		///<summary>[SalesOrderNumber]</summary>
		public FormAdapterElement salesOrderNumber;
		///<summary>[CustomerID]</summary>
		public FormAdapterElement customerID;
		///<summary>[ShipToAddressID]</summary>
		public FormAdapterElement shipToAddressID;
		///<summary>[BillToAddressID]</summary>
		public FormAdapterElement billToAddressID;
		///<summary>[ShipMethod]</summary>
		public FormAdapterElement shipMethod;
		///<summary>[CreditCardApprovalCode]</summary>
		public FormAdapterElement creditCardApprovalCode;
		///<summary>[SubTotal]</summary>
		public FormAdapterElement subTotal;
		///<summary>[TaxAmt]</summary>
		public FormAdapterElement taxAmt;
		///<summary>[Freight]</summary>
		public FormAdapterElement freight;
		///<summary>[TotalDue]</summary>
		public FormAdapterElement totalDue;
		///<summary>[Comment]</summary>
		public FormAdapterElement comment;
		///<summary>[ModifiedDate]</summary>
		public FormAdapterElement modifiedDate;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.salesOrderID != null) this.salesOrderID.Render();
			if(this.revisionNumber != null) this.revisionNumber.Render();
			if(this.orderDate != null) this.orderDate.Render();
			if(this.dueDate != null) this.dueDate.Render();
			if(this.shipDate != null) this.shipDate.Render();
			if(this.status != null) this.status.Render();
			if(this.salesOrderNumber != null) this.salesOrderNumber.Render();
			if(this.customerID != null) this.customerID.Render();
			if(this.shipToAddressID != null) this.shipToAddressID.Render();
			if(this.billToAddressID != null) this.billToAddressID.Render();
			if(this.shipMethod != null) this.shipMethod.Render();
			if(this.creditCardApprovalCode != null) this.creditCardApprovalCode.Render();
			if(this.subTotal != null) this.subTotal.Render();
			if(this.taxAmt != null) this.taxAmt.Render();
			if(this.freight != null) this.freight.Render();
			if(this.totalDue != null) this.totalDue.Render();
			if(this.comment != null) this.comment.Render();
			if(this.modifiedDate != null) this.modifiedDate.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (SalesOrderHeaderTableRow)entity;
			if(this.salesOrderID != null) this.salesOrderID.SetValue(this.theEntity.salesOrderID);
			if(this.revisionNumber != null) this.revisionNumber.SetValue(this.theEntity.revisionNumber);
			if(this.orderDate != null) this.orderDate.SetValue(this.theEntity.orderDate);
			if(this.dueDate != null) this.dueDate.SetValue(this.theEntity.dueDate);
			if(this.shipDate != null) this.shipDate.SetValue(this.theEntity.shipDate);
			if(this.status != null) this.status.SetValue(this.theEntity.status);
			if(this.salesOrderNumber != null) this.salesOrderNumber.SetValue(this.theEntity.salesOrderNumber);
			if(this.customerID != null) this.customerID.SetValue(this.theEntity.customerID);
			if(this.shipToAddressID != null) this.shipToAddressID.SetValue(this.theEntity.shipToAddressID);
			if(this.billToAddressID != null) this.billToAddressID.SetValue(this.theEntity.billToAddressID);
			if(this.shipMethod != null) this.shipMethod.SetValue(this.theEntity.shipMethod);
			if(this.creditCardApprovalCode != null) this.creditCardApprovalCode.SetValue(this.theEntity.creditCardApprovalCode);
			if(this.subTotal != null) this.subTotal.SetValue(this.theEntity.subTotal);
			if(this.taxAmt != null) this.taxAmt.SetValue(this.theEntity.taxAmt);
			if(this.freight != null) this.freight.SetValue(this.theEntity.freight);
			if(this.totalDue != null) this.totalDue.SetValue(this.theEntity.totalDue);
			if(this.comment != null) this.comment.SetValue(this.theEntity.comment);
			if(this.modifiedDate != null) this.modifiedDate.SetValue(this.theEntity.modifiedDate);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.salesOrderID != null) this.theEntity.salesOrderID = NumberUtil.Value<Int32>(this.salesOrderID.GetValue());
			if(this.revisionNumber != null) this.theEntity.revisionNumber = NumberUtil.Value<Byte>(this.revisionNumber.GetValue());
			if(this.orderDate != null) this.theEntity.orderDate = DateUtil.DateValue(this.orderDate.GetValue());
			if(this.dueDate != null) this.theEntity.dueDate = DateUtil.DateValue(this.dueDate.GetValue());
			if(this.shipDate != null) this.theEntity.shipDate = DateUtil.DateValue(this.shipDate.GetValue());
			if(this.status != null) this.theEntity.status = NumberUtil.Value<Byte>(this.status.GetValue());
			if(this.salesOrderNumber != null) this.theEntity.salesOrderNumber = StringUtil.StringValue(this.salesOrderNumber.GetValue());
			if(this.customerID != null) this.theEntity.customerID = NumberUtil.Value<Int32>(this.customerID.GetValue());
			if(this.shipToAddressID != null) this.theEntity.shipToAddressID = NumberUtil.Value<Int32?>(this.shipToAddressID.GetValue());
			if(this.billToAddressID != null) this.theEntity.billToAddressID = NumberUtil.Value<Int32?>(this.billToAddressID.GetValue());
			if(this.shipMethod != null) this.theEntity.shipMethod = StringUtil.StringValue(this.shipMethod.GetValue());
			if(this.creditCardApprovalCode != null) this.theEntity.creditCardApprovalCode = StringUtil.StringValue(this.creditCardApprovalCode.GetValue());
			if(this.subTotal != null) this.theEntity.subTotal = NumberUtil.Value<Decimal>(this.subTotal.GetValue());
			if(this.taxAmt != null) this.theEntity.taxAmt = NumberUtil.Value<Decimal>(this.taxAmt.GetValue());
			if(this.freight != null) this.theEntity.freight = NumberUtil.Value<Decimal>(this.freight.GetValue());
			if(this.totalDue != null) this.theEntity.totalDue = NumberUtil.Value<Decimal>(this.totalDue.GetValue());
			if(this.comment != null) this.theEntity.comment = StringUtil.StringValue(this.comment.GetValue());
			if(this.modifiedDate != null) this.theEntity.modifiedDate = DateUtil.DateValue(this.modifiedDate.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.salesOrderID != null) this.salesOrderID.UpdateField();
			if(this.revisionNumber != null) this.revisionNumber.UpdateField();
			if(this.orderDate != null) this.orderDate.UpdateField();
			if(this.dueDate != null) this.dueDate.UpdateField();
			if(this.shipDate != null) this.shipDate.UpdateField();
			if(this.status != null) this.status.UpdateField();
			if(this.salesOrderNumber != null) this.salesOrderNumber.UpdateField();
			if(this.customerID != null) this.customerID.UpdateField();
			if(this.shipToAddressID != null) this.shipToAddressID.UpdateField();
			if(this.billToAddressID != null) this.billToAddressID.UpdateField();
			if(this.shipMethod != null) this.shipMethod.UpdateField();
			if(this.creditCardApprovalCode != null) this.creditCardApprovalCode.UpdateField();
			if(this.subTotal != null) this.subTotal.UpdateField();
			if(this.taxAmt != null) this.taxAmt.UpdateField();
			if(this.freight != null) this.freight.UpdateField();
			if(this.totalDue != null) this.totalDue.UpdateField();
			if(this.comment != null) this.comment.UpdateField();
			if(this.modifiedDate != null) this.modifiedDate.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.salesOrderID != null){
			    if(!this.salesOrderID.Validate()){
				    valid = false;
				    this.messages.Add(this.salesOrderID.ErrorMessage);
			    }
			}
			
			if(this.revisionNumber != null){
			    if(!this.revisionNumber.Validate()){
				    valid = false;
				    this.messages.Add(this.revisionNumber.ErrorMessage);
			    }
			}
			
			if(this.orderDate != null){
			    if(!this.orderDate.Validate()){
				    valid = false;
				    this.messages.Add(this.orderDate.ErrorMessage);
			    }
			}
			
			if(this.dueDate != null){
			    if(!this.dueDate.Validate()){
				    valid = false;
				    this.messages.Add(this.dueDate.ErrorMessage);
			    }
			}
			
			if(this.shipDate != null){
			    if(!this.shipDate.Validate()){
				    valid = false;
				    this.messages.Add(this.shipDate.ErrorMessage);
			    }
			}
			
			if(this.status != null){
			    if(!this.status.Validate()){
				    valid = false;
				    this.messages.Add(this.status.ErrorMessage);
			    }
			}
			
			if(this.salesOrderNumber != null){
			    if(!this.salesOrderNumber.Validate()){
				    valid = false;
				    this.messages.Add(this.salesOrderNumber.ErrorMessage);
			    }
			}
			
			if(this.customerID != null){
			    if(!this.customerID.Validate()){
				    valid = false;
				    this.messages.Add(this.customerID.ErrorMessage);
			    }
			}
			
			if(this.shipToAddressID != null){
			    if(!this.shipToAddressID.Validate()){
				    valid = false;
				    this.messages.Add(this.shipToAddressID.ErrorMessage);
			    }
			}
			
			if(this.billToAddressID != null){
			    if(!this.billToAddressID.Validate()){
				    valid = false;
				    this.messages.Add(this.billToAddressID.ErrorMessage);
			    }
			}
			
			if(this.shipMethod != null){
			    if(!this.shipMethod.Validate()){
				    valid = false;
				    this.messages.Add(this.shipMethod.ErrorMessage);
			    }
			}
			
			if(this.creditCardApprovalCode != null){
			    if(!this.creditCardApprovalCode.Validate()){
				    valid = false;
				    this.messages.Add(this.creditCardApprovalCode.ErrorMessage);
			    }
			}
			
			if(this.subTotal != null){
			    if(!this.subTotal.Validate()){
				    valid = false;
				    this.messages.Add(this.subTotal.ErrorMessage);
			    }
			}
			
			if(this.taxAmt != null){
			    if(!this.taxAmt.Validate()){
				    valid = false;
				    this.messages.Add(this.taxAmt.ErrorMessage);
			    }
			}
			
			if(this.freight != null){
			    if(!this.freight.Validate()){
				    valid = false;
				    this.messages.Add(this.freight.ErrorMessage);
			    }
			}
			
			if(this.totalDue != null){
			    if(!this.totalDue.Validate()){
				    valid = false;
				    this.messages.Add(this.totalDue.ErrorMessage);
			    }
			}
			
			if(this.comment != null){
			    if(!this.comment.Validate()){
				    valid = false;
				    this.messages.Add(this.comment.ErrorMessage);
			    }
			}
			
			if(this.modifiedDate != null){
			    if(!this.modifiedDate.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedDate.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private SalesOrderHeaderFormAdapter formAdapter;
    //     private SalesOrderHeaderProperty property;
    //     private SalesOrderHeaderEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new SalesOrderHeaderFormAdapter();

	
    formAdapter.salesOrderID= new TextBoxAdapterElement(
        salesOrderID,
        new CFW.Forms.Filters.StringFilter(property.salesOrderID),
        CFW.Validators.FieldValidator.GetInstance(property.salesOrderID)
    );
	
    formAdapter.revisionNumber= new TextBoxAdapterElement(
        revisionNumber,
        new CFW.Forms.Filters.StringFilter(property.revisionNumber),
        CFW.Validators.FieldValidator.GetInstance(property.revisionNumber)
    );
	
    formAdapter.orderDate= new TextBoxAdapterElement(
        orderDate,
        new CFW.Forms.Filters.StringFilter(property.orderDate),
        CFW.Validators.FieldValidator.GetInstance(property.orderDate)
    );
	
    formAdapter.dueDate= new TextBoxAdapterElement(
        dueDate,
        new CFW.Forms.Filters.StringFilter(property.dueDate),
        CFW.Validators.FieldValidator.GetInstance(property.dueDate)
    );
	
    formAdapter.shipDate= new TextBoxAdapterElement(
        shipDate,
        new CFW.Forms.Filters.StringFilter(property.shipDate),
        CFW.Validators.FieldValidator.GetInstance(property.shipDate)
    );
	
    formAdapter.status= new TextBoxAdapterElement(
        status,
        new CFW.Forms.Filters.StringFilter(property.status),
        CFW.Validators.FieldValidator.GetInstance(property.status)
    );
	
    formAdapter.salesOrderNumber= new TextBoxAdapterElement(
        salesOrderNumber,
        new CFW.Forms.Filters.StringFilter(property.salesOrderNumber),
        CFW.Validators.FieldValidator.GetInstance(property.salesOrderNumber)
    );
	
    formAdapter.customerID= new TextBoxAdapterElement(
        customerID,
        new CFW.Forms.Filters.StringFilter(property.customerID),
        CFW.Validators.FieldValidator.GetInstance(property.customerID)
    );
	
    formAdapter.shipToAddressID= new TextBoxAdapterElement(
        shipToAddressID,
        new CFW.Forms.Filters.StringFilter(property.shipToAddressID),
        CFW.Validators.FieldValidator.GetInstance(property.shipToAddressID)
    );
	
    formAdapter.billToAddressID= new TextBoxAdapterElement(
        billToAddressID,
        new CFW.Forms.Filters.StringFilter(property.billToAddressID),
        CFW.Validators.FieldValidator.GetInstance(property.billToAddressID)
    );
	
    formAdapter.shipMethod= new TextBoxAdapterElement(
        shipMethod,
        new CFW.Forms.Filters.StringFilter(property.shipMethod),
        CFW.Validators.FieldValidator.GetInstance(property.shipMethod)
    );
	
    formAdapter.creditCardApprovalCode= new TextBoxAdapterElement(
        creditCardApprovalCode,
        new CFW.Forms.Filters.StringFilter(property.creditCardApprovalCode),
        CFW.Validators.FieldValidator.GetInstance(property.creditCardApprovalCode)
    );
	
    formAdapter.subTotal= new TextBoxAdapterElement(
        subTotal,
        new CFW.Forms.Filters.StringFilter(property.subTotal),
        CFW.Validators.FieldValidator.GetInstance(property.subTotal)
    );
	
    formAdapter.taxAmt= new TextBoxAdapterElement(
        taxAmt,
        new CFW.Forms.Filters.StringFilter(property.taxAmt),
        CFW.Validators.FieldValidator.GetInstance(property.taxAmt)
    );
	
    formAdapter.freight= new TextBoxAdapterElement(
        freight,
        new CFW.Forms.Filters.StringFilter(property.freight),
        CFW.Validators.FieldValidator.GetInstance(property.freight)
    );
	
    formAdapter.totalDue= new TextBoxAdapterElement(
        totalDue,
        new CFW.Forms.Filters.StringFilter(property.totalDue),
        CFW.Validators.FieldValidator.GetInstance(property.totalDue)
    );
	
    formAdapter.comment= new TextBoxAdapterElement(
        comment,
        new CFW.Forms.Filters.StringFilter(property.comment),
        CFW.Validators.FieldValidator.GetInstance(property.comment)
    );
	
    formAdapter.modifiedDate= new TextBoxAdapterElement(
        modifiedDate,
        new CFW.Forms.Filters.StringFilter(property.modifiedDate),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedDate)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}