using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table BuildVersion Field`
    /// </summary>
    [Serializable()]
    public class BuildVersionTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>Version number of the database in 9.yy.mm.dd.00 format.</summary>
        protected string _databaseVersion;
        ///<summary>Version number of the database in 9.yy.mm.dd.00 format.</summary>
        public string databaseVersion{
            get{return _databaseVersion;}
            set{_databaseVersion = value;}
        }
        ///<summary>Date and time the record was last updated.</summary>
        protected DateTime? _versionDate;
        ///<summary>Date and time the record was last updated.</summary>
        public DateTime? versionDate{
            get{return _versionDate;}
            set{_versionDate = value;}
        }
        ///<summary>Date and time the record was last updated.</summary>
        protected DateTime? _modifiedDate;
        ///<summary>Date and time the record was last updated.</summary>
        public DateTime? modifiedDate{
            get{return _modifiedDate;}
            set{_modifiedDate = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public BuildVersionTableRow() : base()
        {
            this._databaseVersion = "";
            this._versionDate = null;
            this._modifiedDate = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "Database Version"){ this._databaseVersion = StringUtil.StringValue( value );return; }
            if(name ==  "VersionDate"){ this._versionDate = DateUtil.DateValue( value );return; }
            if(name ==  "ModifiedDate"){ this._modifiedDate = DateUtil.DateValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "Database Version") return this._databaseVersion;
            if(name ==  "VersionDate") return this._versionDate;
            if(name ==  "ModifiedDate") return this._modifiedDate;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            BuildVersionTableRow clone = new BuildVersionTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(BuildVersionTableRow source)
        {
            this.databaseVersion = source.databaseVersion;
            this.versionDate = source.versionDate;
            this.modifiedDate = source.modifiedDate;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("Database Version")){ this._databaseVersion = StringUtil.StringValue(row["Database Version"]); }
            if (cols.Contains("VersionDate")){ this._versionDate = DateUtil.DateValue(row["VersionDate"]); }
            if (cols.Contains("ModifiedDate")){ this._modifiedDate = DateUtil.DateValue(row["ModifiedDate"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "Database Version");if (cols.Contains(columnName)){ this._databaseVersion = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "VersionDate");if (cols.Contains(columnName)){ this._versionDate = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ModifiedDate");if (cols.Contains(columnName)){ this._modifiedDate = DateUtil.DateValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._databaseVersion = StringUtil.StringValue(reader[0]);
            this._versionDate = DateUtil.DateValue(reader[1]);
            this._modifiedDate = DateUtil.DateValue(reader[2]);
            
            this.IsNew = false;
        }
    }

}