using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table CustomerAddressɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class CustomerAddressTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[CustomerID]</summary>
        public FieldProperty customerID;
        ///<summary>[AddressID]</summary>
        public FieldProperty addressID;
        ///<summary>[ModifiedDate]</summary>
        public FieldProperty modifiedDate;
        

        /// <summary>
        /// default construct
        /// </summary>
        public CustomerAddressTableProperty()
        {
            this.EntityName = "CustomerAddress";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            customerID = FieldProperty.NewInstance("int", "CustomerAddress", "CustomerID","[CustomerID]", 4, 10, 0, false, 0,false);
            addressID = FieldProperty.NewInstance("int", "CustomerAddress", "AddressID","[AddressID]", 4, 10, 0, false, 0,false);
            modifiedDate = FieldProperty.NewInstance("datetime", "CustomerAddress", "ModifiedDate","[ModifiedDate]", 16, 23, 3, false, null,false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.customerID;
            yield return this.addressID;
            yield return this.modifiedDate;
            
        }
                
    }
}