using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table Customer Field`
    /// </summary>
    [Serializable()]
    public class CustomerTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[CustomerID]</summary>
        protected Int32 _customerID;
        ///<summary>[CustomerID]</summary>
        public Int32 customerID{
            get{return _customerID;}
            set{_customerID = value;}
        }
        ///<summary>[Title]</summary>
        protected string _title;
        ///<summary>[Title]</summary>
        public string title{
            get{return _title;}
            set{_title = value;}
        }
        ///<summary>[Suffix]</summary>
        protected string _suffix;
        ///<summary>[Suffix]</summary>
        public string suffix{
            get{return _suffix;}
            set{_suffix = value;}
        }
        ///<summary>[CompanyName]</summary>
        protected string _companyName;
        ///<summary>[CompanyName]</summary>
        public string companyName{
            get{return _companyName;}
            set{_companyName = value;}
        }
        ///<summary>[SalesPerson]</summary>
        protected string _salesPerson;
        ///<summary>[SalesPerson]</summary>
        public string salesPerson{
            get{return _salesPerson;}
            set{_salesPerson = value;}
        }
        ///<summary>[EmailAddress]</summary>
        protected string _emailAddress;
        ///<summary>[EmailAddress]</summary>
        public string emailAddress{
            get{return _emailAddress;}
            set{_emailAddress = value;}
        }
        ///<summary>[PasswordHash]</summary>
        protected string _passwordHash;
        ///<summary>[PasswordHash]</summary>
        public string passwordHash{
            get{return _passwordHash;}
            set{_passwordHash = value;}
        }
        ///<summary>[PasswordSalt]</summary>
        protected string _passwordSalt;
        ///<summary>[PasswordSalt]</summary>
        public string passwordSalt{
            get{return _passwordSalt;}
            set{_passwordSalt = value;}
        }
        ///<summary>[ModifiedDate]</summary>
        protected DateTime? _modifiedDate;
        ///<summary>[ModifiedDate]</summary>
        public DateTime? modifiedDate{
            get{return _modifiedDate;}
            set{_modifiedDate = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public CustomerTableRow() : base()
        {
            this._customerID = 0;
            this._title = "";
            this._suffix = "";
            this._companyName = "";
            this._salesPerson = "";
            this._emailAddress = "";
            this._passwordHash = "";
            this._passwordSalt = "";
            this._modifiedDate = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "CustomerID"){ this._customerID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "Title"){ this._title = StringUtil.StringValue( value );return; }
            if(name ==  "Suffix"){ this._suffix = StringUtil.StringValue( value );return; }
            if(name ==  "CompanyName"){ this._companyName = StringUtil.StringValue( value );return; }
            if(name ==  "SalesPerson"){ this._salesPerson = StringUtil.StringValue( value );return; }
            if(name ==  "EmailAddress"){ this._emailAddress = StringUtil.StringValue( value );return; }
            if(name ==  "PasswordHash"){ this._passwordHash = StringUtil.StringValue( value );return; }
            if(name ==  "PasswordSalt"){ this._passwordSalt = StringUtil.StringValue( value );return; }
            if(name ==  "ModifiedDate"){ this._modifiedDate = DateUtil.DateValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "CustomerID") return this._customerID;
            if(name ==  "Title") return this._title;
            if(name ==  "Suffix") return this._suffix;
            if(name ==  "CompanyName") return this._companyName;
            if(name ==  "SalesPerson") return this._salesPerson;
            if(name ==  "EmailAddress") return this._emailAddress;
            if(name ==  "PasswordHash") return this._passwordHash;
            if(name ==  "PasswordSalt") return this._passwordSalt;
            if(name ==  "ModifiedDate") return this._modifiedDate;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            CustomerTableRow clone = new CustomerTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(CustomerTableRow source)
        {
            this.customerID = source.customerID;
            this.title = source.title;
            this.suffix = source.suffix;
            this.companyName = source.companyName;
            this.salesPerson = source.salesPerson;
            this.emailAddress = source.emailAddress;
            this.passwordHash = source.passwordHash;
            this.passwordSalt = source.passwordSalt;
            this.modifiedDate = source.modifiedDate;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("CustomerID")){ this._customerID = NumberUtil.Value<Int32>(row["CustomerID"]); }
            if (cols.Contains("Title")){ this._title = StringUtil.StringValue(row["Title"]); }
            if (cols.Contains("Suffix")){ this._suffix = StringUtil.StringValue(row["Suffix"]); }
            if (cols.Contains("CompanyName")){ this._companyName = StringUtil.StringValue(row["CompanyName"]); }
            if (cols.Contains("SalesPerson")){ this._salesPerson = StringUtil.StringValue(row["SalesPerson"]); }
            if (cols.Contains("EmailAddress")){ this._emailAddress = StringUtil.StringValue(row["EmailAddress"]); }
            if (cols.Contains("PasswordHash")){ this._passwordHash = StringUtil.StringValue(row["PasswordHash"]); }
            if (cols.Contains("PasswordSalt")){ this._passwordSalt = StringUtil.StringValue(row["PasswordSalt"]); }
            if (cols.Contains("ModifiedDate")){ this._modifiedDate = DateUtil.DateValue(row["ModifiedDate"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "CustomerID");if (cols.Contains(columnName)){ this._customerID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "Title");if (cols.Contains(columnName)){ this._title = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "Suffix");if (cols.Contains(columnName)){ this._suffix = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CompanyName");if (cols.Contains(columnName)){ this._companyName = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "SalesPerson");if (cols.Contains(columnName)){ this._salesPerson = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "EmailAddress");if (cols.Contains(columnName)){ this._emailAddress = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "PasswordHash");if (cols.Contains(columnName)){ this._passwordHash = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "PasswordSalt");if (cols.Contains(columnName)){ this._passwordSalt = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ModifiedDate");if (cols.Contains(columnName)){ this._modifiedDate = DateUtil.DateValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._customerID = NumberUtil.Value<Int32>(reader[0]);
            this._title = StringUtil.StringValue(reader[1]);
            this._suffix = StringUtil.StringValue(reader[2]);
            this._companyName = StringUtil.StringValue(reader[3]);
            this._salesPerson = StringUtil.StringValue(reader[4]);
            this._emailAddress = StringUtil.StringValue(reader[5]);
            this._passwordHash = StringUtil.StringValue(reader[6]);
            this._passwordSalt = StringUtil.StringValue(reader[7]);
            this._modifiedDate = DateUtil.DateValue(reader[8]);
            
            this.IsNew = false;
        }
    }

}