using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table ErrorLogɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class ErrorLogTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>Primary key for ErrorLog records.</summary>
        public FieldProperty errorLogID;
        ///<summary>The date and time at which the error occurred.</summary>
        public FieldProperty errorTime;
        ///<summary>The error number of the error that occurred.</summary>
        public FieldProperty errorNumber;
        ///<summary>The severity of the error that occurred.</summary>
        public FieldProperty errorSeverity;
        ///<summary>The state number of the error that occurred.</summary>
        public FieldProperty errorState;
        ///<summary>The name of the stored procedure or trigger where the error occurred.</summary>
        public FieldProperty errorProcedure;
        ///<summary>The line number at which the error occurred.</summary>
        public FieldProperty errorLine;
        ///<summary>The message text of the error that occurred.</summary>
        public FieldProperty errorMessage;
        

        /// <summary>
        /// default construct
        /// </summary>
        public ErrorLogTableProperty()
        {
            this.EntityName = "ErrorLog";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            errorLogID = FieldProperty.NewInstance("int identity", "ErrorLog", "ErrorLogID","Primary key for ErrorLog records.", 4, 10, 0, false, 0,true);
            errorTime = FieldProperty.NewInstance("datetime", "ErrorLog", "ErrorTime","The date and time at which the error occurred.", 16, 23, 3, false, null,false);
            errorNumber = FieldProperty.NewInstance("int", "ErrorLog", "ErrorNumber","The error number of the error that occurred.", 4, 10, 0, false, 0,false);
            errorSeverity = FieldProperty.NewInstance("int", "ErrorLog", "ErrorSeverity","The severity of the error that occurred.", 4, 10, 0, true, null,false);
            errorState = FieldProperty.NewInstance("int", "ErrorLog", "ErrorState","The state number of the error that occurred.", 4, 10, 0, true, null,false);
            errorProcedure = FieldProperty.NewInstance("nvarchar", "ErrorLog", "ErrorProcedure","The name of the stored procedure or trigger where the error occurred.", 252, 126, 0, true, "",false);
            errorLine = FieldProperty.NewInstance("int", "ErrorLog", "ErrorLine","The line number at which the error occurred.", 4, 10, 0, true, null,false);
            errorMessage = FieldProperty.NewInstance("nvarchar", "ErrorLog", "ErrorMessage","The message text of the error that occurred.", 8000, 4000, 0, false, "",false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.errorLogID;
            yield return this.errorTime;
            yield return this.errorNumber;
            yield return this.errorSeverity;
            yield return this.errorState;
            yield return this.errorProcedure;
            yield return this.errorLine;
            yield return this.errorMessage;
            
        }
                /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> PrimaryKeys()
        {
            yield return  this.errorLogID;
            
        }
                
    }
}