using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table ProductModelProductDescription Field`
    /// </summary>
    [Serializable()]
    public class ProductModelProductDescriptionTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[ProductModelID]</summary>
        protected Int32 _productModelID;
        ///<summary>[ProductModelID]</summary>
        public Int32 productModelID{
            get{return _productModelID;}
            set{_productModelID = value;}
        }
        ///<summary>[ProductDescriptionID]</summary>
        protected Int32 _productDescriptionID;
        ///<summary>[ProductDescriptionID]</summary>
        public Int32 productDescriptionID{
            get{return _productDescriptionID;}
            set{_productDescriptionID = value;}
        }
        ///<summary>[Culture]</summary>
        protected string _culture;
        ///<summary>[Culture]</summary>
        public string culture{
            get{return _culture;}
            set{_culture = value;}
        }
        ///<summary>[ModifiedDate]</summary>
        protected DateTime? _modifiedDate;
        ///<summary>[ModifiedDate]</summary>
        public DateTime? modifiedDate{
            get{return _modifiedDate;}
            set{_modifiedDate = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public ProductModelProductDescriptionTableRow() : base()
        {
            this._productModelID = 0;
            this._productDescriptionID = 0;
            this._culture = "";
            this._modifiedDate = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "ProductModelID"){ this._productModelID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "ProductDescriptionID"){ this._productDescriptionID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "Culture"){ this._culture = StringUtil.StringValue( value );return; }
            if(name ==  "ModifiedDate"){ this._modifiedDate = DateUtil.DateValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "ProductModelID") return this._productModelID;
            if(name ==  "ProductDescriptionID") return this._productDescriptionID;
            if(name ==  "Culture") return this._culture;
            if(name ==  "ModifiedDate") return this._modifiedDate;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            ProductModelProductDescriptionTableRow clone = new ProductModelProductDescriptionTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(ProductModelProductDescriptionTableRow source)
        {
            this.productModelID = source.productModelID;
            this.productDescriptionID = source.productDescriptionID;
            this.culture = source.culture;
            this.modifiedDate = source.modifiedDate;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("ProductModelID")){ this._productModelID = NumberUtil.Value<Int32>(row["ProductModelID"]); }
            if (cols.Contains("ProductDescriptionID")){ this._productDescriptionID = NumberUtil.Value<Int32>(row["ProductDescriptionID"]); }
            if (cols.Contains("Culture")){ this._culture = StringUtil.StringValue(row["Culture"]); }
            if (cols.Contains("ModifiedDate")){ this._modifiedDate = DateUtil.DateValue(row["ModifiedDate"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "ProductModelID");if (cols.Contains(columnName)){ this._productModelID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "ProductDescriptionID");if (cols.Contains(columnName)){ this._productDescriptionID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "Culture");if (cols.Contains(columnName)){ this._culture = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ModifiedDate");if (cols.Contains(columnName)){ this._modifiedDate = DateUtil.DateValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._productModelID = NumberUtil.Value<Int32>(reader[0]);
            this._productDescriptionID = NumberUtil.Value<Int32>(reader[1]);
            this._culture = StringUtil.StringValue(reader[2]);
            this._modifiedDate = DateUtil.DateValue(reader[3]);
            
            this.IsNew = false;
        }
    }

}