using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table ProductɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class ProductTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[ProductID]</summary>
        public FieldProperty productID;
        ///<summary>[ProductNumber]</summary>
        public FieldProperty productNumber;
        ///<summary>[Color]</summary>
        public FieldProperty color;
        ///<summary>[StandardCost]</summary>
        public FieldProperty standardCost;
        ///<summary>[ListPrice]</summary>
        public FieldProperty listPrice;
        ///<summary>[Size]</summary>
        public FieldProperty size;
        ///<summary>[Weight]</summary>
        public FieldProperty weight;
        ///<summary>[ProductCategoryID]</summary>
        public FieldProperty productCategoryID;
        ///<summary>[ProductModelID]</summary>
        public FieldProperty productModelID;
        ///<summary>[SellStartDate]</summary>
        public FieldProperty sellStartDate;
        ///<summary>[SellEndDate]</summary>
        public FieldProperty sellEndDate;
        ///<summary>[DiscontinuedDate]</summary>
        public FieldProperty discontinuedDate;
        ///<summary>[ThumbnailPhotoFileName]</summary>
        public FieldProperty thumbnailPhotoFileName;
        ///<summary>[ModifiedDate]</summary>
        public FieldProperty modifiedDate;
        

        /// <summary>
        /// default construct
        /// </summary>
        public ProductTableProperty()
        {
            this.EntityName = "Product";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            productID = FieldProperty.NewInstance("int identity", "Product", "ProductID","[ProductID]", 4, 10, 0, false, 0,false);
            productNumber = FieldProperty.NewInstance("nvarchar", "Product", "ProductNumber","[ProductNumber]", 50, 25, 0, false, "",false);
            color = FieldProperty.NewInstance("nvarchar", "Product", "Color","[Color]", 30, 15, 0, true, "",false);
            standardCost = FieldProperty.NewInstance("money", "Product", "StandardCost","[StandardCost]", 21, 19, 4, false, 0,false);
            listPrice = FieldProperty.NewInstance("money", "Product", "ListPrice","[ListPrice]", 21, 19, 4, false, 0,false);
            size = FieldProperty.NewInstance("nvarchar", "Product", "Size","[Size]", 10, 5, 0, true, "",false);
            weight = FieldProperty.NewInstance("decimal", "Product", "Weight","[Weight]", 10, 8, 2, true, null,false);
            productCategoryID = FieldProperty.NewInstance("int", "Product", "ProductCategoryID","[ProductCategoryID]", 4, 10, 0, true, null,false);
            productModelID = FieldProperty.NewInstance("int", "Product", "ProductModelID","[ProductModelID]", 4, 10, 0, true, null,false);
            sellStartDate = FieldProperty.NewInstance("datetime", "Product", "SellStartDate","[SellStartDate]", 16, 23, 3, false, null,false);
            sellEndDate = FieldProperty.NewInstance("datetime", "Product", "SellEndDate","[SellEndDate]", 16, 23, 3, true, null,false);
            discontinuedDate = FieldProperty.NewInstance("datetime", "Product", "DiscontinuedDate","[DiscontinuedDate]", 16, 23, 3, true, null,false);
            thumbnailPhotoFileName = FieldProperty.NewInstance("nvarchar", "Product", "ThumbnailPhotoFileName","[ThumbnailPhotoFileName]", 100, 50, 0, true, "",false);
            modifiedDate = FieldProperty.NewInstance("datetime", "Product", "ModifiedDate","[ModifiedDate]", 16, 23, 3, false, null,false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.productID;
            yield return this.productNumber;
            yield return this.color;
            yield return this.standardCost;
            yield return this.listPrice;
            yield return this.size;
            yield return this.weight;
            yield return this.productCategoryID;
            yield return this.productModelID;
            yield return this.sellStartDate;
            yield return this.sellEndDate;
            yield return this.discontinuedDate;
            yield return this.thumbnailPhotoFileName;
            yield return this.modifiedDate;
            
        }
                
    }
}