using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table Product Field`
    /// </summary>
    [Serializable()]
    public class ProductTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[ProductID]</summary>
        protected Int32 _productID;
        ///<summary>[ProductID]</summary>
        public Int32 productID{
            get{return _productID;}
            set{_productID = value;}
        }
        ///<summary>[ProductNumber]</summary>
        protected string _productNumber;
        ///<summary>[ProductNumber]</summary>
        public string productNumber{
            get{return _productNumber;}
            set{_productNumber = value;}
        }
        ///<summary>[Color]</summary>
        protected string _color;
        ///<summary>[Color]</summary>
        public string color{
            get{return _color;}
            set{_color = value;}
        }
        ///<summary>[StandardCost]</summary>
        protected Decimal _standardCost;
        ///<summary>[StandardCost]</summary>
        public Decimal standardCost{
            get{return _standardCost;}
            set{_standardCost = value;}
        }
        ///<summary>[ListPrice]</summary>
        protected Decimal _listPrice;
        ///<summary>[ListPrice]</summary>
        public Decimal listPrice{
            get{return _listPrice;}
            set{_listPrice = value;}
        }
        ///<summary>[Size]</summary>
        protected string _size;
        ///<summary>[Size]</summary>
        public string size{
            get{return _size;}
            set{_size = value;}
        }
        ///<summary>[Weight]</summary>
        protected System.Nullable<Decimal> _weight;
        ///<summary>[Weight]</summary>
        public System.Nullable<Decimal> weight{
            get{return _weight;}
            set{_weight = value;}
        }
        ///<summary>[ProductCategoryID]</summary>
        protected System.Nullable<Int32> _productCategoryID;
        ///<summary>[ProductCategoryID]</summary>
        public System.Nullable<Int32> productCategoryID{
            get{return _productCategoryID;}
            set{_productCategoryID = value;}
        }
        ///<summary>[ProductModelID]</summary>
        protected System.Nullable<Int32> _productModelID;
        ///<summary>[ProductModelID]</summary>
        public System.Nullable<Int32> productModelID{
            get{return _productModelID;}
            set{_productModelID = value;}
        }
        ///<summary>[SellStartDate]</summary>
        protected DateTime? _sellStartDate;
        ///<summary>[SellStartDate]</summary>
        public DateTime? sellStartDate{
            get{return _sellStartDate;}
            set{_sellStartDate = value;}
        }
        ///<summary>[SellEndDate]</summary>
        protected DateTime? _sellEndDate;
        ///<summary>[SellEndDate]</summary>
        public DateTime? sellEndDate{
            get{return _sellEndDate;}
            set{_sellEndDate = value;}
        }
        ///<summary>[DiscontinuedDate]</summary>
        protected DateTime? _discontinuedDate;
        ///<summary>[DiscontinuedDate]</summary>
        public DateTime? discontinuedDate{
            get{return _discontinuedDate;}
            set{_discontinuedDate = value;}
        }
        ///<summary>[ThumbnailPhotoFileName]</summary>
        protected string _thumbnailPhotoFileName;
        ///<summary>[ThumbnailPhotoFileName]</summary>
        public string thumbnailPhotoFileName{
            get{return _thumbnailPhotoFileName;}
            set{_thumbnailPhotoFileName = value;}
        }
        ///<summary>[ModifiedDate]</summary>
        protected DateTime? _modifiedDate;
        ///<summary>[ModifiedDate]</summary>
        public DateTime? modifiedDate{
            get{return _modifiedDate;}
            set{_modifiedDate = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public ProductTableRow() : base()
        {
            this._productID = 0;
            this._productNumber = "";
            this._color = "";
            this._standardCost = 0;
            this._listPrice = 0;
            this._size = "";
            this._weight = null;
            this._productCategoryID = null;
            this._productModelID = null;
            this._sellStartDate = null;
            this._sellEndDate = null;
            this._discontinuedDate = null;
            this._thumbnailPhotoFileName = "";
            this._modifiedDate = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "ProductID"){ this._productID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "ProductNumber"){ this._productNumber = StringUtil.StringValue( value );return; }
            if(name ==  "Color"){ this._color = StringUtil.StringValue( value );return; }
            if(name ==  "StandardCost"){ this._standardCost = NumberUtil.Value<Decimal>( value );return; }
            if(name ==  "ListPrice"){ this._listPrice = NumberUtil.Value<Decimal>( value );return; }
            if(name ==  "Size"){ this._size = StringUtil.StringValue( value );return; }
            if(name ==  "Weight"){ this._weight = NumberUtil.Value<Decimal?>( value );return; }
            if(name ==  "ProductCategoryID"){ this._productCategoryID = NumberUtil.Value<Int32?>( value );return; }
            if(name ==  "ProductModelID"){ this._productModelID = NumberUtil.Value<Int32?>( value );return; }
            if(name ==  "SellStartDate"){ this._sellStartDate = DateUtil.DateValue( value );return; }
            if(name ==  "SellEndDate"){ this._sellEndDate = DateUtil.DateValue( value );return; }
            if(name ==  "DiscontinuedDate"){ this._discontinuedDate = DateUtil.DateValue( value );return; }
            if(name ==  "ThumbnailPhotoFileName"){ this._thumbnailPhotoFileName = StringUtil.StringValue( value );return; }
            if(name ==  "ModifiedDate"){ this._modifiedDate = DateUtil.DateValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "ProductID") return this._productID;
            if(name ==  "ProductNumber") return this._productNumber;
            if(name ==  "Color") return this._color;
            if(name ==  "StandardCost") return this._standardCost;
            if(name ==  "ListPrice") return this._listPrice;
            if(name ==  "Size") return this._size;
            if(name ==  "Weight") return this._weight;
            if(name ==  "ProductCategoryID") return this._productCategoryID;
            if(name ==  "ProductModelID") return this._productModelID;
            if(name ==  "SellStartDate") return this._sellStartDate;
            if(name ==  "SellEndDate") return this._sellEndDate;
            if(name ==  "DiscontinuedDate") return this._discontinuedDate;
            if(name ==  "ThumbnailPhotoFileName") return this._thumbnailPhotoFileName;
            if(name ==  "ModifiedDate") return this._modifiedDate;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            ProductTableRow clone = new ProductTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(ProductTableRow source)
        {
            this.productID = source.productID;
            this.productNumber = source.productNumber;
            this.color = source.color;
            this.standardCost = source.standardCost;
            this.listPrice = source.listPrice;
            this.size = source.size;
            this.weight = source.weight;
            this.productCategoryID = source.productCategoryID;
            this.productModelID = source.productModelID;
            this.sellStartDate = source.sellStartDate;
            this.sellEndDate = source.sellEndDate;
            this.discontinuedDate = source.discontinuedDate;
            this.thumbnailPhotoFileName = source.thumbnailPhotoFileName;
            this.modifiedDate = source.modifiedDate;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("ProductID")){ this._productID = NumberUtil.Value<Int32>(row["ProductID"]); }
            if (cols.Contains("ProductNumber")){ this._productNumber = StringUtil.StringValue(row["ProductNumber"]); }
            if (cols.Contains("Color")){ this._color = StringUtil.StringValue(row["Color"]); }
            if (cols.Contains("StandardCost")){ this._standardCost = NumberUtil.Value<Decimal>(row["StandardCost"]); }
            if (cols.Contains("ListPrice")){ this._listPrice = NumberUtil.Value<Decimal>(row["ListPrice"]); }
            if (cols.Contains("Size")){ this._size = StringUtil.StringValue(row["Size"]); }
            if (cols.Contains("Weight")){ this._weight = NumberUtil.Value<Decimal?>(row["Weight"]); }
            if (cols.Contains("ProductCategoryID")){ this._productCategoryID = NumberUtil.Value<Int32?>(row["ProductCategoryID"]); }
            if (cols.Contains("ProductModelID")){ this._productModelID = NumberUtil.Value<Int32?>(row["ProductModelID"]); }
            if (cols.Contains("SellStartDate")){ this._sellStartDate = DateUtil.DateValue(row["SellStartDate"]); }
            if (cols.Contains("SellEndDate")){ this._sellEndDate = DateUtil.DateValue(row["SellEndDate"]); }
            if (cols.Contains("DiscontinuedDate")){ this._discontinuedDate = DateUtil.DateValue(row["DiscontinuedDate"]); }
            if (cols.Contains("ThumbnailPhotoFileName")){ this._thumbnailPhotoFileName = StringUtil.StringValue(row["ThumbnailPhotoFileName"]); }
            if (cols.Contains("ModifiedDate")){ this._modifiedDate = DateUtil.DateValue(row["ModifiedDate"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "ProductID");if (cols.Contains(columnName)){ this._productID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "ProductNumber");if (cols.Contains(columnName)){ this._productNumber = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "Color");if (cols.Contains(columnName)){ this._color = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "StandardCost");if (cols.Contains(columnName)){ this._standardCost = NumberUtil.Value<Decimal>(row[columnName]); }
            columnName = BuildColumnName(alias, "ListPrice");if (cols.Contains(columnName)){ this._listPrice = NumberUtil.Value<Decimal>(row[columnName]); }
            columnName = BuildColumnName(alias, "Size");if (cols.Contains(columnName)){ this._size = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "Weight");if (cols.Contains(columnName)){ this._weight = NumberUtil.Value<Decimal?>(row[columnName]); }
            columnName = BuildColumnName(alias, "ProductCategoryID");if (cols.Contains(columnName)){ this._productCategoryID = NumberUtil.Value<Int32?>(row[columnName]); }
            columnName = BuildColumnName(alias, "ProductModelID");if (cols.Contains(columnName)){ this._productModelID = NumberUtil.Value<Int32?>(row[columnName]); }
            columnName = BuildColumnName(alias, "SellStartDate");if (cols.Contains(columnName)){ this._sellStartDate = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "SellEndDate");if (cols.Contains(columnName)){ this._sellEndDate = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DiscontinuedDate");if (cols.Contains(columnName)){ this._discontinuedDate = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ThumbnailPhotoFileName");if (cols.Contains(columnName)){ this._thumbnailPhotoFileName = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ModifiedDate");if (cols.Contains(columnName)){ this._modifiedDate = DateUtil.DateValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._productID = NumberUtil.Value<Int32>(reader[0]);
            this._productNumber = StringUtil.StringValue(reader[1]);
            this._color = StringUtil.StringValue(reader[2]);
            this._standardCost = NumberUtil.Value<Decimal>(reader[3]);
            this._listPrice = NumberUtil.Value<Decimal>(reader[4]);
            this._size = StringUtil.StringValue(reader[5]);
            this._weight = NumberUtil.Value<Decimal?>(reader[6]);
            this._productCategoryID = NumberUtil.Value<Int32?>(reader[7]);
            this._productModelID = NumberUtil.Value<Int32?>(reader[8]);
            this._sellStartDate = DateUtil.DateValue(reader[9]);
            this._sellEndDate = DateUtil.DateValue(reader[10]);
            this._discontinuedDate = DateUtil.DateValue(reader[11]);
            this._thumbnailPhotoFileName = StringUtil.StringValue(reader[12]);
            this._modifiedDate = DateUtil.DateValue(reader[13]);
            
            this.IsNew = false;
        }
    }

}